/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.impl.model;

import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.maven.api.model.Model;
import org.apache.maven.api.services.Interpolator;
import org.apache.maven.api.services.InterpolatorException;
import org.apache.maven.api.services.ModelBuilderException;
import org.apache.maven.api.services.ProjectBuilderException;
import org.apache.maven.api.services.model.PathTranslator;
import org.apache.maven.api.services.model.ProfileActivationContext;
import org.apache.maven.api.services.model.RootLocator;

public class DefaultProfileActivationContext
implements ProfileActivationContext {
    private final PathTranslator pathTranslator;
    private final RootLocator rootLocator;
    private final Interpolator interpolator;
    private List<String> activeProfileIds = Collections.emptyList();
    private List<String> inactiveProfileIds = Collections.emptyList();
    private Map<String, String> systemProperties = Collections.emptyMap();
    private Map<String, String> userProperties = Collections.emptyMap();
    private Model model;
    final Record record;

    public DefaultProfileActivationContext(PathTranslator pathTranslator, RootLocator rootLocator, Interpolator interpolator) {
        this.pathTranslator = pathTranslator;
        this.rootLocator = rootLocator;
        this.interpolator = interpolator;
        this.record = null;
    }

    public DefaultProfileActivationContext(PathTranslator pathTranslator, RootLocator rootLocator, Interpolator interpolator, List<String> activeProfileIds, List<String> inactiveProfileIds, Map<String, String> systemProperties, Map<String, String> userProperties, Model model) {
        this(pathTranslator, rootLocator, interpolator, activeProfileIds, inactiveProfileIds, systemProperties, userProperties, model, null);
    }

    private DefaultProfileActivationContext(PathTranslator pathTranslator, RootLocator rootLocator, Interpolator interpolator, List<String> activeProfileIds, List<String> inactiveProfileIds, Map<String, String> systemProperties, Map<String, String> userProperties, Model model, Record record) {
        this.pathTranslator = pathTranslator;
        this.rootLocator = rootLocator;
        this.interpolator = interpolator;
        this.activeProfileIds = activeProfileIds;
        this.inactiveProfileIds = inactiveProfileIds;
        this.systemProperties = systemProperties;
        this.userProperties = userProperties;
        this.model = model;
        this.record = record;
    }

    DefaultProfileActivationContext start() {
        return new DefaultProfileActivationContext(this.pathTranslator, this.rootLocator, this.interpolator, this.activeProfileIds, this.inactiveProfileIds, this.systemProperties, this.userProperties, this.model, new Record());
    }

    Record stop() {
        Objects.requireNonNull(this.record, "start() must be called before stop()");
        this.record.usedActiveProfiles.values().removeIf(value -> value == false);
        this.record.usedInactiveProfiles.values().removeIf(value -> value == false);
        return new Record(this.record);
    }

    @Override
    public boolean isProfileActive(String profileId) {
        if (this.record != null) {
            return this.record.usedActiveProfiles.computeIfAbsent(profileId, this.activeProfileIds::contains);
        }
        return this.activeProfileIds.contains(profileId);
    }

    @Override
    public boolean isProfileInactive(String profileId) {
        if (this.record != null) {
            return this.record.usedInactiveProfiles.computeIfAbsent(profileId, this.inactiveProfileIds::contains);
        }
        return this.inactiveProfileIds.contains(profileId);
    }

    @Override
    public String getSystemProperty(String key) {
        if (this.record != null) {
            return this.record.usedSystemProperties.computeIfAbsent(key, this.systemProperties::get);
        }
        return this.systemProperties.get(key);
    }

    public DefaultProfileActivationContext setSystemProperties(Map<String, String> systemProperties) {
        this.systemProperties = DefaultProfileActivationContext.unmodifiable(systemProperties);
        return this;
    }

    @Override
    public String getUserProperty(String key) {
        if (this.record != null) {
            return this.record.usedUserProperties.computeIfAbsent(key, this.userProperties::get);
        }
        return this.userProperties.get(key);
    }

    public DefaultProfileActivationContext setUserProperties(Map<String, String> userProperties) {
        this.userProperties = DefaultProfileActivationContext.unmodifiable(userProperties);
        return this;
    }

    @Override
    public String getModelArtifactId() {
        if (this.record != null) {
            return this.record.usedModelInfos.computeIfAbsent(ModelInfo.ArtifactId, k -> this.model.getArtifactId());
        }
        return this.model.getArtifactId();
    }

    @Override
    public String getModelPackaging() {
        if (this.record != null) {
            return this.record.usedModelInfos.computeIfAbsent(ModelInfo.Packaging, k -> this.model.getPackaging());
        }
        return this.model.getPackaging();
    }

    @Override
    public String getModelProperty(String key) {
        if (this.record != null) {
            return this.record.usedModelProperties.computeIfAbsent(key, k -> (String)this.model.getProperties().get(k));
        }
        return (String)this.model.getProperties().get(key);
    }

    @Override
    public String getModelBaseDirectory() {
        if (this.record != null) {
            return this.record.usedModelInfos.computeIfAbsent(ModelInfo.BaseDirectory, k -> this.doGetModelBaseDirectory());
        }
        return this.doGetModelBaseDirectory();
    }

    public String doGetModelBaseDirectory() {
        Path basedir = this.model.getProjectDirectory();
        return basedir != null ? basedir.toAbsolutePath().toString() : null;
    }

    @Override
    public String getModelRootDirectory() {
        if (this.record != null) {
            return this.record.usedModelInfos.computeIfAbsent(ModelInfo.RootDirectory, k -> this.doGetModelRootDirectory());
        }
        return this.doGetModelRootDirectory();
    }

    private String doGetModelRootDirectory() {
        Path basedir = this.model != null ? this.model.getProjectDirectory() : null;
        Path rootdir = this.rootLocator != null ? this.rootLocator.findRoot(basedir) : null;
        return rootdir != null ? rootdir.toAbsolutePath().toString() : null;
    }

    public DefaultProfileActivationContext setModel(Model model) {
        this.model = model;
        return this;
    }

    @Override
    public String interpolatePath(String path) throws InterpolatorException {
        if (path == null) {
            return null;
        }
        String absolutePath = this.interpolator.interpolate(path, s -> {
            if ("basedir".equals(s) || "project.basedir".equals(s)) {
                return this.getModelBaseDirectory();
            }
            if ("project.rootDirectory".equals(s)) {
                return this.getModelRootDirectory();
            }
            String r = this.getModelProperty((String)s);
            if (r == null) {
                r = this.getUserProperty((String)s);
            }
            if (r == null) {
                r = this.getSystemProperty((String)s);
            }
            return r;
        });
        return this.pathTranslator.alignToBaseDirectory(absolutePath, this.model.getProjectDirectory());
    }

    @Override
    public boolean exists(String path, boolean enableGlob) throws ModelBuilderException {
        if (this.record != null) {
            return this.record.usedExists.computeIfAbsent(new ExistRequest(path, enableGlob), r -> this.doExists(r.path, r.enableGlob));
        }
        return this.doExists(path, enableGlob);
    }

    private boolean doExists(String path, boolean enableGlob) throws ModelBuilderException {
        String glob;
        String fixed;
        String pattern = this.interpolatePath(path);
        if (enableGlob) {
            int firstWildcardIndex;
            int asteriskIndex = pattern.indexOf(42);
            int questionMarkIndex = pattern.indexOf(63);
            int n = questionMarkIndex < 0 ? asteriskIndex : (firstWildcardIndex = asteriskIndex < 0 ? questionMarkIndex : Math.min(asteriskIndex, questionMarkIndex));
            if (firstWildcardIndex < 0) {
                fixed = pattern;
                glob = "";
            } else {
                int lastSep = pattern.substring(0, firstWildcardIndex).lastIndexOf(File.separatorChar);
                if (lastSep < 0) {
                    fixed = "";
                    glob = pattern;
                } else {
                    fixed = pattern.substring(0, lastSep);
                    glob = pattern.substring(lastSep + 1);
                }
            }
        } else {
            fixed = pattern;
            glob = "";
        }
        Path fixedPath = Paths.get(fixed, new String[0]);
        return DefaultProfileActivationContext.doExists(fixedPath, glob);
    }

    private static Boolean doExists(final Path fixedPath, String glob) {
        if (fixedPath == null || !Files.exists(fixedPath, new LinkOption[0])) {
            return false;
        }
        if (glob != null && !glob.isEmpty()) {
            try {
                final PathMatcher matcher = fixedPath.getFileSystem().getPathMatcher("glob:" + glob);
                final AtomicBoolean found = new AtomicBoolean(false);
                Files.walkFileTree(fixedPath, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                    @Override
                    public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) {
                        if (found.get() || matcher.matches(fixedPath.relativize(file))) {
                            found.set(true);
                            return FileVisitResult.TERMINATE;
                        }
                        return FileVisitResult.CONTINUE;
                    }
                });
                return found.get();
            }
            catch (IOException e) {
                throw new ProjectBuilderException("Unable to verify file existence for '" + glob + "' inside '" + String.valueOf(fixedPath) + "'", (Exception)e);
            }
        }
        return true;
    }

    private static Map<String, String> unmodifiable(Map<String, String> map) {
        return map != null ? Collections.unmodifiableMap(map) : Collections.emptyMap();
    }

    static class Record {
        final Map<String, Boolean> usedActiveProfiles;
        final Map<String, Boolean> usedInactiveProfiles;
        final Map<String, String> usedSystemProperties;
        final Map<String, String> usedUserProperties;
        final Map<String, String> usedModelProperties;
        final Map<ModelInfo, String> usedModelInfos;
        final Map<ExistRequest, Boolean> usedExists;

        Record() {
            this.usedActiveProfiles = new HashMap<String, Boolean>();
            this.usedInactiveProfiles = new HashMap<String, Boolean>();
            this.usedSystemProperties = new HashMap<String, String>();
            this.usedUserProperties = new HashMap<String, String>();
            this.usedModelProperties = new HashMap<String, String>();
            this.usedModelInfos = new HashMap<ModelInfo, String>();
            this.usedExists = new HashMap<ExistRequest, Boolean>();
        }

        Record(Record source) {
            this.usedActiveProfiles = Map.copyOf(source.usedActiveProfiles);
            this.usedInactiveProfiles = Map.copyOf(source.usedInactiveProfiles);
            this.usedSystemProperties = Map.copyOf(source.usedSystemProperties);
            this.usedUserProperties = Map.copyOf(source.usedUserProperties);
            this.usedModelProperties = Map.copyOf(source.usedModelProperties);
            this.usedModelInfos = Map.copyOf(source.usedModelInfos);
            this.usedExists = Map.copyOf(source.usedExists);
        }

        public boolean equals(Object o) {
            if (o instanceof Record) {
                Record record = (Record)o;
                return Objects.equals(this.usedActiveProfiles, record.usedActiveProfiles) && Objects.equals(this.usedInactiveProfiles, record.usedInactiveProfiles) && Objects.equals(this.usedSystemProperties, record.usedSystemProperties) && Objects.equals(this.usedUserProperties, record.usedUserProperties) && Objects.equals(this.usedModelProperties, record.usedModelProperties) && Objects.equals(this.usedModelInfos, record.usedModelInfos) && Objects.equals(this.usedExists, record.usedExists);
            }
            return false;
        }

        public int hashCode() {
            return Objects.hash(this.usedActiveProfiles, this.usedInactiveProfiles, this.usedSystemProperties, this.usedUserProperties, this.usedModelProperties, this.usedModelInfos, this.usedExists);
        }

        boolean matches(DefaultProfileActivationContext context) {
            return this.matchesProfiles(this.usedActiveProfiles, context.activeProfileIds) && this.matchesProfiles(this.usedInactiveProfiles, context.inactiveProfileIds) && this.matchesProperties(this.usedSystemProperties, context.systemProperties) && this.matchesProperties(this.usedUserProperties, context.userProperties) && this.matchesProperties(this.usedModelProperties, context.model.getProperties()) && this.matchesModelInfos(this.usedModelInfos, context) && this.matchesExists(this.usedExists, context);
        }

        private boolean matchesProfiles(Map<String, Boolean> expected, List<String> actual) {
            return expected.entrySet().stream().allMatch(e -> Objects.equals(e.getValue(), actual.contains(e.getKey())));
        }

        private boolean matchesProperties(Map<String, String> expected, Map<String, String> actual) {
            return expected.entrySet().stream().allMatch(e -> Objects.equals(e.getValue(), actual.get(e.getKey())));
        }

        private boolean matchesModelInfos(Map<ModelInfo, String> infos, DefaultProfileActivationContext context) {
            return infos.entrySet().stream().allMatch(e -> Objects.equals(e.getValue(), this.getModelValue((ModelInfo)((Object)((Object)e.getKey())), context)));
        }

        private String getModelValue(ModelInfo key, DefaultProfileActivationContext context) {
            return switch (key.ordinal()) {
                default -> throw new IncompatibleClassChangeError();
                case 0 -> context.model.getArtifactId();
                case 1 -> context.model.getPackaging();
                case 2 -> context.doGetModelBaseDirectory();
                case 3 -> context.doGetModelRootDirectory();
            };
        }

        private boolean matchesExists(Map<ExistRequest, Boolean> exists, DefaultProfileActivationContext context) {
            return exists.entrySet().stream().allMatch(e -> Objects.equals(e.getValue(), context.doExists(((ExistRequest)e.getKey()).path(), ((ExistRequest)e.getKey()).enableGlob())));
        }
    }

    static enum ModelInfo {
        ArtifactId,
        Packaging,
        BaseDirectory,
        RootDirectory;

    }

    record ExistRequest(String path, boolean enableGlob) {
    }
}

