/*
 * Decompiled with CFR 0.152.
 */
package org.apache.manifoldcf.agents.agentmanager;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.manifoldcf.agents.interfaces.AgentFactory;
import org.apache.manifoldcf.agents.interfaces.IAgent;
import org.apache.manifoldcf.agents.interfaces.IAgentManager;
import org.apache.manifoldcf.core.database.BaseTable;
import org.apache.manifoldcf.core.interfaces.ColumnDescription;
import org.apache.manifoldcf.core.interfaces.IDBInterface;
import org.apache.manifoldcf.core.interfaces.IResultRow;
import org.apache.manifoldcf.core.interfaces.IResultSet;
import org.apache.manifoldcf.core.interfaces.IThreadContext;
import org.apache.manifoldcf.core.interfaces.ManifoldCFException;

public class AgentManager
extends BaseTable
implements IAgentManager {
    public static final String _rcsid = "@(#)$Id: AgentManager.java 988245 2010-08-23 18:39:35Z kwright $";
    protected static final String classNameField = "classname";
    protected IThreadContext threadContext;

    public AgentManager(IThreadContext threadContext, IDBInterface database) throws ManifoldCFException {
        super(database, "agents");
        this.threadContext = threadContext;
    }

    @Override
    public void install() throws ManifoldCFException {
        block0: {
            Map existing = this.getTableSchema(null, null);
            if (existing != null) break block0;
            HashMap<String, ColumnDescription> map = new HashMap<String, ColumnDescription>();
            map.put(classNameField, new ColumnDescription("VARCHAR(255)", true, false, null, null, false));
            this.performCreate(map, null);
        }
    }

    @Override
    public void deinstall() throws ManifoldCFException {
        this.beginTransaction();
        try {
            IResultSet set = this.performQuery("SELECT * FROM " + this.getTableName(), null, null, null);
            int i = 0;
            while (i < set.getRowCount()) {
                IResultRow row = set.getRow(i++);
                String className = row.getValue(classNameField).toString();
                IAgent agent = AgentFactory.make(className);
                agent.deinstall(this.threadContext);
            }
            this.performDrop(null);
        }
        catch (ManifoldCFException e) {
            this.signalRollback();
            throw e;
        }
        catch (Error e) {
            this.signalRollback();
            throw e;
        }
        finally {
            this.endTransaction();
        }
    }

    @Override
    public void registerAgent(String className) throws ManifoldCFException {
        this.beginTransaction();
        try {
            ArrayList<String> params = new ArrayList<String>();
            params.add(className);
            IResultSet set = this.performQuery("SELECT * FROM " + this.getTableName() + " WHERE classname=?", params, null, null);
            if (set.getRowCount() == 0) {
                HashMap<String, String> map = new HashMap<String, String>();
                map.put(classNameField, className);
                this.performInsert(map, null);
            }
            IAgent agent = AgentFactory.make(className);
            agent.install(this.threadContext);
        }
        catch (ManifoldCFException e) {
            this.signalRollback();
            throw e;
        }
        catch (Error e) {
            this.signalRollback();
            throw e;
        }
        finally {
            this.endTransaction();
        }
    }

    @Override
    public void unregisterAgent(String className) throws ManifoldCFException {
        this.beginTransaction();
        try {
            IAgent agent = AgentFactory.make(className);
            agent.deinstall(this.threadContext);
            this.removeAgent(className);
        }
        catch (ManifoldCFException e) {
            this.signalRollback();
            throw e;
        }
        catch (Error e) {
            this.signalRollback();
            throw e;
        }
        finally {
            this.endTransaction();
        }
    }

    @Override
    public void removeAgent(String className) throws ManifoldCFException {
        ArrayList<String> list = new ArrayList<String>();
        list.add(className);
        this.performDelete("WHERE classname=?", list, null);
    }

    @Override
    public String[] getAllAgents() throws ManifoldCFException {
        IResultSet set = this.performQuery("SELECT * FROM " + this.getTableName(), null, null, null);
        String[] rval = new String[set.getRowCount()];
        for (int i = 0; i < set.getRowCount(); ++i) {
            IResultRow row = set.getRow(i);
            rval[i] = row.getValue(classNameField).toString();
        }
        return rval;
    }
}

