/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.metadata.iso.identification;

import java.nio.charset.Charset;
import java.util.Collection;
import java.util.Collections;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import org.apache.sis.internal.jaxb.FilterByVersion;
import org.apache.sis.internal.jaxb.code.MD_CharacterSetCode;
import org.apache.sis.internal.jaxb.lan.LocaleAndCharset;
import org.apache.sis.internal.jaxb.lan.OtherLocales;
import org.apache.sis.internal.jaxb.lan.PT_Locale;
import org.apache.sis.internal.metadata.Dependencies;
import org.apache.sis.metadata.iso.identification.AbstractIdentification;
import org.opengis.annotation.Obligation;
import org.opengis.annotation.Specification;
import org.opengis.annotation.UML;
import org.opengis.metadata.citation.Citation;
import org.opengis.metadata.identification.CharacterSet;
import org.opengis.metadata.identification.DataIdentification;
import org.opengis.metadata.identification.Identification;
import org.opengis.metadata.identification.TopicCategory;
import org.opengis.util.InternationalString;

@XmlType(name="MD_DataIdentification_Type", propOrder={"languages", "characterSet", "defaultLocale", "otherLocales", "environmentDescription", "supplementalInformation"})
@XmlRootElement(name="MD_DataIdentification")
public class DefaultDataIdentification
extends AbstractIdentification
implements DataIdentification {
    private static final long serialVersionUID = 7302901752833238436L;
    private Map<Locale, Charset> locales;
    private InternationalString environmentDescription;
    private InternationalString supplementalInformation;

    public DefaultDataIdentification() {
    }

    public DefaultDataIdentification(Citation citation, CharSequence charSequence, Locale locale, TopicCategory topicCategory) {
        super(citation, charSequence);
        if (locale != null) {
            this.locales = this.writeMap(Collections.singletonMap(locale, null), null, Locale.class);
        }
        super.setTopicCategories(this.singleton(topicCategory, TopicCategory.class));
    }

    public DefaultDataIdentification(DataIdentification dataIdentification) {
        super((Identification)dataIdentification);
        if (dataIdentification != null) {
            if (dataIdentification instanceof DefaultDataIdentification) {
                this.locales = this.copyMap(((DefaultDataIdentification)dataIdentification).getLocalesAndCharsets(), Locale.class);
            } else {
                this.setLanguages(dataIdentification.getLanguages());
            }
            this.environmentDescription = dataIdentification.getEnvironmentDescription();
            this.supplementalInformation = dataIdentification.getSupplementalInformation();
        }
    }

    public static DefaultDataIdentification castOrCopy(DataIdentification dataIdentification) {
        if (dataIdentification == null || dataIdentification instanceof DefaultDataIdentification) {
            return (DefaultDataIdentification)dataIdentification;
        }
        return new DefaultDataIdentification(dataIdentification);
    }

    @UML(identifier="defaultLocale+otherLocale", obligation=Obligation.CONDITIONAL, specification=Specification.ISO_19115)
    public Map<Locale, Charset> getLocalesAndCharsets() {
        this.locales = this.nonNullMap(this.locales, Locale.class);
        return this.locales;
    }

    public void setLocalesAndCharsets(Map<? extends Locale, ? extends Charset> map) {
        this.locales = this.writeMap(map, this.locales, Locale.class);
    }

    @Deprecated
    @Dependencies(value={"getLocalesAndCharsets"})
    @XmlElement(name="language", namespace="http://www.isotc211.org/2005/gmd")
    public Collection<Locale> getLanguages() {
        return FilterByVersion.LEGACY_METADATA.accept() ? LocaleAndCharset.getLanguages(this.getLocalesAndCharsets()) : null;
    }

    @Deprecated
    public void setLanguages(Collection<? extends Locale> collection) {
        this.setLocalesAndCharsets(LocaleAndCharset.setLanguages(this.getLocalesAndCharsets(), collection));
    }

    @Deprecated
    @Dependencies(value={"getLocalesAndCharsets"})
    public Collection<CharacterSet> getCharacterSets() {
        return this.getLocalesAndCharsets().values().stream().map(MD_CharacterSetCode::fromCharset).collect(Collectors.toSet());
    }

    @Deprecated
    public void setCharacterSets(Collection<? extends CharacterSet> collection) {
        Collection collection2 = null;
        if (collection != null) {
            collection2 = collection.stream().map(CharacterSet::toCharset).collect(Collectors.toSet());
        }
        this.setLocalesAndCharsets(LocaleAndCharset.setCharacterSets(this.getLocalesAndCharsets(), collection2));
    }

    @XmlElement(name="environmentDescription")
    public InternationalString getEnvironmentDescription() {
        return this.environmentDescription;
    }

    public void setEnvironmentDescription(InternationalString internationalString) {
        this.checkWritePermission(this.environmentDescription);
        this.environmentDescription = internationalString;
    }

    @XmlElement(name="supplementalInformation")
    public InternationalString getSupplementalInformation() {
        return this.supplementalInformation;
    }

    public void setSupplementalInformation(InternationalString internationalString) {
        this.checkWritePermission(this.supplementalInformation);
        this.supplementalInformation = internationalString;
    }

    @XmlElement(name="defaultLocale")
    private PT_Locale getDefaultLocale() {
        return FilterByVersion.CURRENT_METADATA.accept() ? PT_Locale.first(this.getLocalesAndCharsets()) : null;
    }

    private void setDefaultLocale(PT_Locale pT_Locale) {
        this.setLocalesAndCharsets(OtherLocales.setFirst(this.locales, pT_Locale));
    }

    @XmlElement(name="otherLocale")
    private Collection<PT_Locale> getOtherLocales() {
        return FilterByVersion.CURRENT_METADATA.accept() ? OtherLocales.filter(this.getLocalesAndCharsets()) : null;
    }

    @XmlElement(name="characterSet", namespace="http://www.isotc211.org/2005/gmd")
    private Collection<Charset> getCharacterSet() {
        return FilterByVersion.LEGACY_METADATA.accept() ? LocaleAndCharset.getCharacterSets(this.getLocalesAndCharsets()) : null;
    }
}

