/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.cas.impl;

import java.lang.reflect.Array;
import org.apache.uima.cas.impl.CASImpl;
import org.apache.uima.cas.impl.FeatureStructureImplC;

public abstract class CommonAuxArrayFSImpl
extends FeatureStructureImplC {
    protected CommonAuxArrayFSImpl() {
    }

    protected CommonAuxArrayFSImpl(CASImpl cas, int addr) {
        super(cas, addr);
    }

    public int size() {
        return this.casImpl.ll_getArraySize(this.addr);
    }

    protected void copyFromJavaArray(Object src, int srcOffset, Object casAuxHeap, int tgtOffset, int length) {
        this.casImpl.checkArrayBounds(this.addr, tgtOffset, length);
        int startOffset = this.casImpl.getHeap().heap[this.casImpl.getArrayStartAddress(this.addr)];
        System.arraycopy(src, srcOffset, casAuxHeap, startOffset + tgtOffset, length);
    }

    protected void copyToJavaArray(Object casAuxHeap, int srcOffset, Object tgt, int tgtOffset, int length) {
        this.casImpl.checkArrayBounds(this.addr, srcOffset, length);
        int startOffset = this.casImpl.getHeap().heap[this.casImpl.getArrayStartAddress(this.addr)];
        System.arraycopy(casAuxHeap, startOffset + srcOffset, tgt, tgtOffset, length);
    }

    protected Object toArray(Object casAuxHeap) {
        int size = this.size();
        Object outArray = Array.newInstance(casAuxHeap.getClass().getComponentType(), size);
        this.copyToJavaArray(casAuxHeap, 0, outArray, 0, size);
        return outArray;
    }

    public abstract void copyToArray(int var1, String[] var2, int var3, int var4);

    public String[] toStringArray() {
        int size = this.size();
        String[] strArray = new String[size];
        this.copyToArray(0, strArray, 0, size);
        return strArray;
    }
}

