/*
 * Decompiled with CFR 0.152.
 */
package org.apache.manifoldcf.crawler.notifications.slack;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.nio.charset.StandardCharsets;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLSocketFactory;
import org.apache.commons.lang.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.NTCredentials;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.entity.EntityBuilder;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.socket.LayeredConnectionSocketFactory;
import org.apache.http.conn.ssl.NoopHostnameVerifier;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.entity.ContentType;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.util.EntityUtils;
import org.apache.manifoldcf.connectorcommon.common.InterruptibleSocketFactory;
import org.apache.manifoldcf.connectorcommon.interfaces.KeystoreManagerFactory;
import org.apache.manifoldcf.core.interfaces.ManifoldCFException;
import org.apache.manifoldcf.crawler.notifications.slack.SlackMessage;
import org.apache.manifoldcf.crawler.system.Logging;

public class SlackSession {
    private static String currentHost = null;
    private CloseableHttpClient httpClient;
    private ObjectMapper objectMapper;
    private final String webHookUrl;

    public SlackSession(String webHookUrl, ProxySettings proxySettingsOrNull) throws ManifoldCFException {
        this.webHookUrl = webHookUrl;
        this.objectMapper = new ObjectMapper();
        this.objectMapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        int connectionTimeout = 60000;
        int socketTimeout = 900000;
        RequestConfig.Builder requestBuilder = RequestConfig.custom().setSocketTimeout(socketTimeout).setConnectTimeout(connectionTimeout).setConnectionRequestTimeout(socketTimeout);
        if (proxySettingsOrNull != null) {
            this.addProxySettings(requestBuilder, proxySettingsOrNull);
        }
        SSLSocketFactory httpsSocketFactory = KeystoreManagerFactory.getTrustingSecureSocketFactory();
        SSLConnectionSocketFactory myFactory = new SSLConnectionSocketFactory((SSLSocketFactory)new InterruptibleSocketFactory(httpsSocketFactory, (long)connectionTimeout), (HostnameVerifier)NoopHostnameVerifier.INSTANCE);
        this.httpClient = HttpClientBuilder.create().setDefaultRequestConfig(requestBuilder.build()).setSSLSocketFactory((LayeredConnectionSocketFactory)myFactory).build();
    }

    private void addProxySettings(RequestConfig.Builder requestBuilder, ProxySettings proxySettingsOrNull) {
        if (proxySettingsOrNull.hasUsername()) {
            BasicCredentialsProvider credentialsProvider = new BasicCredentialsProvider();
            credentialsProvider.setCredentials(new AuthScope(proxySettingsOrNull.getHost(), proxySettingsOrNull.getPort()), (Credentials)new NTCredentials(proxySettingsOrNull.getUsername(), proxySettingsOrNull.getPassword() == null ? "" : proxySettingsOrNull.getPassword(), currentHost, proxySettingsOrNull.getDomain() == null ? "" : proxySettingsOrNull.getDomain()));
        }
        HttpHost proxy = new HttpHost(proxySettingsOrNull.getHost(), proxySettingsOrNull.getPort());
        requestBuilder.setProxy(proxy);
    }

    public void checkConnection() throws IOException {
        boolean isConnectionOk;
        int statusCode;
        HttpPost postRequest = new HttpPost(this.webHookUrl);
        String responseBody = null;
        try (CloseableHttpResponse response = this.httpClient.execute((HttpUriRequest)postRequest);){
            responseBody = EntityUtils.toString((HttpEntity)response.getEntity());
            statusCode = response.getStatusLine().getStatusCode();
        }
        boolean isExpectedStatus = statusCode == 400;
        boolean isExpectedPayload = "invalid_payload".equals(responseBody);
        boolean bl = isConnectionOk = isExpectedStatus && isExpectedPayload;
        if (!isConnectionOk) {
            Object statusInfo = isExpectedStatus ? "ok" : statusCode + " is unexpected";
            String payloadInfo = isExpectedPayload ? "ok" : "is unexpected";
            String message = "connection failed: status " + (String)statusInfo + ", payload " + payloadInfo;
            throw new ClientProtocolException(message);
        }
    }

    public void send(String channel, String message) throws IOException {
        HttpPost messagePost = new HttpPost(this.webHookUrl);
        SlackMessage slackMessage = new SlackMessage();
        if (StringUtils.isNotBlank((String)channel)) {
            slackMessage.setChannel(channel);
        }
        slackMessage.setText(message);
        String json = this.objectMapper.writeValueAsString((Object)slackMessage);
        HttpEntity entity = EntityBuilder.create().setContentType(ContentType.APPLICATION_JSON).setContentEncoding(StandardCharsets.UTF_8.name()).setText(json).build();
        messagePost.setEntity(entity);
        try (CloseableHttpResponse response = this.httpClient.execute((HttpUriRequest)messagePost);){
            int statusCode = response.getStatusLine().getStatusCode();
            if (statusCode == 200 || statusCode == 201) {
                EntityUtils.consume((HttpEntity)response.getEntity());
            } else {
                Logging.connectors.error((Object)("Sending slack message failed with statusline " + response.getStatusLine()));
                Logging.connectors.debug((Object)("  Response was: " + EntityUtils.toString((HttpEntity)response.getEntity())));
            }
        }
    }

    public void close() throws IOException {
        this.httpClient.close();
        this.httpClient = null;
        this.objectMapper = null;
    }

    static {
        try {
            InetAddress addr = InetAddress.getLocalHost();
            currentHost = addr.getHostName();
        }
        catch (UnknownHostException unknownHostException) {
            // empty catch block
        }
    }

    protected static final class ProxySettings {
        private String host;
        private int port = -1;
        private String username;
        private String password;
        private String domain;

        public ProxySettings(String host, String portString, String username, String password, String domain) {
            this.host = host;
            if (StringUtils.isNotEmpty((String)portString)) {
                try {
                    this.port = Integer.parseInt(portString);
                }
                catch (NumberFormatException e) {
                    Logging.connectors.warn((Object)("Proxy port must be an number. Found " + portString));
                }
            }
            this.username = username;
            this.password = password;
            this.domain = domain;
        }

        public String getHost() {
            return this.host;
        }

        public int getPort() {
            return this.port;
        }

        public String getUsername() {
            return this.username;
        }

        public boolean hasUsername() {
            return StringUtils.isNotEmpty((String)this.username);
        }

        public String getPassword() {
            return this.password;
        }

        public String getDomain() {
            return this.domain;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder("ProxySettings{");
            sb.append("host='").append(this.host).append('\'');
            sb.append(", port=").append(this.port);
            sb.append(", username='").append(this.username).append('\'');
            sb.append(", password='").append(this.password).append('\'');
            sb.append(", domain='").append(this.domain).append('\'');
            sb.append('}');
            return sb.toString();
        }
    }
}

