/*
 * Decompiled with CFR 0.152.
 */
package org.apache.manifoldcf.agents;

import org.apache.manifoldcf.agents.BaseAgentsInitializationCommand;
import org.apache.manifoldcf.agents.interfaces.AgentManagerFactory;
import org.apache.manifoldcf.agents.interfaces.ITransformationConnectionManager;
import org.apache.manifoldcf.agents.interfaces.ITransformationConnectorManager;
import org.apache.manifoldcf.agents.interfaces.TransformationConnectionManagerFactory;
import org.apache.manifoldcf.agents.interfaces.TransformationConnectorFactory;
import org.apache.manifoldcf.agents.interfaces.TransformationConnectorManagerFactory;
import org.apache.manifoldcf.agents.system.Logging;
import org.apache.manifoldcf.agents.system.ManifoldCF;
import org.apache.manifoldcf.core.interfaces.DBInterfaceFactory;
import org.apache.manifoldcf.core.interfaces.IDBInterface;
import org.apache.manifoldcf.core.interfaces.IResultRow;
import org.apache.manifoldcf.core.interfaces.IResultSet;
import org.apache.manifoldcf.core.interfaces.IThreadContext;
import org.apache.manifoldcf.core.interfaces.ManifoldCFException;

public class SynchronizeTransformations
extends BaseAgentsInitializationCommand {
    public static final String _rcsid = "@(#)$Id$";

    @Override
    protected void doExecute(IThreadContext tc) throws ManifoldCFException {
        IDBInterface database = DBInterfaceFactory.make((IThreadContext)tc, (String)ManifoldCF.getMasterDatabaseName(), (String)ManifoldCF.getMasterDatabaseUsername(), (String)ManifoldCF.getMasterDatabasePassword());
        ITransformationConnectorManager mgr = TransformationConnectorManagerFactory.make(tc);
        ITransformationConnectionManager connManager = TransformationConnectionManagerFactory.make(tc);
        IResultSet classNames = mgr.getConnectors();
        int i = 0;
        while (i < classNames.getRowCount()) {
            IResultRow row = classNames.getRow(i++);
            String className = (String)row.getValue("classname");
            try {
                TransformationConnectorFactory.getConnectorNoCheck(className);
            }
            catch (ManifoldCFException e) {
                database.beginTransaction();
                try {
                    String[] connectionNames = connManager.findConnectionsForConnector(className);
                    AgentManagerFactory.noteTransformationConnectorDeregistration(tc, connectionNames);
                    mgr.removeConnector(className);
                }
                catch (ManifoldCFException e2) {
                    database.signalRollback();
                    throw e2;
                }
                catch (Error e2) {
                    database.signalRollback();
                    throw e2;
                }
                finally {
                    database.endTransaction();
                }
            }
        }
        Logging.root.info((Object)"Successfully synchronized all transformations");
    }

    public static void main(String[] args) {
        if (args.length > 0) {
            System.err.println("Usage: SynchronizeTransformations");
            System.exit(1);
        }
        try {
            SynchronizeTransformations synchronizeTransformations = new SynchronizeTransformations();
            synchronizeTransformations.execute();
            System.err.println("Successfully synchronized all transformations");
        }
        catch (ManifoldCFException e) {
            e.printStackTrace();
            System.exit(1);
        }
    }
}

