/*
 * Decompiled with CFR 0.152.
 */
package org.apache.manifoldcf.crawler.interfaces;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import org.apache.manifoldcf.core.interfaces.CharacterInput;
import org.apache.manifoldcf.core.interfaces.IResultSet;
import org.apache.manifoldcf.core.interfaces.ManifoldCFException;
import org.apache.manifoldcf.crawler.interfaces.BlockingDocuments;
import org.apache.manifoldcf.crawler.interfaces.BucketDescription;
import org.apache.manifoldcf.crawler.interfaces.DepthStatistics;
import org.apache.manifoldcf.crawler.interfaces.DocumentDescription;
import org.apache.manifoldcf.crawler.interfaces.DocumentSetAndFlags;
import org.apache.manifoldcf.crawler.interfaces.IJobDescription;
import org.apache.manifoldcf.crawler.interfaces.IPriorityCalculator;
import org.apache.manifoldcf.crawler.interfaces.JobDeleteRecord;
import org.apache.manifoldcf.crawler.interfaces.JobNotifyRecord;
import org.apache.manifoldcf.crawler.interfaces.JobSeedingRecord;
import org.apache.manifoldcf.crawler.interfaces.JobStartRecord;
import org.apache.manifoldcf.crawler.interfaces.JobStatus;
import org.apache.manifoldcf.crawler.interfaces.PerformanceStatistics;
import org.apache.manifoldcf.crawler.interfaces.SortOrder;
import org.apache.manifoldcf.crawler.interfaces.StatusFilterCriteria;

public interface IJobManager {
    public static final String _rcsid = "@(#)$Id: IJobManager.java 991295 2010-08-31 19:12:14Z kwright $";
    public static final int ACTION_RESCAN = 0;
    public static final int ACTION_REMOVE = 1;
    public static final int DOCSTATE_NEVERPROCESSED = 0;
    public static final int DOCSTATE_PREVIOUSLYPROCESSED = 1;
    public static final int DOCSTATE_OUTOFSCOPE = 2;
    public static final int DOCSTATUS_INACTIVE = 0;
    public static final int DOCSTATUS_PROCESSING = 1;
    public static final int DOCSTATUS_EXPIRING = 2;
    public static final int DOCSTATUS_DELETING = 3;
    public static final int DOCSTATUS_READYFORPROCESSING = 4;
    public static final int DOCSTATUS_READYFOREXPIRATION = 5;
    public static final int DOCSTATUS_WAITINGFORPROCESSING = 6;
    public static final int DOCSTATUS_WAITINGFOREXPIRATION = 7;
    public static final int DOCSTATUS_WAITINGFOREVER = 8;
    public static final int DOCSTATUS_HOPCOUNTEXCEEDED = 9;
    public static final int STOP_ERRORABORT = 0;
    public static final int STOP_MANUALABORT = 1;
    public static final int STOP_MANUALPAUSE = 2;
    public static final int STOP_SCHEDULEPAUSE = 3;
    public static final int STOP_RESTART = 4;

    public void install() throws ManifoldCFException;

    public void deinstall() throws ManifoldCFException;

    public void exportConfiguration(OutputStream var1) throws IOException, ManifoldCFException;

    public void importConfiguration(InputStream var1) throws IOException, ManifoldCFException;

    public IJobDescription[] getAllJobs() throws ManifoldCFException;

    public IJobDescription createJob() throws ManifoldCFException;

    public void deleteJob(Long var1) throws ManifoldCFException;

    public IJobDescription load(Long var1) throws ManifoldCFException;

    public IJobDescription load(Long var1, boolean var2) throws ManifoldCFException;

    public void save(IJobDescription var1) throws ManifoldCFException;

    public boolean checkIfReference(String var1) throws ManifoldCFException;

    public boolean checkIfNotificationReference(String var1) throws ManifoldCFException;

    public boolean checkIfOutputReference(String var1) throws ManifoldCFException;

    public boolean checkIfTransformationReference(String var1) throws ManifoldCFException;

    public IJobDescription[] findJobsForConnection(String var1) throws ManifoldCFException;

    public void clearJobSeedingState(Long var1) throws ManifoldCFException;

    public void cleanupProcessData(String var1) throws ManifoldCFException;

    public void cleanupProcessData() throws ManifoldCFException;

    public void prepareForClusterStart() throws ManifoldCFException;

    public void resetDocumentWorkerStatus(String var1) throws ManifoldCFException;

    public void resetSeedingWorkerStatus(String var1) throws ManifoldCFException;

    public void resetDocDeleteWorkerStatus(String var1) throws ManifoldCFException;

    public void resetDocCleanupWorkerStatus(String var1) throws ManifoldCFException;

    public void resetDeleteStartupWorkerStatus(String var1) throws ManifoldCFException;

    public void resetNotificationWorkerStatus(String var1) throws ManifoldCFException;

    public void resetStartupWorkerStatus(String var1) throws ManifoldCFException;

    public void clearAllDocumentPriorities() throws ManifoldCFException;

    public DocumentDescription[] getNextNotYetProcessedReprioritizationDocuments(String var1, int var2) throws ManifoldCFException;

    public void writeDocumentPriorities(DocumentDescription[] var1, IPriorityCalculator[] var2) throws ManifoldCFException;

    public DocumentSetAndFlags getExpiredDocuments(String var1, int var2, long var3) throws ManifoldCFException;

    public DocumentDescription[] getNextDocuments(String var1, int var2, long var3, long var5, BlockingDocuments var7, PerformanceStatistics var8, DepthStatistics var9) throws ManifoldCFException;

    public boolean checkJobActive(Long var1) throws ManifoldCFException;

    public boolean checkJobBusy(Long var1) throws ManifoldCFException;

    public void markDocumentCompletedMultiple(DocumentDescription[] var1) throws ManifoldCFException;

    public void markDocumentCompleted(DocumentDescription var1) throws ManifoldCFException;

    public DocumentDescription[] markDocumentDeletedMultiple(Long var1, String[] var2, DocumentDescription[] var3, int var4) throws ManifoldCFException;

    public DocumentDescription[] markDocumentDeleted(Long var1, String[] var2, DocumentDescription var3, int var4) throws ManifoldCFException;

    public DocumentDescription[] markDocumentHopcountRemovalMultiple(Long var1, String[] var2, DocumentDescription[] var3, int var4) throws ManifoldCFException;

    public DocumentDescription[] markDocumentHopcountRemoval(Long var1, String[] var2, DocumentDescription var3, int var4) throws ManifoldCFException;

    public DocumentDescription[] markDocumentExpiredMultiple(Long var1, String[] var2, DocumentDescription[] var3, int var4) throws ManifoldCFException;

    public DocumentDescription[] markDocumentExpired(Long var1, String[] var2, DocumentDescription var3, int var4) throws ManifoldCFException;

    public DocumentDescription[] markDocumentCleanedUpMultiple(Long var1, String[] var2, DocumentDescription[] var3, int var4) throws ManifoldCFException;

    public DocumentDescription[] markDocumentCleanedUp(Long var1, String[] var2, DocumentDescription var3, int var4) throws ManifoldCFException;

    public void carrydownChangeDocumentMultiple(DocumentDescription[] var1, IPriorityCalculator[] var2) throws ManifoldCFException;

    public void carrydownChangeDocument(DocumentDescription var1, IPriorityCalculator var2) throws ManifoldCFException;

    public void requeueDocumentMultiple(DocumentDescription[] var1, Long[] var2, int[] var3) throws ManifoldCFException;

    public void requeueDocument(DocumentDescription var1, Long var2, int var3) throws ManifoldCFException;

    public void resetDocumentMultiple(DocumentDescription[] var1, long var2, int var4, long var5, int var7) throws ManifoldCFException;

    public void resetDocument(DocumentDescription var1, long var2, int var4, long var5, int var7) throws ManifoldCFException;

    public void resetDeletingDocumentMultiple(DocumentDescription[] var1, long var2) throws ManifoldCFException;

    public void resetDeletingDocument(DocumentDescription var1, long var2) throws ManifoldCFException;

    public void resetCleaningDocument(DocumentDescription var1, long var2) throws ManifoldCFException;

    public void resetCleaningDocumentMultiple(DocumentDescription[] var1, long var2) throws ManifoldCFException;

    public void retryStartup(JobStartRecord var1, long var2, int var4) throws ManifoldCFException;

    public void retrySeeding(JobSeedingRecord var1, long var2, int var4) throws ManifoldCFException;

    public void retryNotification(JobNotifyRecord var1, long var2, int var4) throws ManifoldCFException;

    public void retryDeleteNotification(JobNotifyRecord var1, long var2, int var4) throws ManifoldCFException;

    public void addDocumentsInitial(String var1, Long var2, String[] var3, String[] var4, String[] var5, boolean var6, int var7, IPriorityCalculator[] var8, String[][] var9) throws ManifoldCFException;

    public void addRemainingDocumentsInitial(String var1, Long var2, String[] var3, String[] var4, int var5) throws ManifoldCFException;

    public void doneDocumentsInitial(Long var1, String[] var2, boolean var3, int var4) throws ManifoldCFException;

    public boolean beginEventSequence(String var1, String var2) throws ManifoldCFException;

    public void completeEventSequence(String var1) throws ManifoldCFException;

    public boolean[] findHopCounts(Long var1, String[] var2, String[] var3, String var4, int var5, int var6) throws ManifoldCFException;

    public String[] getAllSeeds(Long var1) throws ManifoldCFException;

    public void addDocument(String var1, Long var2, String[] var3, String var4, String var5, String var6, String var7, int var8, String[] var9, Object[][] var10, IPriorityCalculator var11, String[] var12) throws ManifoldCFException;

    public void addDocuments(String var1, Long var2, String[] var3, String[] var4, String[] var5, String var6, String var7, int var8, String[][] var9, Object[][][] var10, IPriorityCalculator[] var11, String[][] var12) throws ManifoldCFException;

    public DocumentDescription[] finishDocuments(Long var1, String[] var2, String[] var3, int var4) throws ManifoldCFException;

    public void revertDocuments(Long var1, String[] var2, String[] var3) throws ManifoldCFException;

    public String[] retrieveParentData(Long var1, String var2, String var3) throws ManifoldCFException;

    public CharacterInput[] retrieveParentDataAsFiles(Long var1, String var2, String var3) throws ManifoldCFException;

    public void manualStart(Long var1, boolean var2) throws ManifoldCFException;

    public void manualStart(Long var1) throws ManifoldCFException;

    public void manualAbort(Long var1) throws ManifoldCFException;

    public void manualAbortRestart(Long var1, boolean var2) throws ManifoldCFException;

    public void manualAbortRestart(Long var1) throws ManifoldCFException;

    public void pauseJob(Long var1) throws ManifoldCFException;

    public void restartJob(Long var1) throws ManifoldCFException;

    public void resetJobSchedule(Long var1) throws ManifoldCFException;

    public void startJobs(long var1, List<Long> var3) throws ManifoldCFException;

    public void waitJobs(long var1, List<Long> var3) throws ManifoldCFException;

    public JobSeedingRecord[] getJobsReadyForSeeding(String var1, long var2) throws ManifoldCFException;

    public void resetSeedJob(Long var1) throws ManifoldCFException;

    public JobDeleteRecord[] getJobsReadyForDeleteCleanup(String var1) throws ManifoldCFException;

    public JobStartRecord[] getJobsReadyForStartup(String var1) throws ManifoldCFException;

    public JobNotifyRecord[] getJobsReadyForInactivity(String var1) throws ManifoldCFException;

    public JobNotifyRecord[] getJobsReadyForDelete(String var1) throws ManifoldCFException;

    public void inactivateJob(Long var1) throws ManifoldCFException;

    public void removeJob(Long var1) throws ManifoldCFException;

    public void resetStartDeleteJob(Long var1) throws ManifoldCFException;

    public void resetNotifyJob(Long var1) throws ManifoldCFException;

    public void resetDeleteNotifyJob(Long var1) throws ManifoldCFException;

    public void resetStartupJob(Long var1) throws ManifoldCFException;

    public void prepareDeleteScan(Long var1) throws ManifoldCFException;

    public void prepareJobScan(Long var1, String[] var2, int var3, int var4, boolean var5, boolean var6, boolean var7) throws ManifoldCFException;

    public void noteJobDeleteStarted(Long var1, long var2) throws ManifoldCFException;

    public void noteJobStarted(Long var1, long var2, String var4) throws ManifoldCFException;

    public void noteJobSeeded(Long var1, String var2) throws ManifoldCFException;

    public void noteConnectorDeregistration(String[] var1) throws ManifoldCFException;

    public void noteConnectorRegistration(String[] var1) throws ManifoldCFException;

    public void noteNotificationConnectorDeregistration(String[] var1) throws ManifoldCFException;

    public void noteNotificationConnectorRegistration(String[] var1) throws ManifoldCFException;

    public void noteConnectionChange(String var1) throws ManifoldCFException;

    public void noteNotificationConnectionChange(String var1) throws ManifoldCFException;

    public void noteOutputConnectorDeregistration(String[] var1) throws ManifoldCFException;

    public void noteOutputConnectorRegistration(String[] var1) throws ManifoldCFException;

    public void noteOutputConnectionChange(String var1) throws ManifoldCFException;

    public void noteTransformationConnectorDeregistration(String[] var1) throws ManifoldCFException;

    public void noteTransformationConnectorRegistration(String[] var1) throws ManifoldCFException;

    public void noteTransformationConnectionChange(String var1) throws ManifoldCFException;

    public void assessMarkedJobs() throws ManifoldCFException;

    public void deleteJobsReadyForDelete() throws ManifoldCFException;

    public DocumentDescription[] getNextDeletableDocuments(String var1, int var2, long var3) throws ManifoldCFException;

    public DocumentSetAndFlags getNextCleanableDocuments(String var1, int var2, long var3) throws ManifoldCFException;

    public void deleteIngestedDocumentIdentifiers(DocumentDescription[] var1) throws ManifoldCFException;

    public boolean errorAbort(Long var1, String var2) throws ManifoldCFException;

    public void finishJobStops(long var1, List<IJobDescription> var3, List<Integer> var4) throws ManifoldCFException;

    public void finishJobResumes(long var1, List<IJobDescription> var3) throws ManifoldCFException;

    public void finishJobs() throws ManifoldCFException;

    public void resetJobs(long var1, List<IJobDescription> var3) throws ManifoldCFException;

    public JobStatus getStatus(Long var1) throws ManifoldCFException;

    public JobStatus[] getAllStatus() throws ManifoldCFException;

    public JobStatus[] getRunningJobs() throws ManifoldCFException;

    public JobStatus[] getFinishedJobs() throws ManifoldCFException;

    public JobStatus getStatus(Long var1, boolean var2) throws ManifoldCFException;

    public JobStatus[] getAllStatus(boolean var1) throws ManifoldCFException;

    public JobStatus[] getRunningJobs(boolean var1) throws ManifoldCFException;

    public JobStatus[] getFinishedJobs(boolean var1) throws ManifoldCFException;

    public JobStatus getStatus(Long var1, boolean var2, int var3) throws ManifoldCFException;

    public JobStatus[] getAllStatus(boolean var1, int var2) throws ManifoldCFException;

    public JobStatus[] getRunningJobs(boolean var1, int var2) throws ManifoldCFException;

    public JobStatus[] getFinishedJobs(boolean var1, int var2) throws ManifoldCFException;

    public IResultSet genDocumentStatus(String var1, StatusFilterCriteria var2, SortOrder var3, int var4, int var5) throws ManifoldCFException;

    public IResultSet genQueueStatus(String var1, StatusFilterCriteria var2, SortOrder var3, BucketDescription var4, int var5, int var6) throws ManifoldCFException;
}

