/*
 * Decompiled with CFR 0.152.
 */
package org.apache.manifoldcf.authorities.authgroups;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.manifoldcf.authorities.authgroups.AuthorityGroup;
import org.apache.manifoldcf.authorities.interfaces.AuthorityConnectionManagerFactory;
import org.apache.manifoldcf.authorities.interfaces.CacheKeyFactory;
import org.apache.manifoldcf.authorities.interfaces.IAuthorityConnectionManager;
import org.apache.manifoldcf.authorities.interfaces.IAuthorityGroup;
import org.apache.manifoldcf.authorities.interfaces.IAuthorityGroupManager;
import org.apache.manifoldcf.authorities.system.ManifoldCF;
import org.apache.manifoldcf.core.cachemanager.BaseDescription;
import org.apache.manifoldcf.core.cachemanager.ExecutorBase;
import org.apache.manifoldcf.core.database.BaseTable;
import org.apache.manifoldcf.core.interfaces.CacheManagerFactory;
import org.apache.manifoldcf.core.interfaces.ClauseDescription;
import org.apache.manifoldcf.core.interfaces.ColumnDescription;
import org.apache.manifoldcf.core.interfaces.ICacheDescription;
import org.apache.manifoldcf.core.interfaces.ICacheExecutor;
import org.apache.manifoldcf.core.interfaces.ICacheHandle;
import org.apache.manifoldcf.core.interfaces.ICacheManager;
import org.apache.manifoldcf.core.interfaces.IDBInterface;
import org.apache.manifoldcf.core.interfaces.IResultRow;
import org.apache.manifoldcf.core.interfaces.IResultSet;
import org.apache.manifoldcf.core.interfaces.IThreadContext;
import org.apache.manifoldcf.core.interfaces.ManifoldCFException;
import org.apache.manifoldcf.core.interfaces.MultiClause;
import org.apache.manifoldcf.core.interfaces.StringSet;
import org.apache.manifoldcf.core.interfaces.StringSetBuffer;
import org.apache.manifoldcf.core.interfaces.UnitaryClause;
import org.apache.manifoldcf.crawler.interfaces.IRepositoryConnectionManager;
import org.apache.manifoldcf.crawler.interfaces.RepositoryConnectionManagerFactory;

public class AuthorityGroupManager
extends BaseTable
implements IAuthorityGroupManager {
    public static final String _rcsid = "@(#)$Id$";
    protected static final String nameField = "groupname";
    protected static final String descriptionField = "description";
    ICacheManager cacheManager;
    IThreadContext threadContext;

    public AuthorityGroupManager(IThreadContext threadContext, IDBInterface database) throws ManifoldCFException {
        super(database, "authgroups");
        this.cacheManager = CacheManagerFactory.make((IThreadContext)threadContext);
        this.threadContext = threadContext;
    }

    @Override
    public void install() throws ManifoldCFException {
        block0: {
            Map existing = this.getTableSchema(null, null);
            if (existing != null) break block0;
            HashMap<String, ColumnDescription> map = new HashMap<String, ColumnDescription>();
            map.put(nameField, new ColumnDescription("VARCHAR(32)", true, false, null, null, false));
            map.put(descriptionField, new ColumnDescription("VARCHAR(255)", false, true, null, null, false));
            this.performCreate(map, null);
        }
    }

    @Override
    public void deinstall() throws ManifoldCFException {
        this.performDrop(null);
    }

    @Override
    public void exportConfiguration(OutputStream os) throws IOException, ManifoldCFException {
        ManifoldCF.writeDword((OutputStream)os, (int)1);
        IAuthorityGroup[] list = this.getAllGroups();
        ManifoldCF.writeDword((OutputStream)os, (int)list.length);
        int i = 0;
        while (i < list.length) {
            IAuthorityGroup conn = list[i++];
            ManifoldCF.writeString((OutputStream)os, (String)conn.getName());
            ManifoldCF.writeString((OutputStream)os, (String)conn.getDescription());
        }
    }

    @Override
    public void importConfiguration(InputStream is) throws IOException, ManifoldCFException {
        int version = ManifoldCF.readDword((InputStream)is);
        if (version < 1 || version > 1) {
            throw new IOException("Unknown authority group configuration version: " + Integer.toString(version));
        }
        int count = ManifoldCF.readDword((InputStream)is);
        for (int i = 0; i < count; ++i) {
            IAuthorityGroup conn = this.create();
            conn.setName(ManifoldCF.readString((InputStream)is));
            conn.setDescription(ManifoldCF.readString((InputStream)is));
            this.save(conn);
        }
    }

    @Override
    public IAuthorityGroup[] getAllGroups() throws ManifoldCFException {
        this.beginTransaction();
        try {
            StringSetBuffer ssb = new StringSetBuffer();
            ssb.add(AuthorityGroupManager.getAuthorityGroupsKey());
            StringSet localCacheKeys = new StringSet(ssb);
            IResultSet set = this.performQuery("SELECT groupname,lower(groupname) AS sortfield FROM " + this.getTableName() + " ORDER BY sortfield ASC", null, localCacheKeys, null);
            String[] names = new String[set.getRowCount()];
            for (int i = 0; i < names.length; ++i) {
                IResultRow row = set.getRow(i);
                names[i] = row.getValue(nameField).toString();
            }
            IAuthorityGroup[] iAuthorityGroupArray = this.loadMultiple(names);
            return iAuthorityGroupArray;
        }
        catch (ManifoldCFException e) {
            this.signalRollback();
            throw e;
        }
        catch (Error e) {
            this.signalRollback();
            throw e;
        }
        finally {
            this.endTransaction();
        }
    }

    @Override
    public IAuthorityGroup load(String name) throws ManifoldCFException {
        return this.loadMultiple(new String[]{name})[0];
    }

    @Override
    public IAuthorityGroup[] loadMultiple(String[] names) throws ManifoldCFException {
        AuthorityGroupDescription[] objectDescriptions = new AuthorityGroupDescription[names.length];
        StringSetBuffer ssb = new StringSetBuffer();
        for (int i = 0; i < names.length; ++i) {
            ssb.clear();
            ssb.add(AuthorityGroupManager.getAuthorityGroupKey(names[i]));
            objectDescriptions[i] = new AuthorityGroupDescription(names[i], new StringSet(ssb));
        }
        AuthorityGroupExecutor exec = new AuthorityGroupExecutor(this, objectDescriptions);
        this.cacheManager.findObjectsAndExecute((ICacheDescription[])objectDescriptions, null, (ICacheExecutor)exec, this.getTransactionID());
        return exec.getResults();
    }

    @Override
    public IAuthorityGroup create() throws ManifoldCFException {
        AuthorityGroup rval = new AuthorityGroup();
        return rval;
    }

    /*
     * Exception decompiling
     */
    @Override
    public boolean save(IAuthorityGroup object) throws ManifoldCFException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [7[CATCHBLOCK]], but top level block is 6[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void delete(String name) throws ManifoldCFException {
        IRepositoryConnectionManager repoManager = RepositoryConnectionManagerFactory.make(this.threadContext);
        IAuthorityConnectionManager authManager = AuthorityConnectionManagerFactory.make(this.threadContext);
        StringSetBuffer ssb = new StringSetBuffer();
        ssb.add(AuthorityGroupManager.getAuthorityGroupsKey());
        ssb.add(AuthorityGroupManager.getAuthorityGroupKey(name));
        StringSet cacheKeys = new StringSet(ssb);
        ICacheHandle ch = this.cacheManager.enterCache(null, cacheKeys, this.getTransactionID());
        try {
            this.beginTransaction();
            try {
                if (repoManager.isGroupReferenced(name)) {
                    throw new ManifoldCFException("Can't delete authority group '" + name + "': existing repository connections refer to it");
                }
                if (authManager.isGroupReferenced(name)) {
                    throw new ManifoldCFException("Can't delete authority group '" + name + "': existing authority connections refer to it");
                }
                ManifoldCF.noteConfigurationChange();
                ArrayList params = new ArrayList();
                String query = this.buildConjunctionClause(params, new ClauseDescription[]{new UnitaryClause(nameField, (Object)name)});
                this.performDelete("WHERE " + query, params, null);
                this.cacheManager.invalidateKeys(ch);
            }
            catch (ManifoldCFException e) {
                this.signalRollback();
                throw e;
            }
            catch (Error e) {
                this.signalRollback();
                throw e;
            }
            finally {
                this.endTransaction();
            }
        }
        finally {
            this.cacheManager.leaveCache(ch);
        }
    }

    @Override
    public String getGroupNameColumn() {
        return nameField;
    }

    @Override
    public String getGroupDescriptionColumn() {
        return descriptionField;
    }

    protected static String getAuthorityGroupsKey() {
        return CacheKeyFactory.makeAuthorityGroupsKey();
    }

    protected static String getAuthorityGroupKey(String groupName) {
        return CacheKeyFactory.makeAuthorityGroupKey(groupName);
    }

    protected AuthorityGroup[] getAuthorityGroupsMultiple(String[] groupNames) throws ManifoldCFException {
        int i;
        AuthorityGroup[] rval = new AuthorityGroup[groupNames.length];
        HashMap<String, Integer> returnIndex = new HashMap<String, Integer>();
        for (i = 0; i < groupNames.length; ++i) {
            rval[i] = null;
            returnIndex.put(groupNames[i], new Integer(i));
        }
        this.beginTransaction();
        try {
            i = 0;
            ArrayList<String> params = new ArrayList<String>();
            int j = 0;
            int maxIn = this.maxClauseGetAuthorityGroupsChunk();
            while (i < groupNames.length) {
                if (j == maxIn) {
                    this.getAuthorityGroupsChunk(rval, returnIndex, params);
                    params.clear();
                    j = 0;
                }
                params.add(groupNames[i]);
                ++i;
                ++j;
            }
            if (j > 0) {
                this.getAuthorityGroupsChunk(rval, returnIndex, params);
            }
            AuthorityGroup[] authorityGroupArray = rval;
            return authorityGroupArray;
        }
        catch (Error e) {
            this.signalRollback();
            throw e;
        }
        catch (ManifoldCFException e) {
            this.signalRollback();
            throw e;
        }
        finally {
            this.endTransaction();
        }
    }

    protected int maxClauseGetAuthorityGroupsChunk() {
        return this.findConjunctionClauseMax(new ClauseDescription[0]);
    }

    protected void getAuthorityGroupsChunk(AuthorityGroup[] rval, Map returnIndex, ArrayList params) throws ManifoldCFException {
        ArrayList list = new ArrayList();
        String query = this.buildConjunctionClause(list, new ClauseDescription[]{new MultiClause(nameField, (List)params)});
        IResultSet set = this.performQuery("SELECT * FROM " + this.getTableName() + " WHERE " + query, list, null, null);
        int i = 0;
        while (i < set.getRowCount()) {
            IResultRow row = set.getRow(i++);
            String name = row.getValue(nameField).toString();
            int index = (Integer)returnIndex.get(name);
            AuthorityGroup rc = new AuthorityGroup();
            rc.setIsNew(false);
            rc.setName(name);
            rc.setDescription((String)row.getValue(descriptionField));
            rval[index] = rc;
        }
    }

    protected static class AuthorityGroupExecutor
    extends ExecutorBase {
        protected AuthorityGroupManager thisManager;
        protected AuthorityGroup[] returnValues;
        protected HashMap returnMap = new HashMap();

        public AuthorityGroupExecutor(AuthorityGroupManager manager, AuthorityGroupDescription[] objectDescriptions) {
            this.thisManager = manager;
            this.returnValues = new AuthorityGroup[objectDescriptions.length];
            for (int i = 0; i < objectDescriptions.length; ++i) {
                this.returnMap.put(objectDescriptions[i].getGroupName(), new Integer(i));
            }
        }

        public AuthorityGroup[] getResults() {
            return this.returnValues;
        }

        public Object[] create(ICacheDescription[] objectDescriptions) throws ManifoldCFException {
            String[] groupNames = new String[objectDescriptions.length];
            for (int i = 0; i < groupNames.length; ++i) {
                AuthorityGroupDescription desc = (AuthorityGroupDescription)objectDescriptions[i];
                groupNames[i] = desc.getGroupName();
            }
            return this.thisManager.getAuthorityGroupsMultiple(groupNames);
        }

        public void exists(ICacheDescription objectDescription, Object cachedObject) throws ManifoldCFException {
            AuthorityGroupDescription objectDesc = (AuthorityGroupDescription)objectDescription;
            AuthorityGroup ci = (AuthorityGroup)cachedObject;
            if (ci != null) {
                ci = ci.duplicate();
            }
            this.returnValues[((Integer)this.returnMap.get((Object)objectDesc.getGroupName())).intValue()] = ci;
        }

        public void execute() throws ManifoldCFException {
        }
    }

    protected static class AuthorityGroupDescription
    extends BaseDescription {
        protected String groupName;
        protected String criticalSectionName;
        protected StringSet cacheKeys;

        public AuthorityGroupDescription(String groupName, StringSet invKeys) {
            super("authoritygroupcache");
            this.groupName = groupName;
            this.criticalSectionName = ((Object)((Object)this)).getClass().getName() + "-" + groupName;
            this.cacheKeys = invKeys;
        }

        public String getGroupName() {
            return this.groupName;
        }

        public int hashCode() {
            return this.groupName.hashCode();
        }

        public boolean equals(Object o) {
            if (!(o instanceof AuthorityGroupDescription)) {
                return false;
            }
            AuthorityGroupDescription d = (AuthorityGroupDescription)((Object)o);
            return d.groupName.equals(this.groupName);
        }

        public String getCriticalSectionName() {
            return this.criticalSectionName;
        }

        public StringSet getObjectKeys() {
            return this.cacheKeys;
        }
    }
}

