/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.util;

import org.apache.jena.graph.Node;
import org.apache.jena.query.QueryException;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.impl.LiteralImpl;
import org.apache.jena.rdf.model.impl.ResourceImpl;
import org.apache.jena.sparql.ARQInternalErrorException;

public class ModelUtils {
    public static RDFNode convertGraphNodeToRDFNode(Node node, Model model) {
        if (node.isVariable()) {
            throw new QueryException("Variable: " + String.valueOf(node));
        }
        if (model != null) {
            return model.asRDFNode(node);
        }
        if (node.isLiteral()) {
            return new LiteralImpl(node, null);
        }
        if (node.isURI() || node.isBlank()) {
            return new ResourceImpl(node, null);
        }
        if (node.isTripleTerm()) {
            return new ResourceImpl(node, null);
        }
        throw new ARQInternalErrorException("Unknown node type for node: " + String.valueOf(node));
    }

    public static RDFNode convertGraphNodeToRDFNode(Node node) {
        return ModelUtils.convertGraphNodeToRDFNode(node, null);
    }
}

