/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.container.spring.bean.factorypostprocessor;

import java.io.FileNotFoundException;
import org.apache.james.filesystem.api.FileSystem;
import org.springframework.beans.BeansException;
import org.springframework.beans.FatalBeanException;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.BeanDefinitionVisitor;
import org.springframework.beans.factory.config.BeanFactoryPostProcessor;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;

public class FileSystemBeanFactoryPostProcessor
implements BeanFactoryPostProcessor {
    private static final String FS_PREFIX = "filesystem=";
    private final FileSystemVisitor visitor = new FileSystemVisitor();
    private FileSystem fileSystem;

    public void setFileSystem(FileSystem fileSystem) {
        this.fileSystem = fileSystem;
    }

    public void postProcessBeanFactory(ConfigurableListableBeanFactory factory) throws BeansException {
        String[] names;
        for (String name : names = factory.getBeanDefinitionNames()) {
            BeanDefinition def = factory.getBeanDefinition(name);
            this.visitor.visitBeanDefinition(def);
        }
    }

    private final class FileSystemVisitor
    extends BeanDefinitionVisitor {
        private FileSystemVisitor() {
        }

        protected String resolveStringValue(String strVal) throws BeansException {
            if (strVal.startsWith(FileSystemBeanFactoryPostProcessor.FS_PREFIX)) {
                try {
                    return FileSystemBeanFactoryPostProcessor.this.fileSystem.getFile(strVal.substring(FileSystemBeanFactoryPostProcessor.FS_PREFIX.length())).toString();
                }
                catch (FileNotFoundException e) {
                    throw new FatalBeanException("Unable to convert value with filesystem service", (Throwable)e);
                }
            }
            return strVal;
        }
    }
}

