/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.events;

import jakarta.inject.Inject;
import org.apache.james.core.healthcheck.ComponentName;
import org.apache.james.core.healthcheck.HealthCheck;
import org.apache.james.core.healthcheck.Result;
import org.apache.james.events.EventDeadLetters;
import reactor.core.publisher.Mono;

public class EventDeadLettersHealthCheck
implements HealthCheck {
    private static final ComponentName COMPONENT_NAME = new ComponentName("EventDeadLettersHealthCheck");
    private final EventDeadLetters eventDeadLetters;

    @Inject
    public EventDeadLettersHealthCheck(EventDeadLetters eventDeadLetters) {
        this.eventDeadLetters = eventDeadLetters;
    }

    @Override
    public ComponentName componentName() {
        return COMPONENT_NAME;
    }

    public Mono<Result> check() {
        return this.eventDeadLetters.containEvents().map(containEvents -> {
            if (containEvents.booleanValue()) {
                return Result.degraded(COMPONENT_NAME, "EventDeadLetters contain events. This might indicate transient failure on event processing.");
            }
            return Result.healthy(COMPONENT_NAME);
        }).onErrorResume(e -> Mono.just(Result.unhealthy(COMPONENT_NAME, "Error checking EventDeadLettersHealthCheck", e)));
    }
}

