/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.persistence.criteria;

public interface ComparisonStyle {
    public boolean isDisjunction();

    public ComparisonStyle setDisjunction(boolean var1);

    public boolean excludeNull();

    public ComparisonStyle setExcludeNull(boolean var1);

    public boolean excludeIdentity();

    public ComparisonStyle setExcludeIdentity(boolean var1);

    public boolean excludeVersion();

    public ComparisonStyle setExcludeVersion(boolean var1);

    public boolean excludeDefault();

    public ComparisonStyle setExcludeDefault(boolean var1);

    public StringComparisonMode getStringComparsionMode();

    public ComparisonStyle setStringComparisonMode(StringComparisonMode var1);

    public static class Default
    implements ComparisonStyle {
        private boolean excludeDefault = true;
        private boolean excludeNull = true;
        private boolean excludeIdentity = true;
        private boolean excludeVersion = true;
        private boolean disjunction = false;
        private StringComparisonMode stringMode = StringComparisonMode.EXACT;

        @Override
        public boolean excludeDefault() {
            return this.excludeDefault;
        }

        @Override
        public boolean excludeNull() {
            return this.excludeNull;
        }

        @Override
        public StringComparisonMode getStringComparsionMode() {
            return this.stringMode;
        }

        @Override
        public boolean isDisjunction() {
            return this.disjunction;
        }

        @Override
        public ComparisonStyle setExcludeDefault(boolean flag) {
            this.excludeDefault = flag;
            return this;
        }

        @Override
        public ComparisonStyle setExcludeNull(boolean flag) {
            this.excludeNull = flag;
            return this;
        }

        @Override
        public ComparisonStyle setStringComparisonMode(StringComparisonMode mode) {
            this.stringMode = mode;
            return this;
        }

        @Override
        public ComparisonStyle setDisjunction(boolean flag) {
            this.disjunction = flag;
            return this;
        }

        @Override
        public boolean excludeIdentity() {
            return this.excludeIdentity;
        }

        @Override
        public ComparisonStyle setExcludeIdentity(boolean flag) {
            this.excludeIdentity = flag;
            return this;
        }

        @Override
        public boolean excludeVersion() {
            return this.excludeVersion;
        }

        @Override
        public ComparisonStyle setExcludeVersion(boolean flag) {
            this.excludeVersion = flag;
            return this;
        }
    }

    public static enum StringComparisonMode {
        EXACT,
        CASE_INSENSITIVE,
        LIKE;

    }
}

