/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.internal.core.type.codec;

import com.datastax.oss.driver.api.core.ProtocolVersion;
import com.datastax.oss.driver.api.core.type.DataType;
import com.datastax.oss.driver.api.core.type.DataTypes;
import com.datastax.oss.driver.api.core.type.codec.PrimitiveIntCodec;
import com.datastax.oss.driver.api.core.type.reflect.GenericType;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.nio.ByteBuffer;
import net.jcip.annotations.ThreadSafe;

@ThreadSafe
public class IntCodec
implements PrimitiveIntCodec {
    @Override
    @NonNull
    public GenericType<Integer> getJavaType() {
        return GenericType.INTEGER;
    }

    @Override
    @NonNull
    public DataType getCqlType() {
        return DataTypes.INT;
    }

    @Override
    public boolean accepts(@NonNull Object value) {
        return value instanceof Integer;
    }

    @Override
    public boolean accepts(@NonNull Class<?> javaClass) {
        return javaClass == Integer.class || javaClass == Integer.TYPE;
    }

    @Override
    @Nullable
    public ByteBuffer encodePrimitive(int value, @NonNull ProtocolVersion protocolVersion) {
        ByteBuffer bytes = ByteBuffer.allocate(4);
        bytes.putInt(0, value);
        return bytes;
    }

    @Override
    public int decodePrimitive(@Nullable ByteBuffer bytes, @NonNull ProtocolVersion protocolVersion) {
        if (bytes == null || bytes.remaining() == 0) {
            return 0;
        }
        if (bytes.remaining() != 4) {
            throw new IllegalArgumentException("Invalid 32-bits integer value, expecting 4 bytes but got " + bytes.remaining());
        }
        return bytes.getInt(bytes.position());
    }

    @Override
    @NonNull
    public String format(@Nullable Integer value) {
        return value == null ? "NULL" : Integer.toString(value);
    }

    @Override
    @Nullable
    public Integer parse(@Nullable String value) {
        try {
            return value == null || value.isEmpty() || value.equalsIgnoreCase("NULL") ? null : Integer.valueOf(Integer.parseInt(value));
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException(String.format("Cannot parse 32-bits int value from \"%s\"", value));
        }
    }
}

