/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.imap.decode.main;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.james.imap.api.ImapSessionState;
import org.apache.james.imap.api.process.ImapProcessor;
import org.apache.james.imap.api.process.ImapSession;
import org.apache.james.imap.decode.DecodingException;
import org.apache.james.imap.decode.ImapDecoder;
import org.apache.james.imap.decode.ImapRequestLineReader;
import org.apache.james.imap.decode.ImapRequestStreamLineReader;
import org.apache.james.imap.decode.main.OutputStreamImapResponseWriter;
import org.apache.james.imap.encode.ImapEncoder;
import org.apache.james.imap.encode.base.ImapResponseComposerImpl;
import org.apache.james.imap.main.AbstractImapRequestHandler;
import org.apache.james.imap.message.request.SystemMessage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ImapRequestStreamHandler
extends AbstractImapRequestHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(ImapRequestStreamHandler.class);

    public ImapRequestStreamHandler(ImapDecoder decoder, ImapProcessor processor, ImapEncoder encoder) {
        super(decoder, processor, encoder);
    }

    public boolean handleRequest(InputStream input, OutputStream output, ImapSession session) {
        boolean result;
        if (this.isSelectedMailboxDeleted(session)) {
            this.writeSignoff(output, session);
            result = false;
        } else {
            ImapRequestStreamLineReader request = new ImapRequestStreamLineReader(input, output);
            try {
                ((ImapRequestLineReader)request).nextChar();
            }
            catch (DecodingException e) {
                LOGGER.debug("Unexpected end of line. Cannot handle request: ", (Throwable)e);
                this.abandon(output, session);
                return false;
            }
            OutputStreamImapResponseWriter writer = new OutputStreamImapResponseWriter(output);
            ImapResponseComposerImpl response = new ImapResponseComposerImpl(writer);
            writer.setFlushCallback(response::flush);
            if (this.doProcessRequest(request, response, session)) {
                try {
                    request.consumeLine();
                }
                catch (DecodingException e) {
                    LOGGER.info("Fault during clean up: {}", (Object)e.getMessage());
                    LOGGER.debug("Abandoning after fault in clean up", (Throwable)e);
                    this.abandon(output, session);
                    return false;
                }
                result = ImapSessionState.LOGOUT != session.getState();
            } else {
                LOGGER.debug("Connection was abandoned after request processing failed.");
                result = false;
                this.abandon(output, session);
            }
            try {
                response.flush();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        return result;
    }

    private void writeSignoff(OutputStream output, ImapSession session) {
        try {
            output.write(MAILBOX_DELETED_SIGNOFF);
        }
        catch (IOException e) {
            LOGGER.warn("Failed to write signoff");
            LOGGER.debug("Failed to write signoff:", (Throwable)e);
        }
    }

    private void abandon(OutputStream out, ImapSession session) {
        if (session != null) {
            try {
                session.logout().block();
            }
            catch (Throwable t) {
                LOGGER.warn("Session logout failed. Resources may not be correctly recycled.");
            }
        }
        try {
            out.write(ABANDON_SIGNOFF);
        }
        catch (Throwable t) {
            LOGGER.debug("Failed to write ABANDON_SIGNOFF", t);
        }
        this.processor.process(SystemMessage.FORCE_LOGOUT, new AbstractImapRequestHandler.SilentResponder(), session);
    }
}

