/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.jspf.impl;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.List;
import org.apache.james.jspf.core.DNSRequest;
import org.apache.james.jspf.core.DNSService;
import org.apache.james.jspf.core.IPAddr;
import org.apache.james.jspf.core.Logger;
import org.apache.james.jspf.core.exceptions.TimeoutException;
import org.xbill.DNS.AAAARecord;
import org.xbill.DNS.ARecord;
import org.xbill.DNS.Lookup;
import org.xbill.DNS.MXRecord;
import org.xbill.DNS.PTRRecord;
import org.xbill.DNS.Record;
import org.xbill.DNS.Resolver;
import org.xbill.DNS.SPFRecord;
import org.xbill.DNS.TXTRecord;
import org.xbill.DNS.TextParseException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DNSServiceXBillImpl
implements DNSService {
    protected Logger log;
    protected int recordLimit;
    protected Resolver resolver;

    public DNSServiceXBillImpl(Logger logger) {
        this(logger, Lookup.getDefaultResolver());
    }

    public DNSServiceXBillImpl(Logger logger, Resolver resolver) {
        this.log = logger;
        this.resolver = resolver;
        this.recordLimit = 10;
    }

    @Override
    public synchronized void setTimeOut(int timeOut) {
        this.resolver.setTimeout(timeOut);
    }

    @Override
    public List<String> getLocalDomainNames() {
        ArrayList<String> names = new ArrayList<String>();
        this.log.debug("Start Local ipaddress lookup");
        try {
            InetAddress[] ia = InetAddress.getAllByName(InetAddress.getLocalHost().getHostName());
            for (int i = 0; i < ia.length; ++i) {
                String host = ia[i].getHostName();
                names.add(host);
                this.log.debug("Add hostname " + host + " to list");
            }
        }
        catch (UnknownHostException unknownHostException) {
            // empty catch block
        }
        return names;
    }

    @Override
    public int getRecordLimit() {
        return this.recordLimit;
    }

    @Override
    public void setRecordLimit(int recordLimit) {
        this.recordLimit = recordLimit;
    }

    @Override
    public List<String> getRecords(DNSRequest request) throws TimeoutException {
        int dnsJavaType;
        String recordTypeDescription;
        switch (request.getRecordType()) {
            case 1: {
                recordTypeDescription = "A";
                dnsJavaType = 1;
                break;
            }
            case 2: {
                recordTypeDescription = "AAAA";
                dnsJavaType = 28;
                break;
            }
            case 3: {
                recordTypeDescription = "MX";
                dnsJavaType = 15;
                break;
            }
            case 4: {
                recordTypeDescription = "PTR";
                dnsJavaType = 12;
                break;
            }
            case 5: {
                recordTypeDescription = "TXT";
                dnsJavaType = 16;
                break;
            }
            case 6: {
                recordTypeDescription = "SPF";
                dnsJavaType = 99;
                break;
            }
            default: {
                return null;
            }
        }
        try {
            this.log.debug("Start " + recordTypeDescription + "-Record lookup for : " + request.getHostname());
            Lookup query = new Lookup(request.getHostname(), dnsJavaType);
            query.setResolver(this.resolver);
            Record[] rr = query.run();
            int queryResult = query.getResult();
            if (queryResult == 2) {
                throw new TimeoutException(query.getErrorString());
            }
            List<String> records = DNSServiceXBillImpl.convertRecordsToList(rr);
            this.log.debug("Found " + (rr != null ? rr.length : 0) + " " + recordTypeDescription + "-Records");
            return records;
        }
        catch (TextParseException e) {
            this.log.debug("No " + recordTypeDescription + " Record found for host: " + request.getHostname());
            return null;
        }
    }

    public static List<String> convertRecordsToList(Record[] rr) {
        ArrayList<String> records;
        if (rr != null && rr.length > 0) {
            records = new ArrayList<String>();
            block8: for (int i = 0; i < rr.length; ++i) {
                switch (rr[i].getType()) {
                    case 1: {
                        ARecord a = (ARecord)rr[i];
                        records.add(a.getAddress().getHostAddress());
                        continue block8;
                    }
                    case 28: {
                        AAAARecord aaaa = (AAAARecord)rr[i];
                        records.add(aaaa.getAddress().getHostAddress());
                        continue block8;
                    }
                    case 15: {
                        MXRecord mx = (MXRecord)rr[i];
                        records.add(mx.getTarget().toString());
                        continue block8;
                    }
                    case 12: {
                        PTRRecord ptr = (PTRRecord)rr[i];
                        records.add(IPAddr.stripDot(ptr.getTarget().toString()));
                        continue block8;
                    }
                    case 16: {
                        TXTRecord txt = (TXTRecord)rr[i];
                        if (txt.getStrings().size() == 1) {
                            records.add((String)txt.getStrings().get(0));
                            continue block8;
                        }
                        StringBuffer sb = new StringBuffer();
                        for (String k : txt.getStrings()) {
                            sb.append(k);
                        }
                        records.add(sb.toString());
                        continue block8;
                    }
                    case 99: {
                        SPFRecord spf = (SPFRecord)rr[i];
                        if (spf.getStrings().size() == 1) {
                            records.add((String)spf.getStrings().get(0));
                            continue block8;
                        }
                        StringBuffer sb = new StringBuffer();
                        for (String k : spf.getStrings()) {
                            sb.append(k);
                        }
                        records.add(sb.toString());
                        continue block8;
                    }
                    default: {
                        return null;
                    }
                }
            }
        } else {
            records = null;
        }
        return records;
    }
}

