/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.http.nio.netty.internal;

import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import java.io.IOException;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.http.nio.netty.internal.ChannelAttributeKey;
import software.amazon.awssdk.http.nio.netty.internal.FutureCancelledException;
import software.amazon.awssdk.http.nio.netty.internal.RequestContext;
import software.amazon.awssdk.http.nio.netty.internal.utils.NettyClientLogger;

@ChannelHandler.Sharable
@SdkInternalApi
public final class FutureCancelHandler
extends ChannelInboundHandlerAdapter {
    private static final NettyClientLogger LOG = NettyClientLogger.getLogger(FutureCancelHandler.class);
    private static final FutureCancelHandler INSTANCE = new FutureCancelHandler();

    private FutureCancelHandler() {
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable e) {
        if (!(e instanceof FutureCancelledException)) {
            ctx.fireExceptionCaught(e);
            return;
        }
        FutureCancelledException cancelledException = (FutureCancelledException)e;
        if (this.currentRequestCancelled(ctx, cancelledException)) {
            RequestContext requestContext = (RequestContext)ctx.channel().attr(ChannelAttributeKey.REQUEST_CONTEXT_KEY).get();
            requestContext.handler().onError(e);
            ctx.fireExceptionCaught((Throwable)new IOException("Request cancelled"));
            ctx.close();
            requestContext.channelPool().release(ctx.channel());
        } else {
            LOG.debug(ctx.channel(), () -> String.format("Received a cancellation exception but it did not match the current execution ID. Exception's execution ID is %d, but the current ID on the channel is %d. Exception is being ignored.", cancelledException.getExecutionId(), this.executionId(ctx)));
        }
    }

    public static FutureCancelHandler getInstance() {
        return INSTANCE;
    }

    private boolean currentRequestCancelled(ChannelHandlerContext ctx, FutureCancelledException e) {
        return e.getExecutionId() == this.executionId(ctx).longValue();
    }

    private Long executionId(ChannelHandlerContext ctx) {
        return (Long)ctx.channel().attr(ChannelAttributeKey.EXECUTION_ID_KEY).get();
    }
}

