/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.backends.cassandra.components;

import com.datastax.driver.core.KeyspaceMetadata;
import com.datastax.driver.core.Session;
import com.datastax.driver.core.Statement;
import com.google.common.base.MoreObjects;
import java.util.Objects;

public class CassandraTable {
    private final Statement createStatement;
    private final String name;

    public CassandraTable(String name, Statement createStatement) {
        this.createStatement = createStatement;
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public InitializationStatus initialize(KeyspaceMetadata keyspaceMetadata, Session session) {
        if (keyspaceMetadata.getTable(this.name) != null) {
            return InitializationStatus.ALREADY_DONE;
        }
        session.execute(this.createStatement);
        return InitializationStatus.FULL;
    }

    public final boolean equals(Object o) {
        if (o instanceof CassandraTable) {
            CassandraTable that = (CassandraTable)o;
            return Objects.equals(this.name, that.name) && Objects.equals(this.createStatement, that.createStatement);
        }
        return false;
    }

    public final int hashCode() {
        return Objects.hash(this.name, this.createStatement);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("name", (Object)this.name).add("createStatement", (Object)this.createStatement).toString();
    }

    public static enum InitializationStatus {
        ALREADY_DONE,
        PARTIAL,
        FULL;


        public InitializationStatus reduce(InitializationStatus other) {
            if (this == other) {
                return this;
            }
            return PARTIAL;
        }
    }
}

