/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk.unboundidds.tools;

import com.unboundid.ldap.sdk.DN;
import com.unboundid.ldap.sdk.Entry;
import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.unboundidds.tools.SplitLDIFEntry;
import com.unboundid.ldap.sdk.unboundidds.tools.SplitLDIFTranslator;
import com.unboundid.ldap.sdk.unboundidds.tools.ToolMessages;
import com.unboundid.ldif.LDIFException;
import com.unboundid.util.Debug;
import com.unboundid.util.NotNull;
import com.unboundid.util.StaticUtils;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;

@ThreadSafety(level=ThreadSafetyLevel.NOT_THREADSAFE)
final class SplitLDIFRDNHashTranslator
extends SplitLDIFTranslator {
    @NotNull
    private final Map<Integer, Set<String>> setNames;
    @NotNull
    private final Set<String> outsideSplitBaseSetNames;
    @NotNull
    private final Set<String> splitBaseEntrySetNames;

    SplitLDIFRDNHashTranslator(@NotNull DN splitBaseDN, int numSets, boolean addEntriesOutsideSplitToAllSets, boolean addEntriesOutsideSplitToDedicatedSet) {
        super(splitBaseDN);
        this.outsideSplitBaseSetNames = new LinkedHashSet<String>(StaticUtils.computeMapCapacity(numSets + 1));
        this.splitBaseEntrySetNames = new LinkedHashSet<String>(StaticUtils.computeMapCapacity(numSets));
        if (addEntriesOutsideSplitToDedicatedSet) {
            this.outsideSplitBaseSetNames.add(".outside-split");
        }
        this.setNames = new LinkedHashMap<Integer, Set<String>>(StaticUtils.computeMapCapacity(numSets));
        for (int i = 0; i < numSets; ++i) {
            String setName = ".set" + (i + 1);
            this.setNames.put(i, Collections.singleton(setName));
            this.splitBaseEntrySetNames.add(setName);
            if (!addEntriesOutsideSplitToAllSets) continue;
            this.outsideSplitBaseSetNames.add(setName);
        }
    }

    @Override
    @NotNull
    public SplitLDIFEntry translate(@NotNull Entry original, long firstLineNumber) throws LDIFException {
        DN dn;
        try {
            dn = original.getParsedDN();
        }
        catch (LDAPException le) {
            Debug.debugException(le);
            return this.createEntry(original, ToolMessages.ERR_SPLIT_LDIF_RDN_HASH_TRANSLATOR_CANNOT_PARSE_DN.get(le.getMessage()), this.getErrorSetNames());
        }
        if (!dn.isDescendantOf(this.getSplitBaseDN(), true)) {
            return this.createEntry(original, this.outsideSplitBaseSetNames);
        }
        if (dn.equals(this.getSplitBaseDN())) {
            return this.createEntry(original, this.splitBaseEntrySetNames);
        }
        return this.createFromRDNHash(original, dn, this.setNames);
    }
}

