/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.query.lucene;

import java.io.IOException;
import org.apache.jackrabbit.core.query.lucene.FieldNames;
import org.apache.jackrabbit.core.query.lucene.NamespaceMappings;
import org.apache.jackrabbit.core.query.lucene.SharedFieldComparatorSource;
import org.apache.jackrabbit.core.query.lucene.Util;
import org.apache.jackrabbit.spi.NameFactory;
import org.apache.jackrabbit.spi.commons.conversion.IllegalNameException;
import org.apache.jackrabbit.spi.commons.name.NameFactoryImpl;
import org.apache.lucene.search.FieldComparator;
import org.apache.lucene.search.FieldComparatorSource;

public class LengthSortComparator
extends FieldComparatorSource {
    private final NamespaceMappings nsMappings;

    public LengthSortComparator(NamespaceMappings nsMappings) {
        this.nsMappings = nsMappings;
    }

    public FieldComparator newComparator(String fieldname, int numHits, int sortPos, boolean reversed) throws IOException {
        NameFactory factory = NameFactoryImpl.getInstance();
        try {
            return new SharedFieldComparatorSource.SimpleFieldComparator(this.nsMappings.translateName(factory.create(fieldname)), FieldNames.PROPERTY_LENGTHS, numHits);
        }
        catch (IllegalNameException e) {
            throw Util.createIOException(e);
        }
    }
}

