/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core;

import javax.jcr.NoSuchWorkspaceException;
import javax.jcr.RepositoryException;
import javax.security.auth.Subject;
import org.apache.jackrabbit.core.RepositoryImpl;
import org.apache.jackrabbit.core.SessionImpl;
import org.apache.jackrabbit.core.observation.ObservationDispatcher;
import org.apache.jackrabbit.core.state.SharedItemStateManager;
import org.xml.sax.InputSource;

public class WorkspaceManager {
    private final RepositoryImpl repository;

    WorkspaceManager(RepositoryImpl repository) {
        this.repository = repository;
    }

    public String getDefaultWorkspaceName() {
        return this.repository.getConfig().getDefaultWorkspaceName();
    }

    public String[] getWorkspaceNames() {
        return this.repository.getWorkspaceNames();
    }

    public void createWorkspace(String workspaceName) throws RepositoryException {
        this.repository.createWorkspace(workspaceName);
    }

    public void createWorkspace(String workspaceName, InputSource configTemplate) throws RepositoryException {
        this.repository.createWorkspace(workspaceName, configTemplate);
    }

    public SharedItemStateManager getWorkspaceStateManager(String workspaceName) throws NoSuchWorkspaceException, RepositoryException {
        return this.repository.getWorkspaceStateManager(workspaceName);
    }

    public ObservationDispatcher getObservationDispatcher(String workspaceName) throws NoSuchWorkspaceException, RepositoryException {
        return this.repository.getObservationDispatcher(workspaceName);
    }

    public SessionImpl createSession(Subject subject, String workspaceName) throws RepositoryException {
        return this.repository.createSession(subject, workspaceName);
    }
}

