/*
 * Decompiled with CFR 0.152.
 */
package com.healthmarketscience.jackcess.crypt.impl.office;

import com.healthmarketscience.jackcess.crypt.impl.OfficeCryptCodecHandler;
import com.healthmarketscience.jackcess.impl.PageChannel;
import java.io.IOException;
import java.nio.ByteBuffer;
import org.bouncycastle.crypto.BlockCipher;
import org.bouncycastle.crypto.BufferedBlockCipher;

public abstract class BlockCipherProvider
extends OfficeCryptCodecHandler {
    private BufferedBlockCipher _cipher;

    public BlockCipherProvider(PageChannel channel, byte[] encodingKey) {
        super(channel, encodingKey);
    }

    @Override
    protected BufferedBlockCipher getBlockCipher() {
        if (this._cipher == null) {
            this._cipher = new BufferedBlockCipher(this.initCipher());
        }
        return this._cipher;
    }

    @Override
    public final boolean canEncodePartialPage() {
        return false;
    }

    @Override
    public final boolean canDecodeInline() {
        return false;
    }

    protected BlockCipher initCipher() {
        switch (this.getPhase()) {
            case PWD_VERIFY: {
                return this.initPwdCipher();
            }
            case CRYPT: {
                return this.initCryptCipher();
            }
        }
        throw new RuntimeException("unknown phase " + (Object)((Object)this.getPhase()));
    }

    protected BlockCipher initPwdCipher() {
        throw new UnsupportedOperationException();
    }

    protected BlockCipher initCryptCipher() {
        throw new UnsupportedOperationException();
    }

    @Override
    protected void decodePageImpl(ByteBuffer inPage, ByteBuffer outPage, int pageNumber) {
        this.blockDecrypt(inPage, outPage, pageNumber);
    }

    @Override
    public ByteBuffer encodePageImpl(ByteBuffer buffer, int pageNumber, int pageOffset) throws IOException {
        return this.blockEncrypt(buffer, pageNumber);
    }

    @Override
    protected void reset() {
        super.reset();
        this._cipher = null;
    }
}

