/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.value;

import java.io.InputStream;
import javax.jcr.RepositoryException;
import org.apache.jackrabbit.core.value.BLOBFileValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RefCountingBLOBFileValue
extends BLOBFileValue {
    private static final Logger log = LoggerFactory.getLogger(RefCountingBLOBFileValue.class);
    private final BLOBFileValue value;
    private int refCount = 1;
    private boolean disposed = false;

    public RefCountingBLOBFileValue(BLOBFileValue value) {
        this.value = value;
    }

    @Override
    public synchronized void dispose() {
        if (this.refCount > 0) {
            if (--this.refCount == 0) {
                log.debug("{}@refCount={}, discarding value...", (Object)System.identityHashCode(this), (Object)this.refCount);
                this.value.dispose();
                this.disposed = true;
            } else {
                log.debug("{}@refCount={}", (Object)System.identityHashCode(this), (Object)this.refCount);
            }
        }
    }

    @Override
    void delete(boolean pruneEmptyParentDirs) {
        this.value.delete(pruneEmptyParentDirs);
    }

    @Override
    synchronized BLOBFileValue copy() throws RepositoryException {
        if (this.refCount <= 0) {
            throw new RepositoryException("this BLOBFileValue has been disposed");
        }
        RefCountBinary bin = new RefCountBinary();
        ++this.refCount;
        log.debug("{}@refCount={}", (Object)System.identityHashCode(this), (Object)this.refCount);
        return bin;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof RefCountingBLOBFileValue) {
            RefCountingBLOBFileValue val = (RefCountingBLOBFileValue)obj;
            return this.value.equals(val.value);
        }
        return false;
    }

    @Override
    public String toString() {
        return this.value.toString();
    }

    @Override
    public int hashCode() {
        return 0;
    }

    @Override
    public long getSize() throws RepositoryException {
        return this.value.getSize();
    }

    @Override
    public InputStream getStream() throws RepositoryException {
        return this.value.getStream();
    }

    protected void finalize() throws Throwable {
        if (!this.disposed) {
            this.dispose();
        }
        super.finalize();
    }

    private final class RefCountBinary
    extends BLOBFileValue {
        private boolean disposed;

        private RefCountBinary() {
        }

        @Override
        public InputStream getStream() throws RepositoryException {
            this.checkDisposed();
            return this.getInternalValue().getStream();
        }

        @Override
        public long getSize() throws RepositoryException {
            this.checkDisposed();
            return this.getInternalValue().getSize();
        }

        @Override
        public void dispose() {
            if (!this.disposed) {
                this.disposed = true;
                this.getInternalValue().dispose();
            }
        }

        @Override
        void delete(boolean pruneEmptyParentDirs) {
            this.getInternalValue().delete(pruneEmptyParentDirs);
        }

        @Override
        BLOBFileValue copy() throws RepositoryException {
            this.checkDisposed();
            return this.getInternalValue().copy();
        }

        @Override
        public boolean equals(Object obj) {
            if (obj instanceof RefCountBinary) {
                RefCountBinary other = (RefCountBinary)obj;
                return this.getInternalValue().equals(other.getInternalValue());
            }
            return false;
        }

        @Override
        public String toString() {
            return this.getInternalValue().toString();
        }

        @Override
        public int hashCode() {
            return 0;
        }

        protected void finalize() throws Throwable {
            this.dispose();
            super.finalize();
        }

        private BLOBFileValue getInternalValue() {
            return RefCountingBLOBFileValue.this;
        }

        private void checkDisposed() throws RepositoryException {
            if (this.disposed) {
                throw new RepositoryException("this BLOBFileValue is disposed");
            }
        }
    }
}

