/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.rmi.server.jmx;

import java.io.ByteArrayInputStream;
import java.util.Properties;
import javax.jcr.Repository;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.SimpleCredentials;
import javax.naming.InitialContext;
import org.apache.jackrabbit.rmi.remote.RemoteRepository;
import org.apache.jackrabbit.rmi.server.ServerAdapterFactory;
import org.apache.jackrabbit.rmi.server.jmx.JCRServerMBean;

@Deprecated
public class JCRServer
implements JCRServerMBean {
    private String localAddress;
    private String remoteAddress;
    private String localEnvironment;
    private String remoteEnvironment;
    RemoteRepository remote;
    private Repository localRepository;

    @Override
    public void start() throws Exception {
        if (this.localAddress == null) {
            throw new IllegalStateException("local repository address is null");
        }
        if (this.remoteAddress == null) {
            throw new IllegalStateException("remote repository address is null");
        }
        InitialContext localContext = this.createInitialContext(this.localEnvironment);
        this.localRepository = (Repository)localContext.lookup(this.localAddress);
        if (this.localRepository == null) {
            throw new IllegalArgumentException("local repository not found at " + this.localAddress);
        }
        InitialContext remoteContext = this.createInitialContext(this.remoteEnvironment);
        ServerAdapterFactory factory = new ServerAdapterFactory();
        this.remote = factory.getRemoteRepository(this.localRepository);
        remoteContext.bind(this.remoteAddress, (Object)this.remote);
    }

    private InitialContext createInitialContext(String jndiProps) throws Exception {
        InitialContext initialContext = null;
        if (jndiProps != null) {
            ByteArrayInputStream is = new ByteArrayInputStream(jndiProps.getBytes());
            Properties props = new Properties();
            props.load(is);
            initialContext = new InitialContext(props);
        } else {
            initialContext = new InitialContext();
        }
        return initialContext;
    }

    @Override
    public void stop() throws Exception {
        InitialContext ctx = new InitialContext();
        ctx.unbind(this.remoteAddress);
        this.remote = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void createWorkspace(String username, String password, String name) throws RepositoryException {
        Session session = this.localRepository.login(new SimpleCredentials(username, password.toCharArray()));
        try {
            session.getWorkspace().createWorkspace(name);
        }
        finally {
            session.logout();
        }
    }

    @Override
    public String getLocalAddress() {
        return this.localAddress;
    }

    @Override
    public void setLocalAddress(String localAddress) {
        this.localAddress = localAddress;
    }

    @Override
    public String getRemoteAddress() {
        return this.remoteAddress;
    }

    @Override
    public void setRemoteAddress(String remoteAddress) {
        this.remoteAddress = remoteAddress;
    }

    @Override
    public String getLocalEnvironment() {
        return this.localEnvironment;
    }

    @Override
    public void setLocalEnvironment(String localEnvironment) {
        this.localEnvironment = localEnvironment;
    }

    @Override
    public String getRemoteEnvironment() {
        return this.remoteEnvironment;
    }

    @Override
    public void setRemoteEnvironment(String remoteEnvironment) {
        this.remoteEnvironment = remoteEnvironment;
    }
}

