/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.jcr2spi.xml;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Stack;
import java.util.UUID;
import javax.jcr.ItemExistsException;
import javax.jcr.ItemNotFoundException;
import javax.jcr.PathNotFoundException;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.Value;
import javax.jcr.lock.LockException;
import javax.jcr.nodetype.ConstraintViolationException;
import javax.jcr.version.VersionException;
import org.apache.jackrabbit.jcr2spi.SessionImpl;
import org.apache.jackrabbit.jcr2spi.SessionListener;
import org.apache.jackrabbit.jcr2spi.hierarchy.NodeEntry;
import org.apache.jackrabbit.jcr2spi.hierarchy.PropertyEntry;
import org.apache.jackrabbit.jcr2spi.nodetype.EffectiveNodeType;
import org.apache.jackrabbit.jcr2spi.nodetype.EffectiveNodeTypeProvider;
import org.apache.jackrabbit.jcr2spi.operation.AddNode;
import org.apache.jackrabbit.jcr2spi.operation.AddProperty;
import org.apache.jackrabbit.jcr2spi.operation.Operation;
import org.apache.jackrabbit.jcr2spi.operation.Remove;
import org.apache.jackrabbit.jcr2spi.operation.SetMixin;
import org.apache.jackrabbit.jcr2spi.operation.SetPropertyValue;
import org.apache.jackrabbit.jcr2spi.state.NodeState;
import org.apache.jackrabbit.jcr2spi.state.PropertyState;
import org.apache.jackrabbit.jcr2spi.state.SessionItemStateManager;
import org.apache.jackrabbit.jcr2spi.util.LogUtil;
import org.apache.jackrabbit.jcr2spi.util.ReferenceChangeTracker;
import org.apache.jackrabbit.jcr2spi.xml.Importer;
import org.apache.jackrabbit.spi.Name;
import org.apache.jackrabbit.spi.NodeId;
import org.apache.jackrabbit.spi.Path;
import org.apache.jackrabbit.spi.QNodeDefinition;
import org.apache.jackrabbit.spi.QPropertyDefinition;
import org.apache.jackrabbit.spi.QValue;
import org.apache.jackrabbit.spi.commons.conversion.NamePathResolver;
import org.apache.jackrabbit.spi.commons.name.NameConstants;
import org.apache.jackrabbit.spi.commons.value.ValueFormat;
import org.apache.jackrabbit.util.Base64;
import org.apache.jackrabbit.util.TransientFileFactory;
import org.apache.jackrabbit.value.ValueHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SessionImporter
implements Importer,
SessionListener {
    private static Logger log = LoggerFactory.getLogger(SessionImporter.class);
    private final NodeState importTarget;
    private final int uuidBehavior;
    private final SessionImpl session;
    private final SessionItemStateManager stateMgr;
    private final Stack<NodeState> parents;
    private boolean importerClosed;
    private boolean sessionClosed;
    private final ReferenceChangeTracker refTracker;

    public SessionImporter(Path parentPath, SessionImpl session, SessionItemStateManager stateManager, int uuidBehavior) throws PathNotFoundException, ConstraintViolationException, VersionException, LockException, RepositoryException {
        this.session = session;
        this.stateMgr = stateManager;
        this.uuidBehavior = uuidBehavior;
        try {
            this.importTarget = session.getHierarchyManager().getNodeState(parentPath);
            int options = 7;
            session.getValidator().checkIsWritable(this.importTarget, options);
            this.refTracker = new ReferenceChangeTracker();
            this.parents = new Stack();
            this.parents.push(this.importTarget);
        }
        catch (ItemNotFoundException e) {
            throw new PathNotFoundException(LogUtil.safeGetJCRPath(parentPath, session.getPathResolver()));
        }
    }

    @Override
    public void start() throws RepositoryException {
        this.setClosed(false);
    }

    @Override
    public void startNode(Importer.NodeInfo nodeInfo, List<Importer.PropInfo> propInfos, NamePathResolver resolver) throws RepositoryException {
        NodeState nodeState;
        NodeState parent;
        block14: {
            if (this.isClosed()) {
                return;
            }
            this.checkSession();
            parent = this.parents.peek();
            if (parent == null) {
                this.parents.push(null);
                log.debug("Skipping node '" + nodeInfo.getName() + "'.");
                return;
            }
            NodeEntry parentEntry = (NodeEntry)parent.getHierarchyEntry();
            nodeState = null;
            if (parentEntry.hasNodeEntry(nodeInfo.getName())) {
                try {
                    NodeEntry entry = parentEntry.getNodeEntry(nodeInfo.getName(), 1);
                    NodeState existing = entry.getNodeState();
                    QNodeDefinition def = existing.getDefinition();
                    if (def.allowsSameNameSiblings()) break block14;
                    EffectiveNodeTypeProvider provider = this.session.getEffectiveNodeTypeProvider();
                    Name[] ntNames = existing.getAllNodeTypeNames();
                    EffectiveNodeType entExisting = provider.getEffectiveNodeType(ntNames);
                    if (def.isProtected() && entExisting.includesNodeType(nodeInfo.getNodeTypeName())) {
                        this.parents.push(null);
                        log.debug("skipping protected node " + LogUtil.safeGetJCRPath(existing, this.session.getPathResolver()));
                        return;
                    }
                    if (def.isAutoCreated() && entExisting.includesNodeType(nodeInfo.getNodeTypeName())) {
                        nodeState = existing;
                        break block14;
                    }
                    throw new ItemExistsException(LogUtil.safeGetJCRPath(existing, this.session.getPathResolver()));
                }
                catch (ItemNotFoundException entry) {
                    // empty catch block
                }
            }
        }
        if (nodeState == null) {
            if (nodeInfo.getUUID() == null) {
                nodeState = this.importNode(nodeInfo, parent);
            } else {
                this.checkIncludesMixReferenceable(nodeInfo);
                try {
                    NodeId conflictingId = this.session.getIdFactory().createNodeId(nodeInfo.getUUID());
                    NodeEntry conflicting = this.session.getHierarchyManager().getNodeEntry(conflictingId);
                    conflicting.getItemState();
                    nodeState = this.resolveUUIDConflict(parent, conflicting, nodeInfo);
                }
                catch (ItemNotFoundException e) {
                    nodeState = this.importNode(nodeInfo, parent);
                }
            }
        }
        if (nodeState != null) {
            for (Importer.PropInfo pi : propInfos) {
                this.importProperty(pi, nodeState, resolver);
            }
        }
        this.parents.push(nodeState);
    }

    @Override
    public void endNode(Importer.NodeInfo nodeInfo) throws RepositoryException {
        if (this.isClosed()) {
            return;
        }
        this.parents.pop();
    }

    @Override
    public void end() throws RepositoryException {
        if (this.isClosed()) {
            return;
        }
        try {
            this.checkSession();
            this.stateMgr.adjustReferences(this.refTracker);
        }
        finally {
            this.setClosed(true);
        }
    }

    @Override
    public void loggingOut(Session session) {
        this.sessionClosed = true;
    }

    @Override
    public void loggedOut(Session session) {
    }

    private void setClosed(boolean isClosed) {
        this.importerClosed = isClosed;
        if (isClosed) {
            this.session.removeListener(this);
        } else {
            this.session.addListener(this);
        }
    }

    private boolean isClosed() {
        return this.importerClosed;
    }

    private void checkSession() throws RepositoryException {
        if (this.sessionClosed) {
            throw new RepositoryException("This session has been closed.");
        }
    }

    NodeState resolveUUIDConflict(NodeState parent, NodeEntry conflicting, Importer.NodeInfo nodeInfo) throws ItemExistsException, RepositoryException {
        NodeState nodeState;
        switch (this.uuidBehavior) {
            case 0: {
                String originalUUID = nodeInfo.getUUID();
                String newUUID = UUID.randomUUID().toString();
                nodeInfo.setUUID(newUUID);
                nodeState = this.importNode(nodeInfo, parent);
                if (nodeState == null) break;
                this.refTracker.mappedUUIDs(originalUUID, newUUID);
                break;
            }
            case 3: {
                String msg = "a node with uuid " + nodeInfo.getUUID() + " already exists!";
                log.debug(msg);
                throw new ItemExistsException(msg);
            }
            case 1: {
                Path p0 = this.importTarget.getPath();
                Path p1 = conflicting.getPath();
                if (p1.equals(p0) || p1.isAncestorOf(p0)) {
                    String msg = "cannot remove ancestor node";
                    log.debug(msg);
                    throw new ConstraintViolationException(msg);
                }
                try {
                    Operation op = Remove.create(conflicting.getNodeState());
                    this.stateMgr.execute(op);
                }
                catch (ItemNotFoundException op) {
                    // empty catch block
                }
                nodeState = this.importNode(nodeInfo, parent);
                break;
            }
            case 2: {
                if (conflicting.getNodeState().isRoot()) {
                    String msg = "Root node cannot be replaced";
                    log.debug(msg);
                    throw new RepositoryException(msg);
                }
                parent = conflicting.getParent().getNodeState();
                Operation op = Remove.create(conflicting.getNodeState());
                this.stateMgr.execute(op);
                nodeState = this.importNode(nodeInfo, parent);
                break;
            }
            default: {
                String msg = "Unknown uuidBehavior: " + this.uuidBehavior;
                log.debug(msg);
                throw new RepositoryException(msg);
            }
        }
        return nodeState;
    }

    private NodeState importNode(Importer.NodeInfo nodeInfo, NodeState parent) throws ConstraintViolationException, ItemNotFoundException, RepositoryException {
        QNodeDefinition def;
        PropertyState conflicting;
        Name[] parentNtNames = parent.getAllNodeTypeNames();
        if (parent.hasPropertyName(nodeInfo.getName()) && (conflicting = parent.getPropertyState(nodeInfo.getName())).getStatus() == 4) {
            QPropertyDefinition propDef;
            Name newName = this.session.getNameFactory().create(nodeInfo.getName().getNamespaceURI(), nodeInfo.getName().getLocalName() + "_");
            if (parent.hasPropertyName(newName)) {
                newName = this.session.getNameFactory().create(newName.getNamespaceURI(), newName.getLocalName() + "_");
            }
            if (conflicting.getValues().length == 1) {
                try {
                    propDef = this.session.getItemDefinitionProvider().getQPropertyDefinition(parentNtNames, newName, conflicting.getType(), false);
                }
                catch (ConstraintViolationException cve) {
                    propDef = this.session.getItemDefinitionProvider().getQPropertyDefinition(parentNtNames, newName, conflicting.getType(), true);
                }
            } else {
                propDef = this.session.getItemDefinitionProvider().getQPropertyDefinition(parentNtNames, newName, conflicting.getType(), true);
            }
            Operation ap = AddProperty.create(parent, newName, conflicting.getType(), propDef, conflicting.getValues());
            this.stateMgr.execute(ap);
            Operation rm = Remove.create(conflicting);
            this.stateMgr.execute(rm);
        }
        if ((def = this.session.getItemDefinitionProvider().getQNodeDefinition(parentNtNames, nodeInfo.getName(), nodeInfo.getNodeTypeName())).isProtected()) {
            log.debug("Skipping protected nodeState (" + nodeInfo.getName() + ")");
            return null;
        }
        Name ntName = nodeInfo.getNodeTypeName();
        if (ntName == null) {
            ntName = def.getDefaultPrimaryType();
        }
        Operation an = AddNode.create(parent, nodeInfo.getName(), ntName, nodeInfo.getUUID());
        this.stateMgr.execute(an);
        NodeState childState = (NodeState)((AddNode)an).getAddedStates().get(0);
        Name[] mixinNames = nodeInfo.getMixinNames();
        if (mixinNames != null && mixinNames.length > 0) {
            Operation sm = SetMixin.create(childState, nodeInfo.getMixinNames());
            this.stateMgr.execute(sm);
        }
        return childState;
    }

    private void importProperty(Importer.PropInfo pi, NodeState parentState, NamePathResolver resolver) throws RepositoryException, ConstraintViolationException {
        Name propName = pi.getName();
        Importer.TextValue[] tva = pi.getValues();
        int infoType = pi.getType();
        PropertyState propState = null;
        QPropertyDefinition def = null;
        NodeEntry parentEntry = (NodeEntry)parentState.getHierarchyEntry();
        PropertyEntry pEntry = parentEntry.getPropertyEntry(propName);
        if (pEntry != null) {
            try {
                PropertyState existing = pEntry.getPropertyState();
                def = existing.getDefinition();
                if (def.isProtected()) {
                    log.debug("skipping protected property " + LogUtil.safeGetJCRPath(existing, this.session.getPathResolver()));
                    return;
                }
                if (!def.isAutoCreated() || existing.getType() != infoType && infoType != 0 || def.isMultiple() != existing.isMultiValued()) {
                    throw new ItemExistsException(LogUtil.safeGetJCRPath(existing, this.session.getPathResolver()));
                }
                propState = existing;
            }
            catch (ItemNotFoundException existing) {
                // empty catch block
            }
        }
        Name[] parentNtNames = parentState.getAllNodeTypeNames();
        if (def == null && (def = tva.length == 1 ? this.session.getItemDefinitionProvider().getQPropertyDefinition(parentNtNames, propName, infoType) : this.session.getItemDefinitionProvider().getQPropertyDefinition(parentNtNames, propName, infoType, true)).isProtected()) {
            log.debug("skipping protected property " + propName);
            return;
        }
        int targetType = def.getRequiredType();
        if (targetType == 0) {
            targetType = infoType == 0 ? 1 : infoType;
        }
        QValue[] values = this.getPropertyValues(pi, targetType, def.isMultiple(), resolver);
        if (propState == null) {
            Operation ap = AddProperty.create(parentState, propName, targetType, def, values);
            this.stateMgr.execute(ap);
            propState = parentEntry.getPropertyEntry(propName).getPropertyState();
        } else {
            Operation sp = SetPropertyValue.create(propState, values, targetType);
            this.stateMgr.execute(sp);
        }
        if (propState.getType() == 9) {
            this.refTracker.processedReference(propState);
        }
    }

    private QValue[] getPropertyValues(Importer.PropInfo propertyInfo, int targetType, boolean isMultiple, NamePathResolver resolver) throws RepositoryException {
        Importer.TextValue[] tva = propertyInfo.getValues();
        if (!(tva.length != 0 && tva.length <= 1 || isMultiple)) {
            throw new ConstraintViolationException(propertyInfo.getName() + " is not multi-valued.");
        }
        QValue[] iva = new QValue[tva.length];
        for (int i = 0; i < tva.length; ++i) {
            iva[i] = this.buildQValue(tva[i], targetType, resolver);
        }
        return iva;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private QValue buildQValue(Importer.TextValue tv, int targetType, NamePathResolver resolver) throws RepositoryException {
        try {
            QValue iv;
            switch (targetType) {
                case 2: {
                    if (tv.length() < 65536L) {
                        ByteArrayOutputStream baos = new ByteArrayOutputStream();
                        Base64.decode(tv.retrieve(), (OutputStream)baos);
                        iv = this.session.getQValueFactory().create(baos.toByteArray());
                        break;
                    }
                    TransientFileFactory fileFactory = TransientFileFactory.getInstance();
                    File tmpFile = fileFactory.createTransientFile("bin", null, null);
                    FileOutputStream out = new FileOutputStream(tmpFile);
                    Reader reader = tv.reader();
                    try {
                        Base64.decode(reader, (OutputStream)out);
                    }
                    finally {
                        reader.close();
                        out.close();
                    }
                    iv = this.session.getQValueFactory().create(tmpFile);
                    break;
                }
                default: {
                    Value v = ValueHelper.convert(tv.retrieve(), targetType, this.session.getValueFactory());
                    iv = ValueFormat.getQValue(v, resolver, this.session.getQValueFactory());
                }
            }
            return iv;
        }
        catch (IOException e) {
            String msg = "failed to retrieve serialized value";
            log.debug(msg, e);
            throw new RepositoryException(msg, e);
        }
    }

    private void checkIncludesMixReferenceable(Importer.NodeInfo nodeInfo) throws RepositoryException {
        ArrayList<Name> l = new ArrayList<Name>();
        l.add(nodeInfo.getNodeTypeName());
        Name[] mixinNames = nodeInfo.getMixinNames();
        if (mixinNames != null && mixinNames.length > 0) {
            l.addAll(Arrays.asList(nodeInfo.getMixinNames()));
        }
        if (l.contains(NameConstants.MIX_REFERENCEABLE)) {
            return;
        }
        Name[] ntNames = l.toArray(new Name[l.size()]);
        EffectiveNodeType ent = this.session.getEffectiveNodeTypeProvider().getEffectiveNodeType(ntNames);
        if (!ent.includesNodeType(NameConstants.MIX_REFERENCEABLE)) {
            throw new ConstraintViolationException("XML defines jcr:uuid without defining import node to be referenceable.");
        }
    }
}

