/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.security.user;

import java.security.Principal;
import java.util.HashSet;
import java.util.Set;
import javax.jcr.RepositoryException;
import javax.jcr.Value;
import javax.security.auth.Subject;
import org.apache.jackrabbit.api.security.principal.PrincipalIterator;
import org.apache.jackrabbit.api.security.principal.PrincipalManager;
import org.apache.jackrabbit.api.security.user.Authorizable;
import org.apache.jackrabbit.api.security.user.Impersonation;
import org.apache.jackrabbit.core.NodeImpl;
import org.apache.jackrabbit.core.PropertyImpl;
import org.apache.jackrabbit.core.security.principal.GroupPrincipals;
import org.apache.jackrabbit.core.security.principal.PrincipalImpl;
import org.apache.jackrabbit.core.security.principal.PrincipalIteratorAdapter;
import org.apache.jackrabbit.core.security.user.UserConstants;
import org.apache.jackrabbit.core.security.user.UserImpl;
import org.apache.jackrabbit.core.security.user.UserManagerImpl;
import org.apache.jackrabbit.value.StringValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ImpersonationImpl
implements Impersonation,
UserConstants {
    private static final Logger log = LoggerFactory.getLogger(ImpersonationImpl.class);
    private final UserImpl user;
    private final UserManagerImpl userManager;

    ImpersonationImpl(UserImpl user, UserManagerImpl userManager) throws RepositoryException {
        this.user = user;
        this.userManager = userManager;
    }

    @Override
    public PrincipalIterator getImpersonators() throws RepositoryException {
        Set<String> impersonators = this.getImpersonatorNames();
        if (impersonators.isEmpty()) {
            return PrincipalIteratorAdapter.EMPTY;
        }
        PrincipalManager pMgr = this.user.getSession().getPrincipalManager();
        HashSet<Principal> s = new HashSet<Principal>();
        for (String pName : impersonators) {
            Principal p = pMgr.getPrincipal(pName);
            if (p == null) {
                log.debug("Impersonator " + pName + " does not correspond to a known Principal.");
                p = new PrincipalImpl(pName);
            }
            s.add(p);
        }
        return new PrincipalIteratorAdapter(s);
    }

    @Override
    public synchronized boolean grantImpersonation(Principal principal) throws RepositoryException {
        Authorizable auth = this.user.userManager.getAuthorizable(principal);
        if (auth == null || auth.isGroup()) {
            log.warn("Cannot grant impersonation to a principal that is a Group or an unknown Authorizable.");
            return false;
        }
        if (this.user.userManager.isAdminId(auth.getID())) {
            log.warn("Admin principal is already granted impersonation.");
            return false;
        }
        String pName = principal.getName();
        if (this.user.getPrincipal().getName().equals(pName)) {
            log.warn("Cannot grant impersonation to oneself.");
            return false;
        }
        boolean granted = false;
        Set<String> impersonators = this.getImpersonatorNames();
        if (impersonators.add(pName)) {
            this.updateImpersonatorNames(impersonators);
            granted = true;
        }
        return granted;
    }

    @Override
    public synchronized boolean revokeImpersonation(Principal principal) throws RepositoryException {
        boolean revoked = false;
        String pName = principal.getName();
        Set<String> impersonators = this.getImpersonatorNames();
        if (impersonators.remove(pName)) {
            this.updateImpersonatorNames(impersonators);
            revoked = true;
        }
        return revoked;
    }

    @Override
    public boolean allows(Subject subject) throws RepositoryException {
        if (subject == null) {
            return false;
        }
        HashSet<String> principalNames = new HashSet<String>();
        for (Principal p : subject.getPrincipals()) {
            principalNames.add(p.getName());
        }
        Set<String> impersonators = this.getImpersonatorNames();
        boolean allows = impersonators.removeAll(principalNames);
        if (!allows) {
            for (Principal p : subject.getPrincipals()) {
                Authorizable a;
                if (GroupPrincipals.isGroup(p) || (a = this.userManager.getAuthorizable(p)) == null || !this.userManager.isAdminId(a.getID())) continue;
                allows = true;
                break;
            }
        }
        return allows;
    }

    private Set<String> getImpersonatorNames() throws RepositoryException {
        HashSet<String> princNames = new HashSet<String>();
        if (this.user.getNode().hasProperty(P_IMPERSONATORS)) {
            Value[] vs;
            for (Value v : vs = this.user.getNode().getProperty(P_IMPERSONATORS).getValues()) {
                princNames.add(v.getString());
            }
        }
        return princNames;
    }

    private void updateImpersonatorNames(Set<String> principalNames) throws RepositoryException {
        NodeImpl userNode = this.user.getNode();
        try {
            String[] pNames = principalNames.toArray(new String[principalNames.size()]);
            if (pNames.length == 0) {
                PropertyImpl prop = userNode.getProperty(P_IMPERSONATORS);
                this.userManager.removeProtectedItem(prop, userNode);
            } else {
                Value[] values = new Value[pNames.length];
                for (int i = 0; i < pNames.length; ++i) {
                    values[i] = new StringValue(pNames[i]);
                }
                this.userManager.setProtectedProperty(userNode, P_IMPERSONATORS, values);
            }
        }
        catch (RepositoryException e) {
            userNode.refresh(false);
            throw e;
        }
    }
}

