/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.security.authorization;

import java.util.Map;
import java.util.Set;
import javax.jcr.RepositoryException;
import javax.jcr.security.Privilege;
import org.apache.commons.collections4.map.LRUMap;
import org.apache.jackrabbit.core.security.authorization.CompiledPermissions;
import org.apache.jackrabbit.core.security.authorization.Permission;
import org.apache.jackrabbit.core.security.authorization.PrivilegeBits;
import org.apache.jackrabbit.core.security.authorization.PrivilegeManagerImpl;
import org.apache.jackrabbit.core.security.authorization.PrivilegeRegistry;
import org.apache.jackrabbit.spi.Path;

public abstract class AbstractCompiledPermissions
implements CompiledPermissions {
    private final Map<Path, Result> cache;
    private final Object monitor = new Object();

    protected AbstractCompiledPermissions() {
        this.cache = new LRUMap<Path, Result>(1000);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Result getResult(Path absPath) throws RepositoryException {
        Result result;
        Object object = this.monitor;
        synchronized (object) {
            result = this.cache.get(absPath);
            if (result == null) {
                result = absPath == null ? this.buildRepositoryResult() : this.buildResult(absPath);
                this.cache.put(absPath, result);
            }
        }
        return result;
    }

    protected abstract Result buildResult(Path var1) throws RepositoryException;

    protected abstract Result buildRepositoryResult() throws RepositoryException;

    protected abstract PrivilegeManagerImpl getPrivilegeManagerImpl() throws RepositoryException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void clearCache() {
        Object object = this.monitor;
        synchronized (object) {
            this.cache.clear();
        }
    }

    @Override
    public void close() {
        this.clearCache();
    }

    @Override
    public boolean grants(Path absPath, int permissions) throws RepositoryException {
        return this.getResult(absPath).grants(permissions);
    }

    @Override
    public int getPrivileges(Path absPath) throws RepositoryException {
        Set<Privilege> pvs = this.getPrivilegeSet(absPath);
        return PrivilegeRegistry.getBits(pvs.toArray(new Privilege[pvs.size()]));
    }

    @Override
    public boolean hasPrivileges(Path absPath, Privilege ... privileges) throws RepositoryException {
        Result result = this.getResult(absPath);
        PrivilegeBits bits = this.getPrivilegeManagerImpl().getBits(privileges);
        return result.allowPrivileges.includes(bits);
    }

    @Override
    public Set<Privilege> getPrivilegeSet(Path absPath) throws RepositoryException {
        Result result = this.getResult(absPath);
        return this.getPrivilegeManagerImpl().getPrivileges(result.allowPrivileges);
    }

    @Override
    public boolean canReadAll() throws RepositoryException {
        return false;
    }

    public static class Result {
        public static final Result EMPTY = new Result(0, 0, PrivilegeBits.EMPTY, PrivilegeBits.EMPTY);
        private final int allows;
        private final int denies;
        private final PrivilegeBits allowPrivileges;
        private final PrivilegeBits denyPrivileges;
        private int hashCode = -1;

        public Result(int allows, int denies, int allowPrivileges, int denyPrivileges) {
            this(allows, denies, PrivilegeBits.getInstance(allowPrivileges), PrivilegeBits.getInstance(denyPrivileges));
        }

        public Result(int allows, int denies, PrivilegeBits allowPrivileges, PrivilegeBits denyPrivileges) {
            this.allows = allows;
            this.denies = denies;
            this.allowPrivileges = allowPrivileges.unmodifiable();
            this.denyPrivileges = denyPrivileges.unmodifiable();
        }

        public boolean grants(int permissions) {
            return (this.allows | ~permissions) == -1;
        }

        public int getPrivileges() {
            throw new UnsupportedOperationException("use #getPrivilegeBits instead.");
        }

        public PrivilegeBits getPrivilegeBits() {
            return this.allowPrivileges;
        }

        public Result combine(Result other) {
            int cAllows = this.allows | Permission.diff(other.allows, this.denies);
            int cDenies = this.denies | Permission.diff(other.denies, this.allows);
            PrivilegeBits cAPrivs = PrivilegeBits.getInstance(this.allowPrivileges);
            cAPrivs.addDifference(other.allowPrivileges, this.denyPrivileges);
            PrivilegeBits cdPrivs = PrivilegeBits.getInstance(this.denyPrivileges);
            cdPrivs.addDifference(other.denyPrivileges, this.allowPrivileges);
            return new Result(cAllows, cDenies, this.allowPrivileges, this.denyPrivileges);
        }

        public int hashCode() {
            if (this.hashCode == -1) {
                int h = 17;
                h = 37 * h + this.allows;
                h = 37 * h + this.denies;
                h = 37 * h + this.allowPrivileges.hashCode();
                this.hashCode = h = 37 * h + this.denyPrivileges.hashCode();
            }
            return this.hashCode;
        }

        public boolean equals(Object object) {
            if (object == this) {
                return true;
            }
            if (object instanceof Result) {
                Result other = (Result)object;
                return this.allows == other.allows && this.denies == other.denies && this.allowPrivileges.equals(other.allowPrivileges) && this.denyPrivileges.equals(other.denyPrivileges);
            }
            return false;
        }
    }
}

