/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.query.lucene;

import java.io.IOException;
import java.util.Arrays;
import org.apache.jackrabbit.core.query.lucene.FilterMultiColumnQueryHits;
import org.apache.jackrabbit.core.query.lucene.JackrabbitIndexSearcher;
import org.apache.jackrabbit.core.query.lucene.MultiColumnQuery;
import org.apache.jackrabbit.core.query.lucene.MultiColumnQueryHits;
import org.apache.jackrabbit.core.query.lucene.Ordering;
import org.apache.jackrabbit.core.query.lucene.ScoreNode;
import org.apache.jackrabbit.core.query.lucene.SortedMultiColumnQueryHits;
import org.apache.jackrabbit.core.query.lucene.constraint.Constraint;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FilterMultiColumnQuery
implements MultiColumnQuery {
    private static final Logger log = LoggerFactory.getLogger(FilterMultiColumnQuery.class);
    private final MultiColumnQuery query;
    private final Constraint constraint;

    public FilterMultiColumnQuery(MultiColumnQuery query, Constraint constraint) {
        this.query = query;
        this.constraint = constraint;
    }

    @Override
    public MultiColumnQueryHits execute(final JackrabbitIndexSearcher searcher, Ordering[] orderings, long resultFetchHint) throws IOException {
        FilterMultiColumnQueryHits hits = new FilterMultiColumnQueryHits(this.query.execute(searcher, orderings, resultFetchHint)){
            {
                super(hits);
                log.debug(Arrays.asList(this.getSelectorNames()).toString());
            }

            @Override
            public ScoreNode[] nextScoreNodes() throws IOException {
                ScoreNode[] next;
                do {
                    next = super.nextScoreNodes();
                    if (!log.isDebugEnabled() || next == null) continue;
                    log.debug(Arrays.asList(next).toString());
                } while (next != null && !FilterMultiColumnQuery.this.constraint.evaluate(next, this.getSelectorNames(), searcher));
                return next;
            }

            @Override
            public int getSize() {
                return -1;
            }

            @Override
            public void skip(int n) throws IOException {
                while (n-- > 0) {
                    this.nextScoreNodes();
                }
            }
        };
        if (orderings.length > 0) {
            hits = new SortedMultiColumnQueryHits(hits, orderings, searcher.getIndexReader());
        }
        return hits;
    }
}

