/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tsfile.read.filter.basic;

import java.io.DataOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import org.apache.tsfile.block.column.Column;
import org.apache.tsfile.read.common.block.TsBlock;
import org.apache.tsfile.read.filter.basic.ValueFilter;
import org.apache.tsfile.utils.Binary;
import org.apache.tsfile.utils.ReadWriteIOUtils;

public abstract class StringFilter
extends ValueFilter {
    protected StringFilter(int measurementIndex) {
        super(measurementIndex);
    }

    protected StringFilter(ByteBuffer buffer) {
        super(buffer);
    }

    @Override
    public boolean satisfyBinary(long time, Binary value) {
        if (value == null) {
            return false;
        }
        return this.valueSatisfy(value);
    }

    @Override
    public ReadWriteIOUtils.ClassSerializeId getClassSerializeId() {
        return ReadWriteIOUtils.ClassSerializeId.STRING;
    }

    protected abstract boolean valueSatisfy(Binary var1);

    @Override
    public boolean[] satisfyTsBlock(boolean[] selection, TsBlock tsBlock) {
        Column valueColumn = tsBlock.getValueColumns()[this.measurementIndex];
        boolean[] satisfyInfo = new boolean[selection.length];
        System.arraycopy(selection, 0, satisfyInfo, 0, selection.length);
        for (int i = 0; i < selection.length; ++i) {
            if (!selection[i]) continue;
            satisfyInfo[i] = valueColumn.isNull(i) ? false : this.valueSatisfy(valueColumn.getBinary(i));
        }
        return satisfyInfo;
    }

    @Override
    public void serialize(DataOutputStream outputStream) throws IOException {
        super.serialize(outputStream);
    }
}

