/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.metrics.utils;

import java.util.Map;
import org.apache.iotdb.metrics.config.MetricConfig;
import org.apache.iotdb.metrics.config.MetricConfigDescriptor;
import org.apache.iotdb.metrics.utils.MetricInfo;

public class IoTDBMetricsUtils {
    private static final MetricConfig METRIC_CONFIG = MetricConfigDescriptor.getInstance().getMetricConfig();

    public static String generatePath(MetricInfo metricInfo) {
        return IoTDBMetricsUtils.generatePath(metricInfo.getName(), metricInfo.getTags());
    }

    public static String generatePath(String name, String ... tags) {
        StringBuilder stringBuilder = IoTDBMetricsUtils.generateMetric(name);
        for (int i = 0; i < tags.length; i += 2) {
            stringBuilder.append(".").append("`").append(tags[i].replace("`", "``")).append("=").append(tags[i + 1].replace("`", "``")).append("`");
        }
        return stringBuilder.toString();
    }

    public static String generatePath(String name, Map<String, String> tags) {
        StringBuilder stringBuilder = IoTDBMetricsUtils.generateMetric(name);
        for (Map.Entry<String, String> entry : tags.entrySet()) {
            stringBuilder.append(".").append("`").append(entry.getKey().replace("`", "``")).append("=").append(entry.getValue().replace("`", "``")).append("`");
        }
        return stringBuilder.toString();
    }

    private static StringBuilder generateMetric(String name) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(METRIC_CONFIG.getInternalDatabase()).append(".").append(METRIC_CONFIG.getIoTDBReporterConfig().getLocation()).append(".`").append(METRIC_CONFIG.getClusterName()).append("`.").append(METRIC_CONFIG.getNodeType().toString()).append(".`").append(METRIC_CONFIG.getNodeId()).append("`").append(".").append("`").append(name.replace("`", "``")).append("`");
        return stringBuilder;
    }
}

