/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.plan.planner.plan.node.process;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.apache.iotdb.db.queryengine.plan.expression.Expression;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.PlanNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.PlanNodeId;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.PlanNodeType;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.PlanVisitor;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.process.MultiChildProcessNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.parameter.OrderByParameter;
import org.apache.tsfile.utils.ReadWriteIOUtils;

public class AggregationMergeSortNode
extends MultiChildProcessNode {
    private final OrderByParameter mergeOrderParameter;
    private final List<String> outputColumns;
    private final Set<Expression> selectExpressions;
    private boolean hasGroupBy;

    public AggregationMergeSortNode(PlanNodeId id, OrderByParameter mergeOrderParameter, List<String> outputColumns, Set<Expression> selectExpressions, boolean hasGroupBy) {
        super(id);
        this.mergeOrderParameter = mergeOrderParameter;
        this.outputColumns = outputColumns;
        this.selectExpressions = selectExpressions;
        this.hasGroupBy = hasGroupBy;
    }

    public AggregationMergeSortNode(PlanNodeId id, List<PlanNode> children, OrderByParameter mergeOrderParameter, List<String> outputColumns, Set<Expression> selectExpressions, boolean hasGroupBy) {
        super(id, children);
        this.mergeOrderParameter = mergeOrderParameter;
        this.outputColumns = outputColumns;
        this.selectExpressions = selectExpressions;
        this.hasGroupBy = hasGroupBy;
    }

    public OrderByParameter getMergeOrderParameter() {
        return this.mergeOrderParameter;
    }

    public Set<Expression> getSelectExpressions() {
        return this.selectExpressions;
    }

    public boolean isHasGroupBy() {
        return this.hasGroupBy;
    }

    @Override
    public PlanNode clone() {
        return new AggregationMergeSortNode(this.getPlanNodeId(), this.getMergeOrderParameter(), this.outputColumns, this.selectExpressions, this.hasGroupBy);
    }

    @Override
    public PlanNode createSubNode(int subNodeId, int startIndex, int endIndex) {
        return new AggregationMergeSortNode(new PlanNodeId(String.format("%s-%s", this.getPlanNodeId(), subNodeId)), new ArrayList<PlanNode>(this.children.subList(startIndex, endIndex)), this.getMergeOrderParameter(), this.outputColumns, this.selectExpressions, this.hasGroupBy);
    }

    @Override
    public List<String> getOutputColumnNames() {
        return this.outputColumns;
    }

    @Override
    public <R, C> R accept(PlanVisitor<R, C> visitor, C context) {
        return visitor.visitAggregationMergeSort(this, context);
    }

    @Override
    protected void serializeAttributes(ByteBuffer byteBuffer) {
        PlanNodeType.AGG_MERGE_SORT.serialize(byteBuffer);
        this.mergeOrderParameter.serializeAttributes(byteBuffer);
        ReadWriteIOUtils.write((int)this.outputColumns.size(), (ByteBuffer)byteBuffer);
        for (String column : this.outputColumns) {
            ReadWriteIOUtils.write((String)column, (ByteBuffer)byteBuffer);
        }
        ReadWriteIOUtils.write((int)this.selectExpressions.size(), (ByteBuffer)byteBuffer);
        for (Expression expression : this.selectExpressions) {
            Expression.serialize(expression, byteBuffer);
        }
        ReadWriteIOUtils.write((Boolean)this.hasGroupBy, (ByteBuffer)byteBuffer);
    }

    @Override
    protected void serializeAttributes(DataOutputStream stream) throws IOException {
        PlanNodeType.AGG_MERGE_SORT.serialize(stream);
        this.mergeOrderParameter.serializeAttributes(stream);
        ReadWriteIOUtils.write((int)this.outputColumns.size(), (OutputStream)stream);
        for (String column : this.outputColumns) {
            ReadWriteIOUtils.write((String)column, (OutputStream)stream);
        }
        ReadWriteIOUtils.write((int)this.selectExpressions.size(), (OutputStream)stream);
        for (Expression expression : this.selectExpressions) {
            Expression.serialize(expression, stream);
        }
        ReadWriteIOUtils.write((Boolean)this.hasGroupBy, (OutputStream)stream);
    }

    public static AggregationMergeSortNode deserialize(ByteBuffer byteBuffer) {
        OrderByParameter orderByParameter = OrderByParameter.deserialize(byteBuffer);
        ArrayList<String> outputColumns = new ArrayList<String>();
        for (int columnSize = ReadWriteIOUtils.readInt((ByteBuffer)byteBuffer); columnSize > 0; --columnSize) {
            outputColumns.add(ReadWriteIOUtils.readString((ByteBuffer)byteBuffer));
        }
        LinkedHashSet<Expression> expressions = new LinkedHashSet<Expression>();
        for (int expressionSize = ReadWriteIOUtils.readInt((ByteBuffer)byteBuffer); expressionSize > 0; --expressionSize) {
            expressions.add(Expression.deserialize(byteBuffer));
        }
        boolean hasGroupBy = ReadWriteIOUtils.readBool((ByteBuffer)byteBuffer);
        PlanNodeId planNodeId = PlanNodeId.deserialize(byteBuffer);
        return new AggregationMergeSortNode(planNodeId, orderByParameter, outputColumns, expressions, hasGroupBy);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        AggregationMergeSortNode that = (AggregationMergeSortNode)o;
        return Objects.equals(this.mergeOrderParameter, that.getMergeOrderParameter());
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.mergeOrderParameter);
    }

    public String toString() {
        return "AggregationMergeSort-" + this.getPlanNodeId();
    }
}

