/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.library.dprofile;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.iotdb.library.dprofile.util.Segment;
import org.apache.iotdb.library.util.Util;
import org.apache.iotdb.udf.api.UDTF;
import org.apache.iotdb.udf.api.access.Row;
import org.apache.iotdb.udf.api.collector.PointCollector;
import org.apache.iotdb.udf.api.customizer.config.UDTFConfigurations;
import org.apache.iotdb.udf.api.customizer.parameter.UDFParameterValidator;
import org.apache.iotdb.udf.api.customizer.parameter.UDFParameters;
import org.apache.iotdb.udf.api.customizer.strategy.RowByRowAccessStrategy;
import org.apache.iotdb.udf.api.type.Type;

public class UDTFSegment
implements UDTF {
    private int windowSize;
    private double maxError;
    private String method;
    private static final String METHOD_BOTTOM_UP = "bottom-up";
    private String output;
    private static final String OUTPUT_FIRST = "first";
    private static final List<Long> timestamp = new ArrayList<Long>();
    private static final List<Double> value = new ArrayList<Double>();

    @Override
    public void validate(UDFParameterValidator validator) throws Exception {
        validator.validateInputSeriesDataType(0, Type.INT32, Type.INT64, Type.FLOAT, Type.DOUBLE).validate(x -> (Integer)x > 0, "Window size should be a positive integer.", (Object)validator.getParameters().getIntOrDefault("window", 10)).validate(x -> (Double)x >= 0.0, "Error bound should be no less than 0.", (Object)validator.getParameters().getDoubleOrDefault("error", 0.1)).validate(x -> ((String)x).equalsIgnoreCase(METHOD_BOTTOM_UP) || ((String)x).equalsIgnoreCase("swab"), "Method is illegal.", (Object)validator.getParameters().getStringOrDefault("method", METHOD_BOTTOM_UP)).validate(x -> ((String)x).equalsIgnoreCase(OUTPUT_FIRST) || ((String)x).equalsIgnoreCase("all"), "Output type is invalid.", (Object)validator.getParameters().getStringOrDefault("output", OUTPUT_FIRST));
    }

    @Override
    public void beforeStart(UDFParameters parameters, UDTFConfigurations configurations) throws Exception {
        configurations.setAccessStrategy(new RowByRowAccessStrategy()).setOutputDataType(Type.DOUBLE);
        timestamp.clear();
        value.clear();
        this.windowSize = parameters.getIntOrDefault("window", 10);
        this.maxError = parameters.getDoubleOrDefault("error", 0.1);
        this.method = parameters.getStringOrDefault("method", METHOD_BOTTOM_UP);
        this.method = this.method.toLowerCase();
        this.output = parameters.getStringOrDefault("output", OUTPUT_FIRST);
        this.output = this.output.toLowerCase();
    }

    @Override
    public void transform(Row row, PointCollector collector) throws Exception {
        double v = Util.getValueAsDouble(row);
        if (Double.isFinite(v)) {
            timestamp.add(row.getTime());
            value.add(Util.getValueAsDouble(row));
        }
    }

    @Override
    public void terminate(PointCollector collector) throws Exception {
        block8: {
            int index;
            ArrayList<double[]> res;
            long[] ts;
            block7: {
                ts = timestamp.stream().mapToLong(Long::valueOf).toArray();
                double[] v = value.stream().mapToDouble(Double::valueOf).toArray();
                List<double[]> seg = new ArrayList<double[]>();
                if (this.method.equals(METHOD_BOTTOM_UP)) {
                    List<double[]> temp = Segment.bottomUp(v, this.maxError);
                    seg.addAll(temp);
                } else if (this.method.equals("swab")) {
                    seg = Segment.swabAlg(v, this.maxError, this.windowSize);
                }
                res = new ArrayList<double[]>();
                for (double[] doubles : seg) {
                    res.add(Segment.approximatedSegment(doubles));
                }
                index = 0;
                if (!this.output.equals(OUTPUT_FIRST)) break block7;
                for (double[] doubles : res) {
                    collector.putDouble(ts[index], doubles[0]);
                    index += doubles.length;
                }
                break block8;
            }
            if (!this.output.equals("all")) break block8;
            Iterator iterator = res.iterator();
            while (iterator.hasNext()) {
                double[] doubles;
                for (double aDouble : doubles = (double[])iterator.next()) {
                    collector.putDouble(ts[index], aDouble);
                    ++index;
                }
            }
        }
    }
}

