/*
 * Decompiled with CFR 0.152.
 */
package org.jtransforms.dst;

import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jtransforms.dst.DoubleDST_1D;
import org.jtransforms.utils.CommonUtils;
import pl.edu.icm.jlargearrays.ConcurrencyUtils;
import pl.edu.icm.jlargearrays.DoubleLargeArray;
import pl.edu.icm.jlargearrays.LargeArray;

public class DoubleDST_3D {
    private int slices;
    private long slicesl;
    private int rows;
    private long rowsl;
    private int columns;
    private long columnsl;
    private int sliceStride;
    private long sliceStridel;
    private int rowStride;
    private long rowStridel;
    private DoubleDST_1D dstSlices;
    private DoubleDST_1D dstRows;
    private DoubleDST_1D dstColumns;
    private boolean isPowerOfTwo = false;
    private boolean useThreads = false;

    public DoubleDST_3D(long slices, long rows, long columns) {
        if (slices <= 1L || rows <= 1L || columns <= 1L) {
            throw new IllegalArgumentException("slices, rows and columns must be greater than 1");
        }
        this.slices = (int)slices;
        this.rows = (int)rows;
        this.columns = (int)columns;
        this.slicesl = slices;
        this.rowsl = rows;
        this.columnsl = columns;
        this.sliceStride = (int)(rows * columns);
        this.rowStride = (int)columns;
        this.sliceStridel = rows * columns;
        this.rowStridel = columns;
        if (slices * rows * columns >= CommonUtils.getThreadsBeginN_3D()) {
            this.useThreads = true;
        }
        if (CommonUtils.isPowerOf2(slices) && CommonUtils.isPowerOf2(rows) && CommonUtils.isPowerOf2(columns)) {
            this.isPowerOfTwo = true;
        }
        CommonUtils.setUseLargeArrays(slices * rows * columns > (long)LargeArray.getMaxSizeOf32bitArray());
        this.dstSlices = new DoubleDST_1D(slices);
        this.dstRows = slices == rows ? this.dstSlices : new DoubleDST_1D(rows);
        this.dstColumns = slices == columns ? this.dstSlices : (rows == columns ? this.dstRows : new DoubleDST_1D(columns));
    }

    public void forward(final double[] a, final boolean scale) {
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (this.isPowerOfTwo) {
            if (nthreads > 1 && this.useThreads) {
                this.ddxt3da_subth(-1, a, scale);
                this.ddxt3db_subth(-1, a, scale);
            } else {
                this.ddxt3da_sub(-1, a, scale);
                this.ddxt3db_sub(-1, a, scale);
            }
        } else if (nthreads > 1 && this.useThreads && this.slices >= nthreads && this.rows >= nthreads && this.columns >= nthreads) {
            int lastSlice;
            int firstSlice;
            Future[] futures = new Future[nthreads];
            int p = this.slices / nthreads;
            for (int l = 0; l < nthreads; ++l) {
                firstSlice = l * p;
                lastSlice = l == nthreads - 1 ? this.slices : firstSlice + p;
                futures[l] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        for (int s2 = firstSlice; s2 < lastSlice; ++s2) {
                            int idx1 = s2 * DoubleDST_3D.this.sliceStride;
                            for (int r = 0; r < DoubleDST_3D.this.rows; ++r) {
                                DoubleDST_3D.this.dstColumns.forward(a, idx1 + r * DoubleDST_3D.this.rowStride, scale);
                            }
                        }
                    }
                });
            }
            try {
                ConcurrencyUtils.waitForCompletion(futures);
            }
            catch (InterruptedException ex) {
                Logger.getLogger(DoubleDST_3D.class.getName()).log(Level.SEVERE, null, ex);
            }
            catch (ExecutionException ex) {
                Logger.getLogger(DoubleDST_3D.class.getName()).log(Level.SEVERE, null, ex);
            }
            for (int l = 0; l < nthreads; ++l) {
                firstSlice = l * p;
                lastSlice = l == nthreads - 1 ? this.slices : firstSlice + p;
                futures[l] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        double[] temp = new double[DoubleDST_3D.this.rows];
                        for (int s2 = firstSlice; s2 < lastSlice; ++s2) {
                            int idx1 = s2 * DoubleDST_3D.this.sliceStride;
                            for (int c = 0; c < DoubleDST_3D.this.columns; ++c) {
                                int idx3;
                                int r;
                                for (r = 0; r < DoubleDST_3D.this.rows; ++r) {
                                    idx3 = idx1 + r * DoubleDST_3D.this.rowStride + c;
                                    temp[r] = a[idx3];
                                }
                                DoubleDST_3D.this.dstRows.forward(temp, scale);
                                for (r = 0; r < DoubleDST_3D.this.rows; ++r) {
                                    idx3 = idx1 + r * DoubleDST_3D.this.rowStride + c;
                                    a[idx3] = temp[r];
                                }
                            }
                        }
                    }
                });
            }
            try {
                ConcurrencyUtils.waitForCompletion(futures);
            }
            catch (InterruptedException ex) {
                Logger.getLogger(DoubleDST_3D.class.getName()).log(Level.SEVERE, null, ex);
            }
            catch (ExecutionException ex) {
                Logger.getLogger(DoubleDST_3D.class.getName()).log(Level.SEVERE, null, ex);
            }
            p = this.rows / nthreads;
            for (int l = 0; l < nthreads; ++l) {
                final int firstRow = l * p;
                final int lastRow = l == nthreads - 1 ? this.rows : firstRow + p;
                futures[l] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        double[] temp = new double[DoubleDST_3D.this.slices];
                        for (int r = firstRow; r < lastRow; ++r) {
                            int idx1 = r * DoubleDST_3D.this.rowStride;
                            for (int c = 0; c < DoubleDST_3D.this.columns; ++c) {
                                int idx3;
                                int s2;
                                for (s2 = 0; s2 < DoubleDST_3D.this.slices; ++s2) {
                                    idx3 = s2 * DoubleDST_3D.this.sliceStride + idx1 + c;
                                    temp[s2] = a[idx3];
                                }
                                DoubleDST_3D.this.dstSlices.forward(temp, scale);
                                for (s2 = 0; s2 < DoubleDST_3D.this.slices; ++s2) {
                                    idx3 = s2 * DoubleDST_3D.this.sliceStride + idx1 + c;
                                    a[idx3] = temp[s2];
                                }
                            }
                        }
                    }
                });
            }
            try {
                ConcurrencyUtils.waitForCompletion(futures);
            }
            catch (InterruptedException ex) {
                Logger.getLogger(DoubleDST_3D.class.getName()).log(Level.SEVERE, null, ex);
            }
            catch (ExecutionException ex) {
                Logger.getLogger(DoubleDST_3D.class.getName()).log(Level.SEVERE, null, ex);
            }
        } else {
            int idx3;
            int c;
            int idx1;
            for (int s2 = 0; s2 < this.slices; ++s2) {
                int idx12 = s2 * this.sliceStride;
                for (int r = 0; r < this.rows; ++r) {
                    this.dstColumns.forward(a, idx12 + r * this.rowStride, scale);
                }
            }
            double[] temp = new double[this.rows];
            for (int s3 = 0; s3 < this.slices; ++s3) {
                idx1 = s3 * this.sliceStride;
                for (c = 0; c < this.columns; ++c) {
                    int r;
                    for (r = 0; r < this.rows; ++r) {
                        idx3 = idx1 + r * this.rowStride + c;
                        temp[r] = a[idx3];
                    }
                    this.dstRows.forward(temp, scale);
                    for (r = 0; r < this.rows; ++r) {
                        idx3 = idx1 + r * this.rowStride + c;
                        a[idx3] = temp[r];
                    }
                }
            }
            temp = new double[this.slices];
            for (int r = 0; r < this.rows; ++r) {
                idx1 = r * this.rowStride;
                for (c = 0; c < this.columns; ++c) {
                    int s4;
                    for (s4 = 0; s4 < this.slices; ++s4) {
                        idx3 = s4 * this.sliceStride + idx1 + c;
                        temp[s4] = a[idx3];
                    }
                    this.dstSlices.forward(temp, scale);
                    for (s4 = 0; s4 < this.slices; ++s4) {
                        idx3 = s4 * this.sliceStride + idx1 + c;
                        a[idx3] = temp[s4];
                    }
                }
            }
        }
    }

    public void forward(final DoubleLargeArray a, final boolean scale) {
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (this.isPowerOfTwo) {
            if (nthreads > 1 && this.useThreads) {
                this.ddxt3da_subth(-1, a, scale);
                this.ddxt3db_subth(-1, a, scale);
            } else {
                this.ddxt3da_sub(-1, a, scale);
                this.ddxt3db_sub(-1, a, scale);
            }
        } else if (nthreads > 1 && this.useThreads && this.slicesl >= (long)nthreads && this.rowsl >= (long)nthreads && this.columnsl >= (long)nthreads) {
            long lastSlice;
            long firstSlice;
            Future[] futures = new Future[nthreads];
            long p = this.slicesl / (long)nthreads;
            for (int l = 0; l < nthreads; ++l) {
                firstSlice = (long)l * p;
                lastSlice = l == nthreads - 1 ? this.slicesl : firstSlice + p;
                futures[l] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        for (long s2 = firstSlice; s2 < lastSlice; ++s2) {
                            long idx1 = s2 * DoubleDST_3D.this.sliceStridel;
                            for (long r = 0L; r < DoubleDST_3D.this.rowsl; ++r) {
                                DoubleDST_3D.this.dstColumns.forward(a, idx1 + r * DoubleDST_3D.this.rowStridel, scale);
                            }
                        }
                    }
                });
            }
            try {
                ConcurrencyUtils.waitForCompletion(futures);
            }
            catch (InterruptedException ex) {
                Logger.getLogger(DoubleDST_3D.class.getName()).log(Level.SEVERE, null, ex);
            }
            catch (ExecutionException ex) {
                Logger.getLogger(DoubleDST_3D.class.getName()).log(Level.SEVERE, null, ex);
            }
            for (int l = 0; l < nthreads; ++l) {
                firstSlice = (long)l * p;
                lastSlice = l == nthreads - 1 ? this.slicesl : firstSlice + p;
                futures[l] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        DoubleLargeArray temp = new DoubleLargeArray(DoubleDST_3D.this.rowsl, false);
                        for (long s2 = firstSlice; s2 < lastSlice; ++s2) {
                            long idx1 = s2 * DoubleDST_3D.this.sliceStridel;
                            for (long c = 0L; c < DoubleDST_3D.this.columnsl; ++c) {
                                long idx3;
                                long r;
                                for (r = 0L; r < DoubleDST_3D.this.rowsl; ++r) {
                                    idx3 = idx1 + r * DoubleDST_3D.this.rowStridel + c;
                                    temp.setDouble(r, a.getDouble(idx3));
                                }
                                DoubleDST_3D.this.dstRows.forward(temp, scale);
                                for (r = 0L; r < DoubleDST_3D.this.rowsl; ++r) {
                                    idx3 = idx1 + r * DoubleDST_3D.this.rowStridel + c;
                                    a.setDouble(idx3, temp.getDouble(r));
                                }
                            }
                        }
                    }
                });
            }
            try {
                ConcurrencyUtils.waitForCompletion(futures);
            }
            catch (InterruptedException ex) {
                Logger.getLogger(DoubleDST_3D.class.getName()).log(Level.SEVERE, null, ex);
            }
            catch (ExecutionException ex) {
                Logger.getLogger(DoubleDST_3D.class.getName()).log(Level.SEVERE, null, ex);
            }
            p = this.rowsl / (long)nthreads;
            for (int l = 0; l < nthreads; ++l) {
                final long firstRow = (long)l * p;
                final long lastRow = l == nthreads - 1 ? this.rowsl : firstRow + p;
                futures[l] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        DoubleLargeArray temp = new DoubleLargeArray(DoubleDST_3D.this.slicesl, false);
                        for (long r = firstRow; r < lastRow; ++r) {
                            long idx1 = r * DoubleDST_3D.this.rowStridel;
                            for (long c = 0L; c < DoubleDST_3D.this.columnsl; ++c) {
                                long idx3;
                                long s2;
                                for (s2 = 0L; s2 < DoubleDST_3D.this.slicesl; ++s2) {
                                    idx3 = s2 * DoubleDST_3D.this.sliceStridel + idx1 + c;
                                    temp.setDouble(s2, a.getDouble(idx3));
                                }
                                DoubleDST_3D.this.dstSlices.forward(temp, scale);
                                for (s2 = 0L; s2 < DoubleDST_3D.this.slicesl; ++s2) {
                                    idx3 = s2 * DoubleDST_3D.this.sliceStridel + idx1 + c;
                                    a.setDouble(idx3, temp.getDouble(s2));
                                }
                            }
                        }
                    }
                });
            }
            try {
                ConcurrencyUtils.waitForCompletion(futures);
            }
            catch (InterruptedException ex) {
                Logger.getLogger(DoubleDST_3D.class.getName()).log(Level.SEVERE, null, ex);
            }
            catch (ExecutionException ex) {
                Logger.getLogger(DoubleDST_3D.class.getName()).log(Level.SEVERE, null, ex);
            }
        } else {
            long idx3;
            long c;
            long idx1;
            for (long s2 = 0L; s2 < this.slicesl; ++s2) {
                long idx12 = s2 * this.sliceStridel;
                for (long r = 0L; r < this.rowsl; ++r) {
                    this.dstColumns.forward(a, idx12 + r * this.rowStridel, scale);
                }
            }
            DoubleLargeArray temp = new DoubleLargeArray(this.rowsl, false);
            for (long s3 = 0L; s3 < this.slicesl; ++s3) {
                idx1 = s3 * this.sliceStridel;
                for (c = 0L; c < this.columnsl; ++c) {
                    long r;
                    for (r = 0L; r < this.rowsl; ++r) {
                        idx3 = idx1 + r * this.rowStridel + c;
                        temp.setDouble(r, a.getDouble(idx3));
                    }
                    this.dstRows.forward(temp, scale);
                    for (r = 0L; r < this.rowsl; ++r) {
                        idx3 = idx1 + r * this.rowStridel + c;
                        a.setDouble(idx3, temp.getDouble(r));
                    }
                }
            }
            temp = new DoubleLargeArray(this.slicesl, false);
            for (long r = 0L; r < this.rowsl; ++r) {
                idx1 = r * this.rowStridel;
                for (c = 0L; c < this.columnsl; ++c) {
                    long s4;
                    for (s4 = 0L; s4 < this.slicesl; ++s4) {
                        idx3 = s4 * this.sliceStridel + idx1 + c;
                        temp.setDouble(s4, a.getDouble(idx3));
                    }
                    this.dstSlices.forward(temp, scale);
                    for (s4 = 0L; s4 < this.slicesl; ++s4) {
                        idx3 = s4 * this.sliceStridel + idx1 + c;
                        a.setDouble(idx3, temp.getDouble(s4));
                    }
                }
            }
        }
    }

    public void forward(final double[][][] a, final boolean scale) {
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (this.isPowerOfTwo) {
            if (nthreads > 1 && this.useThreads) {
                this.ddxt3da_subth(-1, a, scale);
                this.ddxt3db_subth(-1, a, scale);
            } else {
                this.ddxt3da_sub(-1, a, scale);
                this.ddxt3db_sub(-1, a, scale);
            }
        } else if (nthreads > 1 && this.useThreads && this.slices >= nthreads && this.rows >= nthreads && this.columns >= nthreads) {
            int lastSlice;
            int firstSlice;
            Future[] futures = new Future[nthreads];
            int p = this.slices / nthreads;
            for (int l = 0; l < nthreads; ++l) {
                firstSlice = l * p;
                lastSlice = l == nthreads - 1 ? this.slices : firstSlice + p;
                futures[l] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        for (int s2 = firstSlice; s2 < lastSlice; ++s2) {
                            for (int r = 0; r < DoubleDST_3D.this.rows; ++r) {
                                DoubleDST_3D.this.dstColumns.forward(a[s2][r], scale);
                            }
                        }
                    }
                });
            }
            try {
                ConcurrencyUtils.waitForCompletion(futures);
            }
            catch (InterruptedException ex) {
                Logger.getLogger(DoubleDST_3D.class.getName()).log(Level.SEVERE, null, ex);
            }
            catch (ExecutionException ex) {
                Logger.getLogger(DoubleDST_3D.class.getName()).log(Level.SEVERE, null, ex);
            }
            for (int l = 0; l < nthreads; ++l) {
                firstSlice = l * p;
                lastSlice = l == nthreads - 1 ? this.slices : firstSlice + p;
                futures[l] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        double[] temp = new double[DoubleDST_3D.this.rows];
                        for (int s2 = firstSlice; s2 < lastSlice; ++s2) {
                            for (int c = 0; c < DoubleDST_3D.this.columns; ++c) {
                                int r;
                                for (r = 0; r < DoubleDST_3D.this.rows; ++r) {
                                    temp[r] = a[s2][r][c];
                                }
                                DoubleDST_3D.this.dstRows.forward(temp, scale);
                                for (r = 0; r < DoubleDST_3D.this.rows; ++r) {
                                    a[s2][r][c] = temp[r];
                                }
                            }
                        }
                    }
                });
            }
            try {
                ConcurrencyUtils.waitForCompletion(futures);
            }
            catch (InterruptedException ex) {
                Logger.getLogger(DoubleDST_3D.class.getName()).log(Level.SEVERE, null, ex);
            }
            catch (ExecutionException ex) {
                Logger.getLogger(DoubleDST_3D.class.getName()).log(Level.SEVERE, null, ex);
            }
            p = this.rows / nthreads;
            for (int l = 0; l < nthreads; ++l) {
                final int firstRow = l * p;
                final int lastRow = l == nthreads - 1 ? this.rows : firstRow + p;
                futures[l] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        double[] temp = new double[DoubleDST_3D.this.slices];
                        for (int r = firstRow; r < lastRow; ++r) {
                            for (int c = 0; c < DoubleDST_3D.this.columns; ++c) {
                                int s2;
                                for (s2 = 0; s2 < DoubleDST_3D.this.slices; ++s2) {
                                    temp[s2] = a[s2][r][c];
                                }
                                DoubleDST_3D.this.dstSlices.forward(temp, scale);
                                for (s2 = 0; s2 < DoubleDST_3D.this.slices; ++s2) {
                                    a[s2][r][c] = temp[s2];
                                }
                            }
                        }
                    }
                });
            }
            try {
                ConcurrencyUtils.waitForCompletion(futures);
            }
            catch (InterruptedException ex) {
                Logger.getLogger(DoubleDST_3D.class.getName()).log(Level.SEVERE, null, ex);
            }
            catch (ExecutionException ex) {
                Logger.getLogger(DoubleDST_3D.class.getName()).log(Level.SEVERE, null, ex);
            }
        } else {
            int c;
            int r;
            for (int s2 = 0; s2 < this.slices; ++s2) {
                for (r = 0; r < this.rows; ++r) {
                    this.dstColumns.forward(a[s2][r], scale);
                }
            }
            double[] temp = new double[this.rows];
            for (int s3 = 0; s3 < this.slices; ++s3) {
                for (c = 0; c < this.columns; ++c) {
                    int r2;
                    for (r2 = 0; r2 < this.rows; ++r2) {
                        temp[r2] = a[s3][r2][c];
                    }
                    this.dstRows.forward(temp, scale);
                    for (r2 = 0; r2 < this.rows; ++r2) {
                        a[s3][r2][c] = temp[r2];
                    }
                }
            }
            temp = new double[this.slices];
            for (r = 0; r < this.rows; ++r) {
                for (c = 0; c < this.columns; ++c) {
                    int s4;
                    for (s4 = 0; s4 < this.slices; ++s4) {
                        temp[s4] = a[s4][r][c];
                    }
                    this.dstSlices.forward(temp, scale);
                    for (s4 = 0; s4 < this.slices; ++s4) {
                        a[s4][r][c] = temp[s4];
                    }
                }
            }
        }
    }

    public void inverse(final double[] a, final boolean scale) {
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (this.isPowerOfTwo) {
            if (nthreads > 1 && this.useThreads) {
                this.ddxt3da_subth(1, a, scale);
                this.ddxt3db_subth(1, a, scale);
            } else {
                this.ddxt3da_sub(1, a, scale);
                this.ddxt3db_sub(1, a, scale);
            }
        } else if (nthreads > 1 && this.useThreads && this.slices >= nthreads && this.rows >= nthreads && this.columns >= nthreads) {
            int lastSlice;
            int firstSlice;
            Future[] futures = new Future[nthreads];
            int p = this.slices / nthreads;
            for (int l = 0; l < nthreads; ++l) {
                firstSlice = l * p;
                lastSlice = l == nthreads - 1 ? this.slices : firstSlice + p;
                futures[l] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        for (int s2 = firstSlice; s2 < lastSlice; ++s2) {
                            int idx1 = s2 * DoubleDST_3D.this.sliceStride;
                            for (int r = 0; r < DoubleDST_3D.this.rows; ++r) {
                                DoubleDST_3D.this.dstColumns.inverse(a, idx1 + r * DoubleDST_3D.this.rowStride, scale);
                            }
                        }
                    }
                });
            }
            try {
                ConcurrencyUtils.waitForCompletion(futures);
            }
            catch (InterruptedException ex) {
                Logger.getLogger(DoubleDST_3D.class.getName()).log(Level.SEVERE, null, ex);
            }
            catch (ExecutionException ex) {
                Logger.getLogger(DoubleDST_3D.class.getName()).log(Level.SEVERE, null, ex);
            }
            for (int l = 0; l < nthreads; ++l) {
                firstSlice = l * p;
                lastSlice = l == nthreads - 1 ? this.slices : firstSlice + p;
                futures[l] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        double[] temp = new double[DoubleDST_3D.this.rows];
                        for (int s2 = firstSlice; s2 < lastSlice; ++s2) {
                            int idx1 = s2 * DoubleDST_3D.this.sliceStride;
                            for (int c = 0; c < DoubleDST_3D.this.columns; ++c) {
                                int idx3;
                                int r;
                                for (r = 0; r < DoubleDST_3D.this.rows; ++r) {
                                    idx3 = idx1 + r * DoubleDST_3D.this.rowStride + c;
                                    temp[r] = a[idx3];
                                }
                                DoubleDST_3D.this.dstRows.inverse(temp, scale);
                                for (r = 0; r < DoubleDST_3D.this.rows; ++r) {
                                    idx3 = idx1 + r * DoubleDST_3D.this.rowStride + c;
                                    a[idx3] = temp[r];
                                }
                            }
                        }
                    }
                });
            }
            try {
                ConcurrencyUtils.waitForCompletion(futures);
            }
            catch (InterruptedException ex) {
                Logger.getLogger(DoubleDST_3D.class.getName()).log(Level.SEVERE, null, ex);
            }
            catch (ExecutionException ex) {
                Logger.getLogger(DoubleDST_3D.class.getName()).log(Level.SEVERE, null, ex);
            }
            p = this.rows / nthreads;
            for (int l = 0; l < nthreads; ++l) {
                final int firstRow = l * p;
                final int lastRow = l == nthreads - 1 ? this.rows : firstRow + p;
                futures[l] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        double[] temp = new double[DoubleDST_3D.this.slices];
                        for (int r = firstRow; r < lastRow; ++r) {
                            int idx1 = r * DoubleDST_3D.this.rowStride;
                            for (int c = 0; c < DoubleDST_3D.this.columns; ++c) {
                                int idx3;
                                int s2;
                                for (s2 = 0; s2 < DoubleDST_3D.this.slices; ++s2) {
                                    idx3 = s2 * DoubleDST_3D.this.sliceStride + idx1 + c;
                                    temp[s2] = a[idx3];
                                }
                                DoubleDST_3D.this.dstSlices.inverse(temp, scale);
                                for (s2 = 0; s2 < DoubleDST_3D.this.slices; ++s2) {
                                    idx3 = s2 * DoubleDST_3D.this.sliceStride + idx1 + c;
                                    a[idx3] = temp[s2];
                                }
                            }
                        }
                    }
                });
            }
            try {
                ConcurrencyUtils.waitForCompletion(futures);
            }
            catch (InterruptedException ex) {
                Logger.getLogger(DoubleDST_3D.class.getName()).log(Level.SEVERE, null, ex);
            }
            catch (ExecutionException ex) {
                Logger.getLogger(DoubleDST_3D.class.getName()).log(Level.SEVERE, null, ex);
            }
        } else {
            int idx3;
            int c;
            int idx1;
            for (int s2 = 0; s2 < this.slices; ++s2) {
                int idx12 = s2 * this.sliceStride;
                for (int r = 0; r < this.rows; ++r) {
                    this.dstColumns.inverse(a, idx12 + r * this.rowStride, scale);
                }
            }
            double[] temp = new double[this.rows];
            for (int s3 = 0; s3 < this.slices; ++s3) {
                idx1 = s3 * this.sliceStride;
                for (c = 0; c < this.columns; ++c) {
                    int r;
                    for (r = 0; r < this.rows; ++r) {
                        idx3 = idx1 + r * this.rowStride + c;
                        temp[r] = a[idx3];
                    }
                    this.dstRows.inverse(temp, scale);
                    for (r = 0; r < this.rows; ++r) {
                        idx3 = idx1 + r * this.rowStride + c;
                        a[idx3] = temp[r];
                    }
                }
            }
            temp = new double[this.slices];
            for (int r = 0; r < this.rows; ++r) {
                idx1 = r * this.rowStride;
                for (c = 0; c < this.columns; ++c) {
                    int s4;
                    for (s4 = 0; s4 < this.slices; ++s4) {
                        idx3 = s4 * this.sliceStride + idx1 + c;
                        temp[s4] = a[idx3];
                    }
                    this.dstSlices.inverse(temp, scale);
                    for (s4 = 0; s4 < this.slices; ++s4) {
                        idx3 = s4 * this.sliceStride + idx1 + c;
                        a[idx3] = temp[s4];
                    }
                }
            }
        }
    }

    public void inverse(final DoubleLargeArray a, final boolean scale) {
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (this.isPowerOfTwo) {
            if (nthreads > 1 && this.useThreads) {
                this.ddxt3da_subth(1, a, scale);
                this.ddxt3db_subth(1, a, scale);
            } else {
                this.ddxt3da_sub(1, a, scale);
                this.ddxt3db_sub(1, a, scale);
            }
        } else if (nthreads > 1 && this.useThreads && this.slicesl >= (long)nthreads && this.rowsl >= (long)nthreads && this.columnsl >= (long)nthreads) {
            long lastSlice;
            long firstSlice;
            Future[] futures = new Future[nthreads];
            long p = this.slicesl / (long)nthreads;
            for (int l = 0; l < nthreads; ++l) {
                firstSlice = (long)l * p;
                lastSlice = l == nthreads - 1 ? this.slicesl : firstSlice + p;
                futures[l] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        for (long s2 = firstSlice; s2 < lastSlice; ++s2) {
                            long idx1 = s2 * (long)DoubleDST_3D.this.sliceStride;
                            for (long r = 0L; r < DoubleDST_3D.this.rowsl; ++r) {
                                DoubleDST_3D.this.dstColumns.inverse(a, idx1 + r * (long)DoubleDST_3D.this.rowStride, scale);
                            }
                        }
                    }
                });
            }
            try {
                ConcurrencyUtils.waitForCompletion(futures);
            }
            catch (InterruptedException ex) {
                Logger.getLogger(DoubleDST_3D.class.getName()).log(Level.SEVERE, null, ex);
            }
            catch (ExecutionException ex) {
                Logger.getLogger(DoubleDST_3D.class.getName()).log(Level.SEVERE, null, ex);
            }
            for (int l = 0; l < nthreads; ++l) {
                firstSlice = (long)l * p;
                lastSlice = l == nthreads - 1 ? this.slicesl : firstSlice + p;
                futures[l] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        DoubleLargeArray temp = new DoubleLargeArray(DoubleDST_3D.this.rowsl, false);
                        for (long s2 = firstSlice; s2 < lastSlice; ++s2) {
                            long idx1 = s2 * (long)DoubleDST_3D.this.sliceStride;
                            for (long c = 0L; c < DoubleDST_3D.this.columnsl; ++c) {
                                long idx3;
                                long r;
                                for (r = 0L; r < DoubleDST_3D.this.rowsl; ++r) {
                                    idx3 = idx1 + r * (long)DoubleDST_3D.this.rowStride + c;
                                    temp.setDouble(r, a.getDouble(idx3));
                                }
                                DoubleDST_3D.this.dstRows.inverse(temp, scale);
                                for (r = 0L; r < DoubleDST_3D.this.rowsl; ++r) {
                                    idx3 = idx1 + r * (long)DoubleDST_3D.this.rowStride + c;
                                    a.setDouble(idx3, temp.getDouble(r));
                                }
                            }
                        }
                    }
                });
            }
            try {
                ConcurrencyUtils.waitForCompletion(futures);
            }
            catch (InterruptedException ex) {
                Logger.getLogger(DoubleDST_3D.class.getName()).log(Level.SEVERE, null, ex);
            }
            catch (ExecutionException ex) {
                Logger.getLogger(DoubleDST_3D.class.getName()).log(Level.SEVERE, null, ex);
            }
            p = this.rowsl / (long)nthreads;
            for (int l = 0; l < nthreads; ++l) {
                final long firstRow = (long)l * p;
                final long lastRow = l == nthreads - 1 ? this.rowsl : firstRow + p;
                futures[l] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        DoubleLargeArray temp = new DoubleLargeArray(DoubleDST_3D.this.slicesl, false);
                        for (long r = firstRow; r < lastRow; ++r) {
                            long idx1 = r * (long)DoubleDST_3D.this.rowStride;
                            for (long c = 0L; c < DoubleDST_3D.this.columnsl; ++c) {
                                long idx3;
                                long s2;
                                for (s2 = 0L; s2 < DoubleDST_3D.this.slicesl; ++s2) {
                                    idx3 = s2 * (long)DoubleDST_3D.this.sliceStride + idx1 + c;
                                    temp.setDouble(s2, a.getDouble(idx3));
                                }
                                DoubleDST_3D.this.dstSlices.inverse(temp, scale);
                                for (s2 = 0L; s2 < DoubleDST_3D.this.slicesl; ++s2) {
                                    idx3 = s2 * (long)DoubleDST_3D.this.sliceStride + idx1 + c;
                                    a.setDouble(idx3, temp.getDouble(s2));
                                }
                            }
                        }
                    }
                });
            }
            try {
                ConcurrencyUtils.waitForCompletion(futures);
            }
            catch (InterruptedException ex) {
                Logger.getLogger(DoubleDST_3D.class.getName()).log(Level.SEVERE, null, ex);
            }
            catch (ExecutionException ex) {
                Logger.getLogger(DoubleDST_3D.class.getName()).log(Level.SEVERE, null, ex);
            }
        } else {
            long idx3;
            long c;
            long idx1;
            for (long s2 = 0L; s2 < this.slicesl; ++s2) {
                long idx12 = s2 * (long)this.sliceStride;
                for (long r = 0L; r < this.rowsl; ++r) {
                    this.dstColumns.inverse(a, idx12 + r * (long)this.rowStride, scale);
                }
            }
            DoubleLargeArray temp = new DoubleLargeArray(this.rowsl, false);
            for (long s3 = 0L; s3 < this.slicesl; ++s3) {
                idx1 = s3 * (long)this.sliceStride;
                for (c = 0L; c < this.columnsl; ++c) {
                    long r;
                    for (r = 0L; r < this.rowsl; ++r) {
                        idx3 = idx1 + r * (long)this.rowStride + c;
                        temp.setDouble(r, a.getDouble(idx3));
                    }
                    this.dstRows.inverse(temp, scale);
                    for (r = 0L; r < this.rowsl; ++r) {
                        idx3 = idx1 + r * (long)this.rowStride + c;
                        a.setDouble(idx3, temp.getDouble(r));
                    }
                }
            }
            temp = new DoubleLargeArray(this.slicesl, false);
            for (long r = 0L; r < this.rowsl; ++r) {
                idx1 = r * (long)this.rowStride;
                for (c = 0L; c < this.columnsl; ++c) {
                    long s4;
                    for (s4 = 0L; s4 < this.slicesl; ++s4) {
                        idx3 = s4 * (long)this.sliceStride + idx1 + c;
                        temp.setDouble(s4, a.getDouble(idx3));
                    }
                    this.dstSlices.inverse(temp, scale);
                    for (s4 = 0L; s4 < this.slicesl; ++s4) {
                        idx3 = s4 * (long)this.sliceStride + idx1 + c;
                        a.setDouble(idx3, temp.getDouble(s4));
                    }
                }
            }
        }
    }

    public void inverse(final double[][][] a, final boolean scale) {
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (this.isPowerOfTwo) {
            if (nthreads > 1 && this.useThreads) {
                this.ddxt3da_subth(1, a, scale);
                this.ddxt3db_subth(1, a, scale);
            } else {
                this.ddxt3da_sub(1, a, scale);
                this.ddxt3db_sub(1, a, scale);
            }
        } else if (nthreads > 1 && this.useThreads && this.slices >= nthreads && this.rows >= nthreads && this.columns >= nthreads) {
            int lastSlice;
            int firstSlice;
            Future[] futures = new Future[nthreads];
            int p = this.slices / nthreads;
            for (int l = 0; l < nthreads; ++l) {
                firstSlice = l * p;
                lastSlice = l == nthreads - 1 ? this.slices : firstSlice + p;
                futures[l] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        for (int s2 = firstSlice; s2 < lastSlice; ++s2) {
                            for (int r = 0; r < DoubleDST_3D.this.rows; ++r) {
                                DoubleDST_3D.this.dstColumns.inverse(a[s2][r], scale);
                            }
                        }
                    }
                });
            }
            try {
                ConcurrencyUtils.waitForCompletion(futures);
            }
            catch (InterruptedException ex) {
                Logger.getLogger(DoubleDST_3D.class.getName()).log(Level.SEVERE, null, ex);
            }
            catch (ExecutionException ex) {
                Logger.getLogger(DoubleDST_3D.class.getName()).log(Level.SEVERE, null, ex);
            }
            for (int l = 0; l < nthreads; ++l) {
                firstSlice = l * p;
                lastSlice = l == nthreads - 1 ? this.slices : firstSlice + p;
                futures[l] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        double[] temp = new double[DoubleDST_3D.this.rows];
                        for (int s2 = firstSlice; s2 < lastSlice; ++s2) {
                            for (int c = 0; c < DoubleDST_3D.this.columns; ++c) {
                                int r;
                                for (r = 0; r < DoubleDST_3D.this.rows; ++r) {
                                    temp[r] = a[s2][r][c];
                                }
                                DoubleDST_3D.this.dstRows.inverse(temp, scale);
                                for (r = 0; r < DoubleDST_3D.this.rows; ++r) {
                                    a[s2][r][c] = temp[r];
                                }
                            }
                        }
                    }
                });
            }
            try {
                ConcurrencyUtils.waitForCompletion(futures);
            }
            catch (InterruptedException ex) {
                Logger.getLogger(DoubleDST_3D.class.getName()).log(Level.SEVERE, null, ex);
            }
            catch (ExecutionException ex) {
                Logger.getLogger(DoubleDST_3D.class.getName()).log(Level.SEVERE, null, ex);
            }
            p = this.rows / nthreads;
            for (int l = 0; l < nthreads; ++l) {
                final int firstRow = l * p;
                final int lastRow = l == nthreads - 1 ? this.rows : firstRow + p;
                futures[l] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        double[] temp = new double[DoubleDST_3D.this.slices];
                        for (int r = firstRow; r < lastRow; ++r) {
                            for (int c = 0; c < DoubleDST_3D.this.columns; ++c) {
                                int s2;
                                for (s2 = 0; s2 < DoubleDST_3D.this.slices; ++s2) {
                                    temp[s2] = a[s2][r][c];
                                }
                                DoubleDST_3D.this.dstSlices.inverse(temp, scale);
                                for (s2 = 0; s2 < DoubleDST_3D.this.slices; ++s2) {
                                    a[s2][r][c] = temp[s2];
                                }
                            }
                        }
                    }
                });
            }
            try {
                ConcurrencyUtils.waitForCompletion(futures);
            }
            catch (InterruptedException ex) {
                Logger.getLogger(DoubleDST_3D.class.getName()).log(Level.SEVERE, null, ex);
            }
            catch (ExecutionException ex) {
                Logger.getLogger(DoubleDST_3D.class.getName()).log(Level.SEVERE, null, ex);
            }
        } else {
            int c;
            int r;
            for (int s2 = 0; s2 < this.slices; ++s2) {
                for (r = 0; r < this.rows; ++r) {
                    this.dstColumns.inverse(a[s2][r], scale);
                }
            }
            double[] temp = new double[this.rows];
            for (int s3 = 0; s3 < this.slices; ++s3) {
                for (c = 0; c < this.columns; ++c) {
                    int r2;
                    for (r2 = 0; r2 < this.rows; ++r2) {
                        temp[r2] = a[s3][r2][c];
                    }
                    this.dstRows.inverse(temp, scale);
                    for (r2 = 0; r2 < this.rows; ++r2) {
                        a[s3][r2][c] = temp[r2];
                    }
                }
            }
            temp = new double[this.slices];
            for (r = 0; r < this.rows; ++r) {
                for (c = 0; c < this.columns; ++c) {
                    int s4;
                    for (s4 = 0; s4 < this.slices; ++s4) {
                        temp[s4] = a[s4][r][c];
                    }
                    this.dstSlices.inverse(temp, scale);
                    for (s4 = 0; s4 < this.slices; ++s4) {
                        a[s4][r][c] = temp[s4];
                    }
                }
            }
        }
    }

    private void ddxt3da_sub(int isgn, double[] a, boolean scale) {
        int nt = 4 * this.rows;
        if (this.columns == 2) {
            nt >>= 1;
        }
        double[] t2 = new double[nt];
        if (isgn == -1) {
            for (int s2 = 0; s2 < this.slices; ++s2) {
                int idx1;
                int r;
                int idx0 = s2 * this.sliceStride;
                for (r = 0; r < this.rows; ++r) {
                    this.dstColumns.forward(a, idx0 + r * this.rowStride, scale);
                }
                if (this.columns > 2) {
                    for (int c = 0; c < this.columns; c += 4) {
                        int idx2;
                        int r2;
                        for (r2 = 0; r2 < this.rows; ++r2) {
                            idx1 = idx0 + r2 * this.rowStride + c;
                            idx2 = this.rows + r2;
                            t2[r2] = a[idx1];
                            t2[idx2] = a[idx1 + 1];
                            t2[idx2 + this.rows] = a[idx1 + 2];
                            t2[idx2 + 2 * this.rows] = a[idx1 + 3];
                        }
                        this.dstRows.forward(t2, 0, scale);
                        this.dstRows.forward(t2, this.rows, scale);
                        this.dstRows.forward(t2, 2 * this.rows, scale);
                        this.dstRows.forward(t2, 3 * this.rows, scale);
                        for (r2 = 0; r2 < this.rows; ++r2) {
                            idx1 = idx0 + r2 * this.rowStride + c;
                            idx2 = this.rows + r2;
                            a[idx1] = t2[r2];
                            a[idx1 + 1] = t2[idx2];
                            a[idx1 + 2] = t2[idx2 + this.rows];
                            a[idx1 + 3] = t2[idx2 + 2 * this.rows];
                        }
                    }
                    continue;
                }
                if (this.columns != 2) continue;
                for (r = 0; r < this.rows; ++r) {
                    idx1 = idx0 + r * this.rowStride;
                    t2[r] = a[idx1];
                    t2[this.rows + r] = a[idx1 + 1];
                }
                this.dstRows.forward(t2, 0, scale);
                this.dstRows.forward(t2, this.rows, scale);
                for (r = 0; r < this.rows; ++r) {
                    idx1 = idx0 + r * this.rowStride;
                    a[idx1] = t2[r];
                    a[idx1 + 1] = t2[this.rows + r];
                }
            }
        } else {
            for (int s3 = 0; s3 < this.slices; ++s3) {
                int idx1;
                int r;
                int idx0 = s3 * this.sliceStride;
                for (r = 0; r < this.rows; ++r) {
                    this.dstColumns.inverse(a, idx0 + r * this.rowStride, scale);
                }
                if (this.columns > 2) {
                    for (int c = 0; c < this.columns; c += 4) {
                        int idx2;
                        int r3;
                        for (r3 = 0; r3 < this.rows; ++r3) {
                            idx1 = idx0 + r3 * this.rowStride + c;
                            idx2 = this.rows + r3;
                            t2[r3] = a[idx1];
                            t2[idx2] = a[idx1 + 1];
                            t2[idx2 + this.rows] = a[idx1 + 2];
                            t2[idx2 + 2 * this.rows] = a[idx1 + 3];
                        }
                        this.dstRows.inverse(t2, 0, scale);
                        this.dstRows.inverse(t2, this.rows, scale);
                        this.dstRows.inverse(t2, 2 * this.rows, scale);
                        this.dstRows.inverse(t2, 3 * this.rows, scale);
                        for (r3 = 0; r3 < this.rows; ++r3) {
                            idx1 = idx0 + r3 * this.rowStride + c;
                            idx2 = this.rows + r3;
                            a[idx1] = t2[r3];
                            a[idx1 + 1] = t2[idx2];
                            a[idx1 + 2] = t2[idx2 + this.rows];
                            a[idx1 + 3] = t2[idx2 + 2 * this.rows];
                        }
                    }
                    continue;
                }
                if (this.columns != 2) continue;
                for (r = 0; r < this.rows; ++r) {
                    idx1 = idx0 + r * this.rowStride;
                    t2[r] = a[idx1];
                    t2[this.rows + r] = a[idx1 + 1];
                }
                this.dstRows.inverse(t2, 0, scale);
                this.dstRows.inverse(t2, this.rows, scale);
                for (r = 0; r < this.rows; ++r) {
                    idx1 = idx0 + r * this.rowStride;
                    a[idx1] = t2[r];
                    a[idx1 + 1] = t2[this.rows + r];
                }
            }
        }
    }

    private void ddxt3da_sub(int isgn, DoubleLargeArray a, boolean scale) {
        long nt = 4L * this.rowsl;
        if (this.columnsl == 2L) {
            nt >>= 1;
        }
        DoubleLargeArray t2 = new DoubleLargeArray(nt);
        if (isgn == -1) {
            for (long s2 = 0L; s2 < this.slicesl; ++s2) {
                long idx1;
                long r;
                long idx0 = s2 * this.sliceStridel;
                for (r = 0L; r < this.rowsl; ++r) {
                    this.dstColumns.forward(a, idx0 + r * (long)this.rowStride, scale);
                }
                if (this.columnsl > 2L) {
                    for (long c = 0L; c < this.columnsl; c += 4L) {
                        long idx2;
                        long r2;
                        for (r2 = 0L; r2 < this.rowsl; ++r2) {
                            idx1 = idx0 + r2 * this.rowStridel + c;
                            idx2 = this.rowsl + r2;
                            t2.setDouble(r2, a.getDouble(idx1));
                            t2.setDouble(idx2, a.getDouble(idx1 + 1L));
                            t2.setDouble(idx2 + this.rowsl, a.getDouble(idx1 + 2L));
                            t2.setDouble(idx2 + 2L * this.rowsl, a.getDouble(idx1 + 3L));
                        }
                        this.dstRows.forward(t2, 0L, scale);
                        this.dstRows.forward(t2, this.rowsl, scale);
                        this.dstRows.forward(t2, 2L * this.rowsl, scale);
                        this.dstRows.forward(t2, 3L * this.rowsl, scale);
                        for (r2 = 0L; r2 < this.rowsl; ++r2) {
                            idx1 = idx0 + r2 * this.rowStridel + c;
                            idx2 = this.rowsl + r2;
                            a.setDouble(idx1, t2.getDouble(r2));
                            a.setDouble(idx1 + 1L, t2.getDouble(idx2));
                            a.setDouble(idx1 + 2L, t2.getDouble(idx2 + this.rowsl));
                            a.setDouble(idx1 + 3L, t2.getDouble(idx2 + 2L * this.rowsl));
                        }
                    }
                    continue;
                }
                if (this.columnsl != 2L) continue;
                for (r = 0L; r < this.rowsl; ++r) {
                    idx1 = idx0 + r * this.rowStridel;
                    t2.setDouble(r, a.getDouble(idx1));
                    t2.setDouble(this.rowsl + r, a.getDouble(idx1 + 1L));
                }
                this.dstRows.forward(t2, 0L, scale);
                this.dstRows.forward(t2, this.rowsl, scale);
                for (r = 0L; r < this.rowsl; ++r) {
                    idx1 = idx0 + r * this.rowStridel;
                    a.setDouble(idx1, t2.getDouble(r));
                    a.setDouble(idx1 + 1L, t2.getDouble(this.rowsl + r));
                }
            }
        } else {
            for (long s3 = 0L; s3 < this.slicesl; ++s3) {
                long idx1;
                long r;
                long idx0 = s3 * this.sliceStridel;
                for (r = 0L; r < this.rowsl; ++r) {
                    this.dstColumns.inverse(a, idx0 + r * this.rowStridel, scale);
                }
                if (this.columnsl > 2L) {
                    for (long c = 0L; c < this.columnsl; c += 4L) {
                        long idx2;
                        long r3;
                        for (r3 = 0L; r3 < this.rowsl; ++r3) {
                            idx1 = idx0 + r3 * this.rowStridel + c;
                            idx2 = this.rowsl + r3;
                            t2.setDouble(r3, a.getDouble(idx1));
                            t2.setDouble(idx2, a.getDouble(idx1 + 1L));
                            t2.setDouble(idx2 + this.rowsl, a.getDouble(idx1 + 2L));
                            t2.setDouble(idx2 + 2L * this.rowsl, a.getDouble(idx1 + 3L));
                        }
                        this.dstRows.inverse(t2, 0L, scale);
                        this.dstRows.inverse(t2, this.rowsl, scale);
                        this.dstRows.inverse(t2, 2L * this.rowsl, scale);
                        this.dstRows.inverse(t2, 3L * this.rowsl, scale);
                        for (r3 = 0L; r3 < this.rowsl; ++r3) {
                            idx1 = idx0 + r3 * this.rowStridel + c;
                            idx2 = this.rowsl + r3;
                            a.setDouble(idx1, t2.getDouble(r3));
                            a.setDouble(idx1 + 1L, t2.getDouble(idx2));
                            a.setDouble(idx1 + 2L, t2.getDouble(idx2 + this.rowsl));
                            a.setDouble(idx1 + 3L, t2.getDouble(idx2 + 2L * this.rowsl));
                        }
                    }
                    continue;
                }
                if (this.columnsl != 2L) continue;
                for (r = 0L; r < this.rowsl; ++r) {
                    idx1 = idx0 + r * this.rowStridel;
                    t2.setDouble(r, a.getDouble(idx1));
                    t2.setDouble(this.rowsl + r, a.getDouble(idx1 + 1L));
                }
                this.dstRows.inverse(t2, 0L, scale);
                this.dstRows.inverse(t2, this.rowsl, scale);
                for (r = 0L; r < this.rowsl; ++r) {
                    idx1 = idx0 + r * this.rowStridel;
                    a.setDouble(idx1, t2.getDouble(r));
                    a.setDouble(idx1 + 1L, t2.getDouble(this.rowsl + r));
                }
            }
        }
    }

    private void ddxt3da_sub(int isgn, double[][][] a, boolean scale) {
        int nt = 4 * this.rows;
        if (this.columns == 2) {
            nt >>= 1;
        }
        double[] t2 = new double[nt];
        if (isgn == -1) {
            for (int s2 = 0; s2 < this.slices; ++s2) {
                int r;
                for (r = 0; r < this.rows; ++r) {
                    this.dstColumns.forward(a[s2][r], scale);
                }
                if (this.columns > 2) {
                    for (int c = 0; c < this.columns; c += 4) {
                        int idx2;
                        int r2;
                        for (r2 = 0; r2 < this.rows; ++r2) {
                            idx2 = this.rows + r2;
                            t2[r2] = a[s2][r2][c];
                            t2[idx2] = a[s2][r2][c + 1];
                            t2[idx2 + this.rows] = a[s2][r2][c + 2];
                            t2[idx2 + 2 * this.rows] = a[s2][r2][c + 3];
                        }
                        this.dstRows.forward(t2, 0, scale);
                        this.dstRows.forward(t2, this.rows, scale);
                        this.dstRows.forward(t2, 2 * this.rows, scale);
                        this.dstRows.forward(t2, 3 * this.rows, scale);
                        for (r2 = 0; r2 < this.rows; ++r2) {
                            idx2 = this.rows + r2;
                            a[s2][r2][c] = t2[r2];
                            a[s2][r2][c + 1] = t2[idx2];
                            a[s2][r2][c + 2] = t2[idx2 + this.rows];
                            a[s2][r2][c + 3] = t2[idx2 + 2 * this.rows];
                        }
                    }
                    continue;
                }
                if (this.columns != 2) continue;
                for (r = 0; r < this.rows; ++r) {
                    t2[r] = a[s2][r][0];
                    t2[this.rows + r] = a[s2][r][1];
                }
                this.dstRows.forward(t2, 0, scale);
                this.dstRows.forward(t2, this.rows, scale);
                for (r = 0; r < this.rows; ++r) {
                    a[s2][r][0] = t2[r];
                    a[s2][r][1] = t2[this.rows + r];
                }
            }
        } else {
            for (int s3 = 0; s3 < this.slices; ++s3) {
                int r;
                for (r = 0; r < this.rows; ++r) {
                    this.dstColumns.inverse(a[s3][r], scale);
                }
                if (this.columns > 2) {
                    for (int c = 0; c < this.columns; c += 4) {
                        int idx2;
                        int r3;
                        for (r3 = 0; r3 < this.rows; ++r3) {
                            idx2 = this.rows + r3;
                            t2[r3] = a[s3][r3][c];
                            t2[idx2] = a[s3][r3][c + 1];
                            t2[idx2 + this.rows] = a[s3][r3][c + 2];
                            t2[idx2 + 2 * this.rows] = a[s3][r3][c + 3];
                        }
                        this.dstRows.inverse(t2, 0, scale);
                        this.dstRows.inverse(t2, this.rows, scale);
                        this.dstRows.inverse(t2, 2 * this.rows, scale);
                        this.dstRows.inverse(t2, 3 * this.rows, scale);
                        for (r3 = 0; r3 < this.rows; ++r3) {
                            idx2 = this.rows + r3;
                            a[s3][r3][c] = t2[r3];
                            a[s3][r3][c + 1] = t2[idx2];
                            a[s3][r3][c + 2] = t2[idx2 + this.rows];
                            a[s3][r3][c + 3] = t2[idx2 + 2 * this.rows];
                        }
                    }
                    continue;
                }
                if (this.columns != 2) continue;
                for (r = 0; r < this.rows; ++r) {
                    t2[r] = a[s3][r][0];
                    t2[this.rows + r] = a[s3][r][1];
                }
                this.dstRows.inverse(t2, 0, scale);
                this.dstRows.inverse(t2, this.rows, scale);
                for (r = 0; r < this.rows; ++r) {
                    a[s3][r][0] = t2[r];
                    a[s3][r][1] = t2[this.rows + r];
                }
            }
        }
    }

    private void ddxt3db_sub(int isgn, double[] a, boolean scale) {
        block20: {
            double[] t2;
            block18: {
                block19: {
                    int nt = 4 * this.slices;
                    if (this.columns == 2) {
                        nt >>= 1;
                    }
                    t2 = new double[nt];
                    if (isgn != -1) break block18;
                    if (this.columns <= 2) break block19;
                    for (int r = 0; r < this.rows; ++r) {
                        int idx0 = r * this.rowStride;
                        for (int c = 0; c < this.columns; c += 4) {
                            int idx2;
                            int idx1;
                            int s2;
                            for (s2 = 0; s2 < this.slices; ++s2) {
                                idx1 = s2 * this.sliceStride + idx0 + c;
                                idx2 = this.slices + s2;
                                t2[s2] = a[idx1];
                                t2[idx2] = a[idx1 + 1];
                                t2[idx2 + this.slices] = a[idx1 + 2];
                                t2[idx2 + 2 * this.slices] = a[idx1 + 3];
                            }
                            this.dstSlices.forward(t2, 0, scale);
                            this.dstSlices.forward(t2, this.slices, scale);
                            this.dstSlices.forward(t2, 2 * this.slices, scale);
                            this.dstSlices.forward(t2, 3 * this.slices, scale);
                            for (s2 = 0; s2 < this.slices; ++s2) {
                                idx1 = s2 * this.sliceStride + idx0 + c;
                                idx2 = this.slices + s2;
                                a[idx1] = t2[s2];
                                a[idx1 + 1] = t2[idx2];
                                a[idx1 + 2] = t2[idx2 + this.slices];
                                a[idx1 + 3] = t2[idx2 + 2 * this.slices];
                            }
                        }
                    }
                    break block20;
                }
                if (this.columns != 2) break block20;
                for (int r = 0; r < this.rows; ++r) {
                    int idx1;
                    int s3;
                    int idx0 = r * this.rowStride;
                    for (s3 = 0; s3 < this.slices; ++s3) {
                        idx1 = s3 * this.sliceStride + idx0;
                        t2[s3] = a[idx1];
                        t2[this.slices + s3] = a[idx1 + 1];
                    }
                    this.dstSlices.forward(t2, 0, scale);
                    this.dstSlices.forward(t2, this.slices, scale);
                    for (s3 = 0; s3 < this.slices; ++s3) {
                        idx1 = s3 * this.sliceStride + idx0;
                        a[idx1] = t2[s3];
                        a[idx1 + 1] = t2[this.slices + s3];
                    }
                }
                break block20;
            }
            if (this.columns > 2) {
                for (int r = 0; r < this.rows; ++r) {
                    int idx0 = r * this.rowStride;
                    for (int c = 0; c < this.columns; c += 4) {
                        int idx2;
                        int idx1;
                        int s4;
                        for (s4 = 0; s4 < this.slices; ++s4) {
                            idx1 = s4 * this.sliceStride + idx0 + c;
                            idx2 = this.slices + s4;
                            t2[s4] = a[idx1];
                            t2[idx2] = a[idx1 + 1];
                            t2[idx2 + this.slices] = a[idx1 + 2];
                            t2[idx2 + 2 * this.slices] = a[idx1 + 3];
                        }
                        this.dstSlices.inverse(t2, 0, scale);
                        this.dstSlices.inverse(t2, this.slices, scale);
                        this.dstSlices.inverse(t2, 2 * this.slices, scale);
                        this.dstSlices.inverse(t2, 3 * this.slices, scale);
                        for (s4 = 0; s4 < this.slices; ++s4) {
                            idx1 = s4 * this.sliceStride + idx0 + c;
                            idx2 = this.slices + s4;
                            a[idx1] = t2[s4];
                            a[idx1 + 1] = t2[idx2];
                            a[idx1 + 2] = t2[idx2 + this.slices];
                            a[idx1 + 3] = t2[idx2 + 2 * this.slices];
                        }
                    }
                }
            } else if (this.columns == 2) {
                for (int r = 0; r < this.rows; ++r) {
                    int idx1;
                    int s5;
                    int idx0 = r * this.rowStride;
                    for (s5 = 0; s5 < this.slices; ++s5) {
                        idx1 = s5 * this.sliceStride + idx0;
                        t2[s5] = a[idx1];
                        t2[this.slices + s5] = a[idx1 + 1];
                    }
                    this.dstSlices.inverse(t2, 0, scale);
                    this.dstSlices.inverse(t2, this.slices, scale);
                    for (s5 = 0; s5 < this.slices; ++s5) {
                        idx1 = s5 * this.sliceStride + idx0;
                        a[idx1] = t2[s5];
                        a[idx1 + 1] = t2[this.slices + s5];
                    }
                }
            }
        }
    }

    private void ddxt3db_sub(int isgn, DoubleLargeArray a, boolean scale) {
        block20: {
            DoubleLargeArray t2;
            block18: {
                block19: {
                    long nt = 4L * this.slicesl;
                    if (this.columnsl == 2L) {
                        nt >>= 1;
                    }
                    t2 = new DoubleLargeArray(nt);
                    if (isgn != -1) break block18;
                    if (this.columnsl <= 2L) break block19;
                    for (long r = 0L; r < this.rowsl; ++r) {
                        long idx0 = r * this.rowStridel;
                        for (long c = 0L; c < this.columnsl; c += 4L) {
                            long idx2;
                            long idx1;
                            long s2;
                            for (s2 = 0L; s2 < this.slicesl; ++s2) {
                                idx1 = s2 * this.sliceStridel + idx0 + c;
                                idx2 = this.slicesl + s2;
                                t2.setDouble(s2, a.getDouble(idx1));
                                t2.setDouble(idx2, a.getDouble(idx1 + 1L));
                                t2.setDouble(idx2 + this.slicesl, a.getDouble(idx1 + 2L));
                                t2.setDouble(idx2 + 2L * this.slicesl, a.getDouble(idx1 + 3L));
                            }
                            this.dstSlices.forward(t2, 0L, scale);
                            this.dstSlices.forward(t2, this.slicesl, scale);
                            this.dstSlices.forward(t2, 2L * this.slicesl, scale);
                            this.dstSlices.forward(t2, 3L * this.slicesl, scale);
                            for (s2 = 0L; s2 < this.slicesl; ++s2) {
                                idx1 = s2 * this.sliceStridel + idx0 + c;
                                idx2 = this.slicesl + s2;
                                a.setDouble(idx1, t2.getDouble(s2));
                                a.setDouble(idx1 + 1L, t2.getDouble(idx2));
                                a.setDouble(idx1 + 2L, t2.getDouble(idx2 + this.slicesl));
                                a.setDouble(idx1 + 3L, t2.getDouble(idx2 + 2L * this.slicesl));
                            }
                        }
                    }
                    break block20;
                }
                if (this.columnsl != 2L) break block20;
                for (long r = 0L; r < this.rowsl; ++r) {
                    long idx1;
                    long s3;
                    long idx0 = r * this.rowStridel;
                    for (s3 = 0L; s3 < this.slicesl; ++s3) {
                        idx1 = s3 * this.sliceStridel + idx0;
                        t2.setDouble(s3, a.getDouble(idx1));
                        t2.setDouble(this.slicesl + s3, a.getDouble(idx1 + 1L));
                    }
                    this.dstSlices.forward(t2, 0L, scale);
                    this.dstSlices.forward(t2, this.slicesl, scale);
                    for (s3 = 0L; s3 < this.slicesl; ++s3) {
                        idx1 = s3 * this.sliceStridel + idx0;
                        a.setDouble(idx1, t2.getDouble(s3));
                        a.setDouble(idx1 + 1L, t2.getDouble(this.slicesl + s3));
                    }
                }
                break block20;
            }
            if (this.columnsl > 2L) {
                for (long r = 0L; r < this.rowsl; ++r) {
                    long idx0 = r * this.rowStridel;
                    for (long c = 0L; c < this.columnsl; c += 4L) {
                        long idx2;
                        long idx1;
                        long s4;
                        for (s4 = 0L; s4 < this.slicesl; ++s4) {
                            idx1 = s4 * this.sliceStridel + idx0 + c;
                            idx2 = this.slicesl + s4;
                            t2.setDouble(s4, a.getDouble(idx1));
                            t2.setDouble(idx2, a.getDouble(idx1 + 1L));
                            t2.setDouble(idx2 + this.slicesl, a.getDouble(idx1 + 2L));
                            t2.setDouble(idx2 + 2L * this.slicesl, a.getDouble(idx1 + 3L));
                        }
                        this.dstSlices.inverse(t2, 0L, scale);
                        this.dstSlices.inverse(t2, this.slicesl, scale);
                        this.dstSlices.inverse(t2, 2L * this.slicesl, scale);
                        this.dstSlices.inverse(t2, 3L * this.slicesl, scale);
                        for (s4 = 0L; s4 < this.slicesl; ++s4) {
                            idx1 = s4 * this.sliceStridel + idx0 + c;
                            idx2 = this.slicesl + s4;
                            a.setDouble(idx1, t2.getDouble(s4));
                            a.setDouble(idx1 + 1L, t2.getDouble(idx2));
                            a.setDouble(idx1 + 2L, t2.getDouble(idx2 + this.slicesl));
                            a.setDouble(idx1 + 3L, t2.getDouble(idx2 + 2L * this.slicesl));
                        }
                    }
                }
            } else if (this.columnsl == 2L) {
                for (long r = 0L; r < this.rowsl; ++r) {
                    long idx1;
                    long s5;
                    long idx0 = r * this.rowStridel;
                    for (s5 = 0L; s5 < this.slicesl; ++s5) {
                        idx1 = s5 * this.sliceStridel + idx0;
                        t2.setDouble(s5, a.getDouble(idx1));
                        t2.setDouble(this.slicesl + s5, a.getDouble(idx1 + 1L));
                    }
                    this.dstSlices.inverse(t2, 0L, scale);
                    this.dstSlices.inverse(t2, this.slicesl, scale);
                    for (s5 = 0L; s5 < this.slicesl; ++s5) {
                        idx1 = s5 * this.sliceStridel + idx0;
                        a.setDouble(idx1, t2.getDouble(s5));
                        a.setDouble(idx1 + 1L, t2.getDouble(this.slicesl + s5));
                    }
                }
            }
        }
    }

    private void ddxt3db_sub(int isgn, double[][][] a, boolean scale) {
        block20: {
            double[] t2;
            block18: {
                block19: {
                    int nt = 4 * this.slices;
                    if (this.columns == 2) {
                        nt >>= 1;
                    }
                    t2 = new double[nt];
                    if (isgn != -1) break block18;
                    if (this.columns <= 2) break block19;
                    for (int r = 0; r < this.rows; ++r) {
                        for (int c = 0; c < this.columns; c += 4) {
                            int idx2;
                            int s2;
                            for (s2 = 0; s2 < this.slices; ++s2) {
                                idx2 = this.slices + s2;
                                t2[s2] = a[s2][r][c];
                                t2[idx2] = a[s2][r][c + 1];
                                t2[idx2 + this.slices] = a[s2][r][c + 2];
                                t2[idx2 + 2 * this.slices] = a[s2][r][c + 3];
                            }
                            this.dstSlices.forward(t2, 0, scale);
                            this.dstSlices.forward(t2, this.slices, scale);
                            this.dstSlices.forward(t2, 2 * this.slices, scale);
                            this.dstSlices.forward(t2, 3 * this.slices, scale);
                            for (s2 = 0; s2 < this.slices; ++s2) {
                                idx2 = this.slices + s2;
                                a[s2][r][c] = t2[s2];
                                a[s2][r][c + 1] = t2[idx2];
                                a[s2][r][c + 2] = t2[idx2 + this.slices];
                                a[s2][r][c + 3] = t2[idx2 + 2 * this.slices];
                            }
                        }
                    }
                    break block20;
                }
                if (this.columns != 2) break block20;
                for (int r = 0; r < this.rows; ++r) {
                    int s3;
                    for (s3 = 0; s3 < this.slices; ++s3) {
                        t2[s3] = a[s3][r][0];
                        t2[this.slices + s3] = a[s3][r][1];
                    }
                    this.dstSlices.forward(t2, 0, scale);
                    this.dstSlices.forward(t2, this.slices, scale);
                    for (s3 = 0; s3 < this.slices; ++s3) {
                        a[s3][r][0] = t2[s3];
                        a[s3][r][1] = t2[this.slices + s3];
                    }
                }
                break block20;
            }
            if (this.columns > 2) {
                for (int r = 0; r < this.rows; ++r) {
                    for (int c = 0; c < this.columns; c += 4) {
                        int idx2;
                        int s4;
                        for (s4 = 0; s4 < this.slices; ++s4) {
                            idx2 = this.slices + s4;
                            t2[s4] = a[s4][r][c];
                            t2[idx2] = a[s4][r][c + 1];
                            t2[idx2 + this.slices] = a[s4][r][c + 2];
                            t2[idx2 + 2 * this.slices] = a[s4][r][c + 3];
                        }
                        this.dstSlices.inverse(t2, 0, scale);
                        this.dstSlices.inverse(t2, this.slices, scale);
                        this.dstSlices.inverse(t2, 2 * this.slices, scale);
                        this.dstSlices.inverse(t2, 3 * this.slices, scale);
                        for (s4 = 0; s4 < this.slices; ++s4) {
                            idx2 = this.slices + s4;
                            a[s4][r][c] = t2[s4];
                            a[s4][r][c + 1] = t2[idx2];
                            a[s4][r][c + 2] = t2[idx2 + this.slices];
                            a[s4][r][c + 3] = t2[idx2 + 2 * this.slices];
                        }
                    }
                }
            } else if (this.columns == 2) {
                for (int r = 0; r < this.rows; ++r) {
                    int s5;
                    for (s5 = 0; s5 < this.slices; ++s5) {
                        t2[s5] = a[s5][r][0];
                        t2[this.slices + s5] = a[s5][r][1];
                    }
                    this.dstSlices.inverse(t2, 0, scale);
                    this.dstSlices.inverse(t2, this.slices, scale);
                    for (s5 = 0; s5 < this.slices; ++s5) {
                        a[s5][r][0] = t2[s5];
                        a[s5][r][1] = t2[this.slices + s5];
                    }
                }
            }
        }
    }

    private void ddxt3da_subth(final int isgn, final double[] a, final boolean scale) {
        final int nthreads = ConcurrencyUtils.getNumberOfThreads() > this.slices ? this.slices : ConcurrencyUtils.getNumberOfThreads();
        int nt = 4 * this.rows;
        if (this.columns == 2) {
            nt >>= 1;
        }
        final int ntf = nt;
        Future[] futures = new Future[nthreads];
        for (int i = 0; i < nthreads; ++i) {
            final int n0 = i;
            futures[i] = ConcurrencyUtils.submit(new Runnable(){

                @Override
                public void run() {
                    double[] t2 = new double[ntf];
                    if (isgn == -1) {
                        for (int s2 = n0; s2 < DoubleDST_3D.this.slices; s2 += nthreads) {
                            int idx1;
                            int r;
                            int idx0 = s2 * DoubleDST_3D.this.sliceStride;
                            for (r = 0; r < DoubleDST_3D.this.rows; ++r) {
                                DoubleDST_3D.this.dstColumns.forward(a, idx0 + r * DoubleDST_3D.this.rowStride, scale);
                            }
                            if (DoubleDST_3D.this.columns > 2) {
                                for (int c = 0; c < DoubleDST_3D.this.columns; c += 4) {
                                    int idx2;
                                    int r2;
                                    for (r2 = 0; r2 < DoubleDST_3D.this.rows; ++r2) {
                                        idx1 = idx0 + r2 * DoubleDST_3D.this.rowStride + c;
                                        idx2 = DoubleDST_3D.this.rows + r2;
                                        t2[r2] = a[idx1];
                                        t2[idx2] = a[idx1 + 1];
                                        t2[idx2 + ((DoubleDST_3D)DoubleDST_3D.this).rows] = a[idx1 + 2];
                                        t2[idx2 + 2 * ((DoubleDST_3D)DoubleDST_3D.this).rows] = a[idx1 + 3];
                                    }
                                    DoubleDST_3D.this.dstRows.forward(t2, 0, scale);
                                    DoubleDST_3D.this.dstRows.forward(t2, DoubleDST_3D.this.rows, scale);
                                    DoubleDST_3D.this.dstRows.forward(t2, 2 * DoubleDST_3D.this.rows, scale);
                                    DoubleDST_3D.this.dstRows.forward(t2, 3 * DoubleDST_3D.this.rows, scale);
                                    for (r2 = 0; r2 < DoubleDST_3D.this.rows; ++r2) {
                                        idx1 = idx0 + r2 * DoubleDST_3D.this.rowStride + c;
                                        idx2 = DoubleDST_3D.this.rows + r2;
                                        a[idx1] = t2[r2];
                                        a[idx1 + 1] = t2[idx2];
                                        a[idx1 + 2] = t2[idx2 + DoubleDST_3D.this.rows];
                                        a[idx1 + 3] = t2[idx2 + 2 * DoubleDST_3D.this.rows];
                                    }
                                }
                                continue;
                            }
                            if (DoubleDST_3D.this.columns != 2) continue;
                            for (r = 0; r < DoubleDST_3D.this.rows; ++r) {
                                idx1 = idx0 + r * DoubleDST_3D.this.rowStride;
                                t2[r] = a[idx1];
                                t2[((DoubleDST_3D)DoubleDST_3D.this).rows + r] = a[idx1 + 1];
                            }
                            DoubleDST_3D.this.dstRows.forward(t2, 0, scale);
                            DoubleDST_3D.this.dstRows.forward(t2, DoubleDST_3D.this.rows, scale);
                            for (r = 0; r < DoubleDST_3D.this.rows; ++r) {
                                idx1 = idx0 + r * DoubleDST_3D.this.rowStride;
                                a[idx1] = t2[r];
                                a[idx1 + 1] = t2[DoubleDST_3D.this.rows + r];
                            }
                        }
                    } else {
                        for (int s3 = n0; s3 < DoubleDST_3D.this.slices; s3 += nthreads) {
                            int idx1;
                            int r;
                            int idx0 = s3 * DoubleDST_3D.this.sliceStride;
                            for (r = 0; r < DoubleDST_3D.this.rows; ++r) {
                                DoubleDST_3D.this.dstColumns.inverse(a, idx0 + r * DoubleDST_3D.this.rowStride, scale);
                            }
                            if (DoubleDST_3D.this.columns > 2) {
                                for (int c = 0; c < DoubleDST_3D.this.columns; c += 4) {
                                    int idx2;
                                    int r3;
                                    for (r3 = 0; r3 < DoubleDST_3D.this.rows; ++r3) {
                                        idx1 = idx0 + r3 * DoubleDST_3D.this.rowStride + c;
                                        idx2 = DoubleDST_3D.this.rows + r3;
                                        t2[r3] = a[idx1];
                                        t2[idx2] = a[idx1 + 1];
                                        t2[idx2 + ((DoubleDST_3D)DoubleDST_3D.this).rows] = a[idx1 + 2];
                                        t2[idx2 + 2 * ((DoubleDST_3D)DoubleDST_3D.this).rows] = a[idx1 + 3];
                                    }
                                    DoubleDST_3D.this.dstRows.inverse(t2, 0, scale);
                                    DoubleDST_3D.this.dstRows.inverse(t2, DoubleDST_3D.this.rows, scale);
                                    DoubleDST_3D.this.dstRows.inverse(t2, 2 * DoubleDST_3D.this.rows, scale);
                                    DoubleDST_3D.this.dstRows.inverse(t2, 3 * DoubleDST_3D.this.rows, scale);
                                    for (r3 = 0; r3 < DoubleDST_3D.this.rows; ++r3) {
                                        idx1 = idx0 + r3 * DoubleDST_3D.this.rowStride + c;
                                        idx2 = DoubleDST_3D.this.rows + r3;
                                        a[idx1] = t2[r3];
                                        a[idx1 + 1] = t2[idx2];
                                        a[idx1 + 2] = t2[idx2 + DoubleDST_3D.this.rows];
                                        a[idx1 + 3] = t2[idx2 + 2 * DoubleDST_3D.this.rows];
                                    }
                                }
                                continue;
                            }
                            if (DoubleDST_3D.this.columns != 2) continue;
                            for (r = 0; r < DoubleDST_3D.this.rows; ++r) {
                                idx1 = idx0 + r * DoubleDST_3D.this.rowStride;
                                t2[r] = a[idx1];
                                t2[((DoubleDST_3D)DoubleDST_3D.this).rows + r] = a[idx1 + 1];
                            }
                            DoubleDST_3D.this.dstRows.inverse(t2, 0, scale);
                            DoubleDST_3D.this.dstRows.inverse(t2, DoubleDST_3D.this.rows, scale);
                            for (r = 0; r < DoubleDST_3D.this.rows; ++r) {
                                idx1 = idx0 + r * DoubleDST_3D.this.rowStride;
                                a[idx1] = t2[r];
                                a[idx1 + 1] = t2[DoubleDST_3D.this.rows + r];
                            }
                        }
                    }
                }
            });
        }
        try {
            ConcurrencyUtils.waitForCompletion(futures);
        }
        catch (InterruptedException ex) {
            Logger.getLogger(DoubleDST_3D.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (ExecutionException ex) {
            Logger.getLogger(DoubleDST_3D.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    private void ddxt3da_subth(final int isgn, final DoubleLargeArray a, final boolean scale) {
        final int nthreads = (int)((long)ConcurrencyUtils.getNumberOfThreads() > this.slicesl ? this.slicesl : (long)ConcurrencyUtils.getNumberOfThreads());
        long nt = 4L * this.rowsl;
        if (this.columnsl == 2L) {
            nt >>= 1;
        }
        final long ntf = nt;
        Future[] futures = new Future[nthreads];
        for (int i = 0; i < nthreads; ++i) {
            final long n0 = i;
            futures[i] = ConcurrencyUtils.submit(new Runnable(){

                @Override
                public void run() {
                    DoubleLargeArray t2 = new DoubleLargeArray(ntf);
                    if (isgn == -1) {
                        for (long s2 = n0; s2 < DoubleDST_3D.this.slicesl; s2 += (long)nthreads) {
                            long idx1;
                            long r;
                            long idx0 = s2 * DoubleDST_3D.this.sliceStridel;
                            for (r = 0L; r < DoubleDST_3D.this.rowsl; ++r) {
                                DoubleDST_3D.this.dstColumns.forward(a, idx0 + r * DoubleDST_3D.this.rowStridel, scale);
                            }
                            if (DoubleDST_3D.this.columnsl > 2L) {
                                for (long c = 0L; c < DoubleDST_3D.this.columnsl; c += 4L) {
                                    long idx2;
                                    long r2;
                                    for (r2 = 0L; r2 < DoubleDST_3D.this.rowsl; ++r2) {
                                        idx1 = idx0 + r2 * DoubleDST_3D.this.rowStridel + c;
                                        idx2 = DoubleDST_3D.this.rowsl + r2;
                                        t2.setDouble(r2, a.getDouble(idx1));
                                        t2.setDouble(idx2, a.getDouble(idx1 + 1L));
                                        t2.setDouble(idx2 + DoubleDST_3D.this.rowsl, a.getDouble(idx1 + 2L));
                                        t2.setDouble(idx2 + 2L * DoubleDST_3D.this.rowsl, a.getDouble(idx1 + 3L));
                                    }
                                    DoubleDST_3D.this.dstRows.forward(t2, 0L, scale);
                                    DoubleDST_3D.this.dstRows.forward(t2, DoubleDST_3D.this.rowsl, scale);
                                    DoubleDST_3D.this.dstRows.forward(t2, 2L * DoubleDST_3D.this.rowsl, scale);
                                    DoubleDST_3D.this.dstRows.forward(t2, 3L * DoubleDST_3D.this.rowsl, scale);
                                    for (r2 = 0L; r2 < DoubleDST_3D.this.rowsl; ++r2) {
                                        idx1 = idx0 + r2 * DoubleDST_3D.this.rowStridel + c;
                                        idx2 = DoubleDST_3D.this.rowsl + r2;
                                        a.setDouble(idx1, t2.getDouble(r2));
                                        a.setDouble(idx1 + 1L, t2.getDouble(idx2));
                                        a.setDouble(idx1 + 2L, t2.getDouble(idx2 + DoubleDST_3D.this.rowsl));
                                        a.setDouble(idx1 + 3L, t2.getDouble(idx2 + 2L * DoubleDST_3D.this.rowsl));
                                    }
                                }
                                continue;
                            }
                            if (DoubleDST_3D.this.columnsl != 2L) continue;
                            for (r = 0L; r < DoubleDST_3D.this.rowsl; ++r) {
                                idx1 = idx0 + r * DoubleDST_3D.this.rowStridel;
                                t2.setDouble(r, a.getDouble(idx1));
                                t2.setDouble(DoubleDST_3D.this.rowsl + r, a.getDouble(idx1 + 1L));
                            }
                            DoubleDST_3D.this.dstRows.forward(t2, 0L, scale);
                            DoubleDST_3D.this.dstRows.forward(t2, DoubleDST_3D.this.rowsl, scale);
                            for (r = 0L; r < DoubleDST_3D.this.rowsl; ++r) {
                                idx1 = idx0 + r * DoubleDST_3D.this.rowStridel;
                                a.setDouble(idx1, t2.getDouble(r));
                                a.setDouble(idx1 + 1L, t2.getDouble(DoubleDST_3D.this.rowsl + r));
                            }
                        }
                    } else {
                        for (long s3 = n0; s3 < DoubleDST_3D.this.slicesl; s3 += (long)nthreads) {
                            long idx1;
                            long r;
                            long idx0 = s3 * DoubleDST_3D.this.sliceStridel;
                            for (r = 0L; r < DoubleDST_3D.this.rowsl; ++r) {
                                DoubleDST_3D.this.dstColumns.inverse(a, idx0 + r * DoubleDST_3D.this.rowStridel, scale);
                            }
                            if (DoubleDST_3D.this.columnsl > 2L) {
                                for (long c = 0L; c < DoubleDST_3D.this.columnsl; c += 4L) {
                                    long idx2;
                                    long r3;
                                    for (r3 = 0L; r3 < DoubleDST_3D.this.rowsl; ++r3) {
                                        idx1 = idx0 + r3 * DoubleDST_3D.this.rowStridel + c;
                                        idx2 = DoubleDST_3D.this.rowsl + r3;
                                        t2.setDouble(r3, a.getDouble(idx1));
                                        t2.setDouble(idx2, a.getDouble(idx1 + 1L));
                                        t2.setDouble(idx2 + DoubleDST_3D.this.rowsl, a.getDouble(idx1 + 2L));
                                        t2.setDouble(idx2 + 2L * DoubleDST_3D.this.rowsl, a.getDouble(idx1 + 3L));
                                    }
                                    DoubleDST_3D.this.dstRows.inverse(t2, 0L, scale);
                                    DoubleDST_3D.this.dstRows.inverse(t2, DoubleDST_3D.this.rowsl, scale);
                                    DoubleDST_3D.this.dstRows.inverse(t2, 2L * DoubleDST_3D.this.rowsl, scale);
                                    DoubleDST_3D.this.dstRows.inverse(t2, 3L * DoubleDST_3D.this.rowsl, scale);
                                    for (r3 = 0L; r3 < DoubleDST_3D.this.rowsl; ++r3) {
                                        idx1 = idx0 + r3 * DoubleDST_3D.this.rowStridel + c;
                                        idx2 = DoubleDST_3D.this.rowsl + r3;
                                        a.setDouble(idx1, t2.getDouble(r3));
                                        a.setDouble(idx1 + 1L, t2.getDouble(idx2));
                                        a.setDouble(idx1 + 2L, t2.getDouble(idx2 + DoubleDST_3D.this.rowsl));
                                        a.setDouble(idx1 + 3L, t2.getDouble(idx2 + 2L * DoubleDST_3D.this.rowsl));
                                    }
                                }
                                continue;
                            }
                            if (DoubleDST_3D.this.columnsl != 2L) continue;
                            for (r = 0L; r < DoubleDST_3D.this.rowsl; ++r) {
                                idx1 = idx0 + r * DoubleDST_3D.this.rowStridel;
                                t2.setDouble(r, a.getDouble(idx1));
                                t2.setDouble(DoubleDST_3D.this.rowsl + r, a.getDouble(idx1 + 1L));
                            }
                            DoubleDST_3D.this.dstRows.inverse(t2, 0L, scale);
                            DoubleDST_3D.this.dstRows.inverse(t2, DoubleDST_3D.this.rowsl, scale);
                            for (r = 0L; r < DoubleDST_3D.this.rowsl; ++r) {
                                idx1 = idx0 + r * DoubleDST_3D.this.rowStridel;
                                a.setDouble(idx1, t2.getDouble(r));
                                a.setDouble(idx1 + 1L, t2.getDouble(DoubleDST_3D.this.rowsl + r));
                            }
                        }
                    }
                }
            });
        }
        try {
            ConcurrencyUtils.waitForCompletion(futures);
        }
        catch (InterruptedException ex) {
            Logger.getLogger(DoubleDST_3D.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (ExecutionException ex) {
            Logger.getLogger(DoubleDST_3D.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    private void ddxt3da_subth(final int isgn, final double[][][] a, final boolean scale) {
        final int nthreads = ConcurrencyUtils.getNumberOfThreads() > this.slices ? this.slices : ConcurrencyUtils.getNumberOfThreads();
        int nt = 4 * this.rows;
        if (this.columns == 2) {
            nt >>= 1;
        }
        final int ntf = nt;
        Future[] futures = new Future[nthreads];
        for (int i = 0; i < nthreads; ++i) {
            final int n0 = i;
            futures[i] = ConcurrencyUtils.submit(new Runnable(){

                @Override
                public void run() {
                    double[] t2 = new double[ntf];
                    if (isgn == -1) {
                        for (int s2 = n0; s2 < DoubleDST_3D.this.slices; s2 += nthreads) {
                            int r;
                            for (r = 0; r < DoubleDST_3D.this.rows; ++r) {
                                DoubleDST_3D.this.dstColumns.forward(a[s2][r], scale);
                            }
                            if (DoubleDST_3D.this.columns > 2) {
                                for (int c = 0; c < DoubleDST_3D.this.columns; c += 4) {
                                    int idx2;
                                    int r2;
                                    for (r2 = 0; r2 < DoubleDST_3D.this.rows; ++r2) {
                                        idx2 = DoubleDST_3D.this.rows + r2;
                                        t2[r2] = a[s2][r2][c];
                                        t2[idx2] = a[s2][r2][c + 1];
                                        t2[idx2 + ((DoubleDST_3D)DoubleDST_3D.this).rows] = a[s2][r2][c + 2];
                                        t2[idx2 + 2 * ((DoubleDST_3D)DoubleDST_3D.this).rows] = a[s2][r2][c + 3];
                                    }
                                    DoubleDST_3D.this.dstRows.forward(t2, 0, scale);
                                    DoubleDST_3D.this.dstRows.forward(t2, DoubleDST_3D.this.rows, scale);
                                    DoubleDST_3D.this.dstRows.forward(t2, 2 * DoubleDST_3D.this.rows, scale);
                                    DoubleDST_3D.this.dstRows.forward(t2, 3 * DoubleDST_3D.this.rows, scale);
                                    for (r2 = 0; r2 < DoubleDST_3D.this.rows; ++r2) {
                                        idx2 = DoubleDST_3D.this.rows + r2;
                                        a[s2][r2][c] = t2[r2];
                                        a[s2][r2][c + 1] = t2[idx2];
                                        a[s2][r2][c + 2] = t2[idx2 + DoubleDST_3D.this.rows];
                                        a[s2][r2][c + 3] = t2[idx2 + 2 * DoubleDST_3D.this.rows];
                                    }
                                }
                                continue;
                            }
                            if (DoubleDST_3D.this.columns != 2) continue;
                            for (r = 0; r < DoubleDST_3D.this.rows; ++r) {
                                t2[r] = a[s2][r][0];
                                t2[((DoubleDST_3D)DoubleDST_3D.this).rows + r] = a[s2][r][1];
                            }
                            DoubleDST_3D.this.dstRows.forward(t2, 0, scale);
                            DoubleDST_3D.this.dstRows.forward(t2, DoubleDST_3D.this.rows, scale);
                            for (r = 0; r < DoubleDST_3D.this.rows; ++r) {
                                a[s2][r][0] = t2[r];
                                a[s2][r][1] = t2[DoubleDST_3D.this.rows + r];
                            }
                        }
                    } else {
                        for (int s3 = n0; s3 < DoubleDST_3D.this.slices; s3 += nthreads) {
                            int r;
                            for (r = 0; r < DoubleDST_3D.this.rows; ++r) {
                                DoubleDST_3D.this.dstColumns.inverse(a[s3][r], scale);
                            }
                            if (DoubleDST_3D.this.columns > 2) {
                                for (int c = 0; c < DoubleDST_3D.this.columns; c += 4) {
                                    int idx2;
                                    int r3;
                                    for (r3 = 0; r3 < DoubleDST_3D.this.rows; ++r3) {
                                        idx2 = DoubleDST_3D.this.rows + r3;
                                        t2[r3] = a[s3][r3][c];
                                        t2[idx2] = a[s3][r3][c + 1];
                                        t2[idx2 + ((DoubleDST_3D)DoubleDST_3D.this).rows] = a[s3][r3][c + 2];
                                        t2[idx2 + 2 * ((DoubleDST_3D)DoubleDST_3D.this).rows] = a[s3][r3][c + 3];
                                    }
                                    DoubleDST_3D.this.dstRows.inverse(t2, 0, scale);
                                    DoubleDST_3D.this.dstRows.inverse(t2, DoubleDST_3D.this.rows, scale);
                                    DoubleDST_3D.this.dstRows.inverse(t2, 2 * DoubleDST_3D.this.rows, scale);
                                    DoubleDST_3D.this.dstRows.inverse(t2, 3 * DoubleDST_3D.this.rows, scale);
                                    for (r3 = 0; r3 < DoubleDST_3D.this.rows; ++r3) {
                                        idx2 = DoubleDST_3D.this.rows + r3;
                                        a[s3][r3][c] = t2[r3];
                                        a[s3][r3][c + 1] = t2[idx2];
                                        a[s3][r3][c + 2] = t2[idx2 + DoubleDST_3D.this.rows];
                                        a[s3][r3][c + 3] = t2[idx2 + 2 * DoubleDST_3D.this.rows];
                                    }
                                }
                                continue;
                            }
                            if (DoubleDST_3D.this.columns != 2) continue;
                            for (r = 0; r < DoubleDST_3D.this.rows; ++r) {
                                t2[r] = a[s3][r][0];
                                t2[((DoubleDST_3D)DoubleDST_3D.this).rows + r] = a[s3][r][1];
                            }
                            DoubleDST_3D.this.dstRows.inverse(t2, 0, scale);
                            DoubleDST_3D.this.dstRows.inverse(t2, DoubleDST_3D.this.rows, scale);
                            for (r = 0; r < DoubleDST_3D.this.rows; ++r) {
                                a[s3][r][0] = t2[r];
                                a[s3][r][1] = t2[DoubleDST_3D.this.rows + r];
                            }
                        }
                    }
                }
            });
        }
        try {
            ConcurrencyUtils.waitForCompletion(futures);
        }
        catch (InterruptedException ex) {
            Logger.getLogger(DoubleDST_3D.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (ExecutionException ex) {
            Logger.getLogger(DoubleDST_3D.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    private void ddxt3db_subth(final int isgn, final double[] a, final boolean scale) {
        final int nthreads = ConcurrencyUtils.getNumberOfThreads() > this.rows ? this.rows : ConcurrencyUtils.getNumberOfThreads();
        int nt = 4 * this.slices;
        if (this.columns == 2) {
            nt >>= 1;
        }
        final int ntf = nt;
        Future[] futures = new Future[nthreads];
        for (int i = 0; i < nthreads; ++i) {
            final int n0 = i;
            futures[i] = ConcurrencyUtils.submit(new Runnable(){

                @Override
                public void run() {
                    block19: {
                        double[] t2;
                        block17: {
                            block18: {
                                t2 = new double[ntf];
                                if (isgn != -1) break block17;
                                if (DoubleDST_3D.this.columns <= 2) break block18;
                                for (int r = n0; r < DoubleDST_3D.this.rows; r += nthreads) {
                                    int idx0 = r * DoubleDST_3D.this.rowStride;
                                    for (int c = 0; c < DoubleDST_3D.this.columns; c += 4) {
                                        int idx2;
                                        int idx1;
                                        int s2;
                                        for (s2 = 0; s2 < DoubleDST_3D.this.slices; ++s2) {
                                            idx1 = s2 * DoubleDST_3D.this.sliceStride + idx0 + c;
                                            idx2 = DoubleDST_3D.this.slices + s2;
                                            t2[s2] = a[idx1];
                                            t2[idx2] = a[idx1 + 1];
                                            t2[idx2 + ((DoubleDST_3D)DoubleDST_3D.this).slices] = a[idx1 + 2];
                                            t2[idx2 + 2 * ((DoubleDST_3D)DoubleDST_3D.this).slices] = a[idx1 + 3];
                                        }
                                        DoubleDST_3D.this.dstSlices.forward(t2, 0, scale);
                                        DoubleDST_3D.this.dstSlices.forward(t2, DoubleDST_3D.this.slices, scale);
                                        DoubleDST_3D.this.dstSlices.forward(t2, 2 * DoubleDST_3D.this.slices, scale);
                                        DoubleDST_3D.this.dstSlices.forward(t2, 3 * DoubleDST_3D.this.slices, scale);
                                        for (s2 = 0; s2 < DoubleDST_3D.this.slices; ++s2) {
                                            idx1 = s2 * DoubleDST_3D.this.sliceStride + idx0 + c;
                                            idx2 = DoubleDST_3D.this.slices + s2;
                                            a[idx1] = t2[s2];
                                            a[idx1 + 1] = t2[idx2];
                                            a[idx1 + 2] = t2[idx2 + DoubleDST_3D.this.slices];
                                            a[idx1 + 3] = t2[idx2 + 2 * DoubleDST_3D.this.slices];
                                        }
                                    }
                                }
                                break block19;
                            }
                            if (DoubleDST_3D.this.columns != 2) break block19;
                            for (int r = n0; r < DoubleDST_3D.this.rows; r += nthreads) {
                                int idx1;
                                int s3;
                                int idx0 = r * DoubleDST_3D.this.rowStride;
                                for (s3 = 0; s3 < DoubleDST_3D.this.slices; ++s3) {
                                    idx1 = s3 * DoubleDST_3D.this.sliceStride + idx0;
                                    t2[s3] = a[idx1];
                                    t2[((DoubleDST_3D)DoubleDST_3D.this).slices + s3] = a[idx1 + 1];
                                }
                                DoubleDST_3D.this.dstSlices.forward(t2, 0, scale);
                                DoubleDST_3D.this.dstSlices.forward(t2, DoubleDST_3D.this.slices, scale);
                                for (s3 = 0; s3 < DoubleDST_3D.this.slices; ++s3) {
                                    idx1 = s3 * DoubleDST_3D.this.sliceStride + idx0;
                                    a[idx1] = t2[s3];
                                    a[idx1 + 1] = t2[DoubleDST_3D.this.slices + s3];
                                }
                            }
                            break block19;
                        }
                        if (DoubleDST_3D.this.columns > 2) {
                            for (int r = n0; r < DoubleDST_3D.this.rows; r += nthreads) {
                                int idx0 = r * DoubleDST_3D.this.rowStride;
                                for (int c = 0; c < DoubleDST_3D.this.columns; c += 4) {
                                    int idx2;
                                    int idx1;
                                    int s4;
                                    for (s4 = 0; s4 < DoubleDST_3D.this.slices; ++s4) {
                                        idx1 = s4 * DoubleDST_3D.this.sliceStride + idx0 + c;
                                        idx2 = DoubleDST_3D.this.slices + s4;
                                        t2[s4] = a[idx1];
                                        t2[idx2] = a[idx1 + 1];
                                        t2[idx2 + ((DoubleDST_3D)DoubleDST_3D.this).slices] = a[idx1 + 2];
                                        t2[idx2 + 2 * ((DoubleDST_3D)DoubleDST_3D.this).slices] = a[idx1 + 3];
                                    }
                                    DoubleDST_3D.this.dstSlices.inverse(t2, 0, scale);
                                    DoubleDST_3D.this.dstSlices.inverse(t2, DoubleDST_3D.this.slices, scale);
                                    DoubleDST_3D.this.dstSlices.inverse(t2, 2 * DoubleDST_3D.this.slices, scale);
                                    DoubleDST_3D.this.dstSlices.inverse(t2, 3 * DoubleDST_3D.this.slices, scale);
                                    for (s4 = 0; s4 < DoubleDST_3D.this.slices; ++s4) {
                                        idx1 = s4 * DoubleDST_3D.this.sliceStride + idx0 + c;
                                        idx2 = DoubleDST_3D.this.slices + s4;
                                        a[idx1] = t2[s4];
                                        a[idx1 + 1] = t2[idx2];
                                        a[idx1 + 2] = t2[idx2 + DoubleDST_3D.this.slices];
                                        a[idx1 + 3] = t2[idx2 + 2 * DoubleDST_3D.this.slices];
                                    }
                                }
                            }
                        } else if (DoubleDST_3D.this.columns == 2) {
                            for (int r = n0; r < DoubleDST_3D.this.rows; r += nthreads) {
                                int idx1;
                                int s5;
                                int idx0 = r * DoubleDST_3D.this.rowStride;
                                for (s5 = 0; s5 < DoubleDST_3D.this.slices; ++s5) {
                                    idx1 = s5 * DoubleDST_3D.this.sliceStride + idx0;
                                    t2[s5] = a[idx1];
                                    t2[((DoubleDST_3D)DoubleDST_3D.this).slices + s5] = a[idx1 + 1];
                                }
                                DoubleDST_3D.this.dstSlices.inverse(t2, 0, scale);
                                DoubleDST_3D.this.dstSlices.inverse(t2, DoubleDST_3D.this.slices, scale);
                                for (s5 = 0; s5 < DoubleDST_3D.this.slices; ++s5) {
                                    idx1 = s5 * DoubleDST_3D.this.sliceStride + idx0;
                                    a[idx1] = t2[s5];
                                    a[idx1 + 1] = t2[DoubleDST_3D.this.slices + s5];
                                }
                            }
                        }
                    }
                }
            });
        }
        try {
            ConcurrencyUtils.waitForCompletion(futures);
        }
        catch (InterruptedException ex) {
            Logger.getLogger(DoubleDST_3D.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (ExecutionException ex) {
            Logger.getLogger(DoubleDST_3D.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    private void ddxt3db_subth(final int isgn, final DoubleLargeArray a, final boolean scale) {
        final int nthreads = (int)((long)ConcurrencyUtils.getNumberOfThreads() > this.rowsl ? this.rowsl : (long)ConcurrencyUtils.getNumberOfThreads());
        long nt = 4L * this.slicesl;
        if (this.columnsl == 2L) {
            nt >>= 1;
        }
        final long ntf = nt;
        Future[] futures = new Future[nthreads];
        for (int i = 0; i < nthreads; ++i) {
            final long n0 = i;
            futures[i] = ConcurrencyUtils.submit(new Runnable(){

                @Override
                public void run() {
                    block19: {
                        DoubleLargeArray t2;
                        block17: {
                            block18: {
                                t2 = new DoubleLargeArray(ntf);
                                if (isgn != -1) break block17;
                                if (DoubleDST_3D.this.columnsl <= 2L) break block18;
                                for (long r = n0; r < DoubleDST_3D.this.rowsl; r += (long)nthreads) {
                                    long idx0 = r * DoubleDST_3D.this.rowStridel;
                                    for (long c = 0L; c < DoubleDST_3D.this.columnsl; c += 4L) {
                                        long idx2;
                                        long idx1;
                                        long s2;
                                        for (s2 = 0L; s2 < DoubleDST_3D.this.slicesl; ++s2) {
                                            idx1 = s2 * DoubleDST_3D.this.sliceStridel + idx0 + c;
                                            idx2 = DoubleDST_3D.this.slicesl + s2;
                                            t2.setDouble(s2, a.getDouble(idx1));
                                            t2.setDouble(idx2, a.getDouble(idx1 + 1L));
                                            t2.setDouble(idx2 + DoubleDST_3D.this.slicesl, a.getDouble(idx1 + 2L));
                                            t2.setDouble(idx2 + 2L * DoubleDST_3D.this.slicesl, a.getDouble(idx1 + 3L));
                                        }
                                        DoubleDST_3D.this.dstSlices.forward(t2, 0L, scale);
                                        DoubleDST_3D.this.dstSlices.forward(t2, DoubleDST_3D.this.slicesl, scale);
                                        DoubleDST_3D.this.dstSlices.forward(t2, 2L * DoubleDST_3D.this.slicesl, scale);
                                        DoubleDST_3D.this.dstSlices.forward(t2, 3L * DoubleDST_3D.this.slicesl, scale);
                                        for (s2 = 0L; s2 < DoubleDST_3D.this.slicesl; ++s2) {
                                            idx1 = s2 * DoubleDST_3D.this.sliceStridel + idx0 + c;
                                            idx2 = DoubleDST_3D.this.slicesl + s2;
                                            a.setDouble(idx1, t2.getDouble(s2));
                                            a.setDouble(idx1 + 1L, t2.getDouble(idx2));
                                            a.setDouble(idx1 + 2L, t2.getDouble(idx2 + DoubleDST_3D.this.slicesl));
                                            a.setDouble(idx1 + 3L, t2.getDouble(idx2 + 2L * DoubleDST_3D.this.slicesl));
                                        }
                                    }
                                }
                                break block19;
                            }
                            if (DoubleDST_3D.this.columnsl != 2L) break block19;
                            for (long r = n0; r < DoubleDST_3D.this.rowsl; r += (long)nthreads) {
                                long idx1;
                                long s3;
                                long idx0 = r * DoubleDST_3D.this.rowStridel;
                                for (s3 = 0L; s3 < DoubleDST_3D.this.slicesl; ++s3) {
                                    idx1 = s3 * DoubleDST_3D.this.sliceStridel + idx0;
                                    t2.setDouble(s3, a.getDouble(idx1));
                                    t2.setDouble(DoubleDST_3D.this.slicesl + s3, a.getDouble(idx1 + 1L));
                                }
                                DoubleDST_3D.this.dstSlices.forward(t2, 0L, scale);
                                DoubleDST_3D.this.dstSlices.forward(t2, DoubleDST_3D.this.slicesl, scale);
                                for (s3 = 0L; s3 < DoubleDST_3D.this.slicesl; ++s3) {
                                    idx1 = s3 * DoubleDST_3D.this.sliceStridel + idx0;
                                    a.setDouble(idx1, t2.getDouble(s3));
                                    a.setDouble(idx1 + 1L, t2.getDouble(DoubleDST_3D.this.slicesl + s3));
                                }
                            }
                            break block19;
                        }
                        if (DoubleDST_3D.this.columnsl > 2L) {
                            for (long r = n0; r < DoubleDST_3D.this.rowsl; r += (long)nthreads) {
                                long idx0 = r * DoubleDST_3D.this.rowStridel;
                                for (long c = 0L; c < DoubleDST_3D.this.columnsl; c += 4L) {
                                    long idx2;
                                    long idx1;
                                    long s4;
                                    for (s4 = 0L; s4 < DoubleDST_3D.this.slicesl; ++s4) {
                                        idx1 = s4 * DoubleDST_3D.this.sliceStridel + idx0 + c;
                                        idx2 = DoubleDST_3D.this.slicesl + s4;
                                        t2.setDouble(s4, a.getDouble(idx1));
                                        t2.setDouble(idx2, a.getDouble(idx1 + 1L));
                                        t2.setDouble(idx2 + DoubleDST_3D.this.slicesl, a.getDouble(idx1 + 2L));
                                        t2.setDouble(idx2 + 2L * DoubleDST_3D.this.slicesl, a.getDouble(idx1 + 3L));
                                    }
                                    DoubleDST_3D.this.dstSlices.inverse(t2, 0L, scale);
                                    DoubleDST_3D.this.dstSlices.inverse(t2, DoubleDST_3D.this.slicesl, scale);
                                    DoubleDST_3D.this.dstSlices.inverse(t2, 2L * DoubleDST_3D.this.slicesl, scale);
                                    DoubleDST_3D.this.dstSlices.inverse(t2, 3L * DoubleDST_3D.this.slicesl, scale);
                                    for (s4 = 0L; s4 < DoubleDST_3D.this.slicesl; ++s4) {
                                        idx1 = s4 * DoubleDST_3D.this.sliceStridel + idx0 + c;
                                        idx2 = DoubleDST_3D.this.slicesl + s4;
                                        a.setDouble(idx1, t2.getDouble(s4));
                                        a.setDouble(idx1 + 1L, t2.getDouble(idx2));
                                        a.setDouble(idx1 + 2L, t2.getDouble(idx2 + DoubleDST_3D.this.slicesl));
                                        a.setDouble(idx1 + 3L, t2.getDouble(idx2 + 2L * DoubleDST_3D.this.slicesl));
                                    }
                                }
                            }
                        } else if (DoubleDST_3D.this.columnsl == 2L) {
                            for (long r = n0; r < DoubleDST_3D.this.rowsl; r += (long)nthreads) {
                                long idx1;
                                long s5;
                                long idx0 = r * DoubleDST_3D.this.rowStridel;
                                for (s5 = 0L; s5 < DoubleDST_3D.this.slicesl; ++s5) {
                                    idx1 = s5 * DoubleDST_3D.this.sliceStridel + idx0;
                                    t2.setDouble(s5, a.getDouble(idx1));
                                    t2.setDouble(DoubleDST_3D.this.slicesl + s5, a.getDouble(idx1 + 1L));
                                }
                                DoubleDST_3D.this.dstSlices.inverse(t2, 0L, scale);
                                DoubleDST_3D.this.dstSlices.inverse(t2, DoubleDST_3D.this.slicesl, scale);
                                for (s5 = 0L; s5 < DoubleDST_3D.this.slicesl; ++s5) {
                                    idx1 = s5 * DoubleDST_3D.this.sliceStridel + idx0;
                                    a.setDouble(idx1, t2.getDouble(s5));
                                    a.setDouble(idx1 + 1L, t2.getDouble(DoubleDST_3D.this.slicesl + s5));
                                }
                            }
                        }
                    }
                }
            });
        }
        try {
            ConcurrencyUtils.waitForCompletion(futures);
        }
        catch (InterruptedException ex) {
            Logger.getLogger(DoubleDST_3D.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (ExecutionException ex) {
            Logger.getLogger(DoubleDST_3D.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    private void ddxt3db_subth(final int isgn, final double[][][] a, final boolean scale) {
        final int nthreads = ConcurrencyUtils.getNumberOfThreads() > this.rows ? this.rows : ConcurrencyUtils.getNumberOfThreads();
        int nt = 4 * this.slices;
        if (this.columns == 2) {
            nt >>= 1;
        }
        final int ntf = nt;
        Future[] futures = new Future[nthreads];
        for (int i = 0; i < nthreads; ++i) {
            final int n0 = i;
            futures[i] = ConcurrencyUtils.submit(new Runnable(){

                @Override
                public void run() {
                    block19: {
                        double[] t2;
                        block17: {
                            block18: {
                                t2 = new double[ntf];
                                if (isgn != -1) break block17;
                                if (DoubleDST_3D.this.columns <= 2) break block18;
                                for (int r = n0; r < DoubleDST_3D.this.rows; r += nthreads) {
                                    for (int c = 0; c < DoubleDST_3D.this.columns; c += 4) {
                                        int idx2;
                                        int s2;
                                        for (s2 = 0; s2 < DoubleDST_3D.this.slices; ++s2) {
                                            idx2 = DoubleDST_3D.this.slices + s2;
                                            t2[s2] = a[s2][r][c];
                                            t2[idx2] = a[s2][r][c + 1];
                                            t2[idx2 + ((DoubleDST_3D)DoubleDST_3D.this).slices] = a[s2][r][c + 2];
                                            t2[idx2 + 2 * ((DoubleDST_3D)DoubleDST_3D.this).slices] = a[s2][r][c + 3];
                                        }
                                        DoubleDST_3D.this.dstSlices.forward(t2, 0, scale);
                                        DoubleDST_3D.this.dstSlices.forward(t2, DoubleDST_3D.this.slices, scale);
                                        DoubleDST_3D.this.dstSlices.forward(t2, 2 * DoubleDST_3D.this.slices, scale);
                                        DoubleDST_3D.this.dstSlices.forward(t2, 3 * DoubleDST_3D.this.slices, scale);
                                        for (s2 = 0; s2 < DoubleDST_3D.this.slices; ++s2) {
                                            idx2 = DoubleDST_3D.this.slices + s2;
                                            a[s2][r][c] = t2[s2];
                                            a[s2][r][c + 1] = t2[idx2];
                                            a[s2][r][c + 2] = t2[idx2 + DoubleDST_3D.this.slices];
                                            a[s2][r][c + 3] = t2[idx2 + 2 * DoubleDST_3D.this.slices];
                                        }
                                    }
                                }
                                break block19;
                            }
                            if (DoubleDST_3D.this.columns != 2) break block19;
                            for (int r = n0; r < DoubleDST_3D.this.rows; r += nthreads) {
                                int s3;
                                for (s3 = 0; s3 < DoubleDST_3D.this.slices; ++s3) {
                                    t2[s3] = a[s3][r][0];
                                    t2[((DoubleDST_3D)DoubleDST_3D.this).slices + s3] = a[s3][r][1];
                                }
                                DoubleDST_3D.this.dstSlices.forward(t2, 0, scale);
                                DoubleDST_3D.this.dstSlices.forward(t2, DoubleDST_3D.this.slices, scale);
                                for (s3 = 0; s3 < DoubleDST_3D.this.slices; ++s3) {
                                    a[s3][r][0] = t2[s3];
                                    a[s3][r][1] = t2[DoubleDST_3D.this.slices + s3];
                                }
                            }
                            break block19;
                        }
                        if (DoubleDST_3D.this.columns > 2) {
                            for (int r = n0; r < DoubleDST_3D.this.rows; r += nthreads) {
                                for (int c = 0; c < DoubleDST_3D.this.columns; c += 4) {
                                    int idx2;
                                    int s4;
                                    for (s4 = 0; s4 < DoubleDST_3D.this.slices; ++s4) {
                                        idx2 = DoubleDST_3D.this.slices + s4;
                                        t2[s4] = a[s4][r][c];
                                        t2[idx2] = a[s4][r][c + 1];
                                        t2[idx2 + ((DoubleDST_3D)DoubleDST_3D.this).slices] = a[s4][r][c + 2];
                                        t2[idx2 + 2 * ((DoubleDST_3D)DoubleDST_3D.this).slices] = a[s4][r][c + 3];
                                    }
                                    DoubleDST_3D.this.dstSlices.inverse(t2, 0, scale);
                                    DoubleDST_3D.this.dstSlices.inverse(t2, DoubleDST_3D.this.slices, scale);
                                    DoubleDST_3D.this.dstSlices.inverse(t2, 2 * DoubleDST_3D.this.slices, scale);
                                    DoubleDST_3D.this.dstSlices.inverse(t2, 3 * DoubleDST_3D.this.slices, scale);
                                    for (s4 = 0; s4 < DoubleDST_3D.this.slices; ++s4) {
                                        idx2 = DoubleDST_3D.this.slices + s4;
                                        a[s4][r][c] = t2[s4];
                                        a[s4][r][c + 1] = t2[idx2];
                                        a[s4][r][c + 2] = t2[idx2 + DoubleDST_3D.this.slices];
                                        a[s4][r][c + 3] = t2[idx2 + 2 * DoubleDST_3D.this.slices];
                                    }
                                }
                            }
                        } else if (DoubleDST_3D.this.columns == 2) {
                            for (int r = n0; r < DoubleDST_3D.this.rows; r += nthreads) {
                                int s5;
                                for (s5 = 0; s5 < DoubleDST_3D.this.slices; ++s5) {
                                    t2[s5] = a[s5][r][0];
                                    t2[((DoubleDST_3D)DoubleDST_3D.this).slices + s5] = a[s5][r][1];
                                }
                                DoubleDST_3D.this.dstSlices.inverse(t2, 0, scale);
                                DoubleDST_3D.this.dstSlices.inverse(t2, DoubleDST_3D.this.slices, scale);
                                for (s5 = 0; s5 < DoubleDST_3D.this.slices; ++s5) {
                                    a[s5][r][0] = t2[s5];
                                    a[s5][r][1] = t2[DoubleDST_3D.this.slices + s5];
                                }
                            }
                        }
                    }
                }
            });
        }
        try {
            ConcurrencyUtils.waitForCompletion(futures);
        }
        catch (InterruptedException ex) {
            Logger.getLogger(DoubleDST_3D.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (ExecutionException ex) {
            Logger.getLogger(DoubleDST_3D.class.getName()).log(Level.SEVERE, null, ex);
        }
    }
}

