/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.library.dprofile.util;

import java.util.Comparator;
import java.util.List;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.iotdb.library.dprofile.util.Area;
import org.apache.iotdb.library.dprofile.util.Bucket;

class Triangle<T extends Pair<Long, Double>> {
    private final Bucket<T> left;
    private final Bucket<T> center;
    private final Bucket<T> right;

    private Triangle(Bucket<T> left, Bucket<T> center, Bucket<T> right) {
        this.left = left;
        this.center = center;
        this.right = right;
    }

    static <U extends Pair<Long, Double>> Triangle<U> of(List<Bucket<U>> buckets) {
        return new Triangle<U>(buckets.get(0), buckets.get(1), buckets.get(2));
    }

    T getFirst() {
        return this.left.getFirst();
    }

    T getLast() {
        return this.right.getLast();
    }

    T getResult() {
        return this.center.map(b -> Area.ofTriangle(this.left.getResult(), b, this.right.getCenter())).stream().max(Comparator.comparing(Area::getValue)).orElseThrow(() -> new RuntimeException("Can't obtain max area triangle")).getGenerator();
    }
}

