/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.confignode.consensus.request.write.partition;

import java.io.DataOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import org.apache.iotdb.common.rpc.thrift.TTimePartitionSlot;
import org.apache.iotdb.commons.utils.BasicStructureSerDeUtil;
import org.apache.iotdb.commons.utils.ThriftCommonsSerDeUtils;
import org.apache.iotdb.confignode.consensus.request.ConfigPhysicalPlan;
import org.apache.iotdb.confignode.consensus.request.ConfigPhysicalPlanType;

public class AutoCleanPartitionTablePlan
extends ConfigPhysicalPlan {
    Map<String, Long> databaseTTLMap;
    TTimePartitionSlot currentTimeSlot;

    public AutoCleanPartitionTablePlan() {
        super(ConfigPhysicalPlanType.AutoCleanPartitionTable);
    }

    public AutoCleanPartitionTablePlan(Map<String, Long> databaseTTLMap, TTimePartitionSlot currentTimeSlot) {
        this();
        this.databaseTTLMap = databaseTTLMap;
        this.currentTimeSlot = currentTimeSlot;
    }

    public Map<String, Long> getDatabaseTTLMap() {
        return this.databaseTTLMap;
    }

    public TTimePartitionSlot getCurrentTimeSlot() {
        return this.currentTimeSlot;
    }

    @Override
    protected void serializeImpl(DataOutputStream stream) throws IOException {
        stream.writeShort(this.getType().getPlanType());
        stream.writeInt(this.databaseTTLMap.size());
        for (Map.Entry<String, Long> entry : this.databaseTTLMap.entrySet()) {
            BasicStructureSerDeUtil.write((String)entry.getKey(), (DataOutputStream)stream);
            stream.writeLong(entry.getValue());
        }
        ThriftCommonsSerDeUtils.serializeTTimePartitionSlot((TTimePartitionSlot)this.currentTimeSlot, (DataOutputStream)stream);
    }

    @Override
    protected void deserializeImpl(ByteBuffer buffer) throws IOException {
        int size = buffer.getInt();
        this.databaseTTLMap = new TreeMap<String, Long>();
        for (int i = 0; i < size; ++i) {
            String key = BasicStructureSerDeUtil.readString((ByteBuffer)buffer);
            long value = buffer.getLong();
            this.databaseTTLMap.put(key, value);
        }
        this.currentTimeSlot = ThriftCommonsSerDeUtils.deserializeTTimePartitionSlot((ByteBuffer)buffer);
    }

    @Override
    public boolean equals(Object o) {
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        AutoCleanPartitionTablePlan that = (AutoCleanPartitionTablePlan)o;
        return Objects.equals(this.databaseTTLMap, that.databaseTTLMap) && Objects.equals(this.currentTimeSlot, that.currentTimeSlot);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.databaseTTLMap, this.currentTimeSlot);
    }
}

