/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.storageengine.load.metrics;

import java.util.Arrays;
import org.apache.iotdb.commons.service.metric.enums.Metric;
import org.apache.iotdb.commons.service.metric.enums.Tag;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.metrics.AbstractMetricService;
import org.apache.iotdb.metrics.impl.DoNothingMetricManager;
import org.apache.iotdb.metrics.metricsets.IMetricSet;
import org.apache.iotdb.metrics.type.Counter;
import org.apache.iotdb.metrics.type.Timer;
import org.apache.iotdb.metrics.utils.MetricLevel;
import org.apache.iotdb.metrics.utils.MetricType;

public class LoadTsFileCostMetricsSet
implements IMetricSet {
    private static final LoadTsFileCostMetricsSet INSTANCE = new LoadTsFileCostMetricsSet();
    public static final String ANALYSIS = "analysis";
    public static final String FIRST_PHASE = "first_phase";
    public static final String SECOND_PHASE = "second_phase";
    public static final String LOAD_LOCALLY = "load_locally";
    public static final String SCHEDULER_CAST_TABLETS = "scheduler_cast_tablets";
    public static final String ANALYSIS_CAST_TABLETS = "analysis_cast_tablets";
    private Timer analyzerTimer = DoNothingMetricManager.DO_NOTHING_TIMER;
    private Timer firstPhaseTimer = DoNothingMetricManager.DO_NOTHING_TIMER;
    private Timer secondPhaseTimer = DoNothingMetricManager.DO_NOTHING_TIMER;
    private Timer loadLocallyTimer = DoNothingMetricManager.DO_NOTHING_TIMER;
    private Timer schedulerCastTabletsTimer = DoNothingMetricManager.DO_NOTHING_TIMER;
    private Timer analysisCastTabletsTimer = DoNothingMetricManager.DO_NOTHING_TIMER;
    private Counter diskIOCounter = DoNothingMetricManager.DO_NOTHING_COUNTER;

    private LoadTsFileCostMetricsSet() {
    }

    public void recordPhaseTimeCost(String stage, long costTimeInNanos) {
        switch (stage) {
            case "analysis": {
                this.analyzerTimer.updateNanos(costTimeInNanos);
                break;
            }
            case "first_phase": {
                this.firstPhaseTimer.updateNanos(costTimeInNanos);
                break;
            }
            case "second_phase": {
                this.secondPhaseTimer.updateNanos(costTimeInNanos);
                break;
            }
            case "load_locally": {
                this.loadLocallyTimer.updateNanos(costTimeInNanos);
                break;
            }
            case "scheduler_cast_tablets": {
                this.schedulerCastTabletsTimer.updateNanos(costTimeInNanos);
                break;
            }
            case "analysis_cast_tablets": {
                this.analysisCastTabletsTimer.updateNanos(costTimeInNanos);
                break;
            }
            default: {
                throw new UnsupportedOperationException("Unsupported stage: " + stage);
            }
        }
    }

    public void recordDiskIO(long bytes) {
        this.diskIOCounter.inc(bytes);
    }

    public void bindTo(AbstractMetricService metricService) {
        this.analyzerTimer = metricService.getOrCreateTimer(Metric.LOAD_TIME_COST.toString(), MetricLevel.IMPORTANT, new String[]{Tag.NAME.toString(), ANALYSIS});
        this.firstPhaseTimer = metricService.getOrCreateTimer(Metric.LOAD_TIME_COST.toString(), MetricLevel.IMPORTANT, new String[]{Tag.NAME.toString(), FIRST_PHASE});
        this.secondPhaseTimer = metricService.getOrCreateTimer(Metric.LOAD_TIME_COST.toString(), MetricLevel.IMPORTANT, new String[]{Tag.NAME.toString(), SECOND_PHASE});
        this.loadLocallyTimer = metricService.getOrCreateTimer(Metric.LOAD_TIME_COST.toString(), MetricLevel.IMPORTANT, new String[]{Tag.NAME.toString(), LOAD_LOCALLY});
        this.schedulerCastTabletsTimer = metricService.getOrCreateTimer(Metric.LOAD_TIME_COST.toString(), MetricLevel.IMPORTANT, new String[]{Tag.NAME.toString(), SCHEDULER_CAST_TABLETS});
        this.analysisCastTabletsTimer = metricService.getOrCreateTimer(Metric.LOAD_TIME_COST.toString(), MetricLevel.IMPORTANT, new String[]{Tag.NAME.toString(), ANALYSIS_CAST_TABLETS});
        this.diskIOCounter = metricService.getOrCreateCounter(Metric.LOAD_DISK_IO.toString(), MetricLevel.IMPORTANT, new String[]{Tag.NAME.toString(), "DataNode " + IoTDBDescriptor.getInstance().getConfig().getDataNodeId()});
    }

    public void unbindFrom(AbstractMetricService metricService) {
        Arrays.asList(ANALYSIS, FIRST_PHASE, SECOND_PHASE, LOAD_LOCALLY, SCHEDULER_CAST_TABLETS, ANALYSIS_CAST_TABLETS).forEach(stage -> metricService.remove(MetricType.TIMER, Metric.LOAD_TIME_COST.toString(), new String[]{Tag.NAME.toString(), stage}));
        metricService.remove(MetricType.RATE, Metric.LOAD_DISK_IO.toString(), new String[]{Tag.NAME.toString(), String.valueOf(IoTDBDescriptor.getInstance().getConfig().getDataNodeId())});
    }

    public static LoadTsFileCostMetricsSet getInstance() {
        return INSTANCE;
    }
}

