/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.commons.pipe.connector.payload.pipeconsensus.request;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.Objects;
import org.apache.iotdb.common.rpc.thrift.TConsensusGroupId;
import org.apache.iotdb.commons.consensus.index.ProgressIndex;
import org.apache.iotdb.commons.pipe.connector.payload.pipeconsensus.request.PipeConsensusRequestType;
import org.apache.iotdb.commons.pipe.connector.payload.pipeconsensus.request.PipeConsensusRequestVersion;
import org.apache.iotdb.consensus.pipe.thrift.TCommitId;
import org.apache.iotdb.consensus.pipe.thrift.TPipeConsensusTransferReq;
import org.apache.tsfile.utils.PublicBAOS;
import org.apache.tsfile.utils.ReadWriteIOUtils;

public abstract class PipeConsensusTransferFileSealReq
extends TPipeConsensusTransferReq {
    private transient String fileName;
    private transient long fileLength;
    private transient long pointCount;

    public final String getFileName() {
        return this.fileName;
    }

    public final long getFileLength() {
        return this.fileLength;
    }

    public final long getPointCount() {
        return this.pointCount;
    }

    protected abstract PipeConsensusRequestType getPlanType();

    protected PipeConsensusTransferFileSealReq convertToTPipeConsensusTransferReq(String fileName, long fileLength, long pointCount, TCommitId commitId, TConsensusGroupId consensusGroupId, ProgressIndex progressIndex, int thisDataNodeId) throws IOException {
        DataOutputStream outputStream;
        this.fileName = fileName;
        this.fileLength = fileLength;
        this.pointCount = pointCount;
        this.commitId = commitId;
        this.consensusGroupId = consensusGroupId;
        this.dataNodeId = thisDataNodeId;
        this.version = PipeConsensusRequestVersion.VERSION_1.getVersion();
        this.type = this.getPlanType().getType();
        try (PublicBAOS byteArrayOutputStream = new PublicBAOS();){
            outputStream = new DataOutputStream((OutputStream)byteArrayOutputStream);
            try {
                ReadWriteIOUtils.write((String)fileName, (OutputStream)outputStream);
                ReadWriteIOUtils.write((long)fileLength, (OutputStream)outputStream);
                ReadWriteIOUtils.write((long)pointCount, (OutputStream)outputStream);
                this.body = ByteBuffer.wrap(byteArrayOutputStream.getBuf(), 0, byteArrayOutputStream.size());
            }
            finally {
                outputStream.close();
            }
        }
        byteArrayOutputStream = new PublicBAOS();
        try {
            outputStream = new DataOutputStream((OutputStream)byteArrayOutputStream);
            try {
                progressIndex.serialize(outputStream);
                this.progressIndex = ByteBuffer.wrap(byteArrayOutputStream.getBuf(), 0, byteArrayOutputStream.size());
            }
            finally {
                outputStream.close();
            }
        }
        finally {
            byteArrayOutputStream.close();
        }
        return this;
    }

    public PipeConsensusTransferFileSealReq translateFromTPipeConsensusTransferReq(TPipeConsensusTransferReq req) {
        this.fileName = ReadWriteIOUtils.readString((ByteBuffer)req.body);
        this.fileLength = ReadWriteIOUtils.readLong((ByteBuffer)req.body);
        this.pointCount = ReadWriteIOUtils.readLong((ByteBuffer)req.body);
        this.version = req.version;
        this.type = req.type;
        this.body = req.body;
        this.commitId = req.commitId;
        this.dataNodeId = req.dataNodeId;
        this.consensusGroupId = req.consensusGroupId;
        this.progressIndex = req.progressIndex;
        return this;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || ((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        PipeConsensusTransferFileSealReq that = (PipeConsensusTransferFileSealReq)((Object)obj);
        return this.fileName.equals(that.fileName) && this.fileLength == that.fileLength && this.pointCount == that.pointCount && this.version == that.version && this.type == that.type && this.body.equals(that.body) && Objects.equals(this.commitId, that.commitId) && Objects.equals(this.consensusGroupId, that.consensusGroupId) && Objects.equals(this.dataNodeId, that.dataNodeId) && Objects.equals(this.progressIndex, that.progressIndex);
    }

    public int hashCode() {
        return Objects.hash(this.fileName, this.fileLength, this.pointCount, this.version, this.type, this.body, this.commitId, this.consensusGroupId, this.dataNodeId, this.progressIndex);
    }
}

