/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.stack.server;

import java.security.KeyPair;
import java.security.cert.X509Certificate;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import org.eclipse.milo.opcua.stack.core.Stack;
import org.eclipse.milo.opcua.stack.core.channel.EncodingLimits;
import org.eclipse.milo.opcua.stack.core.security.CertificateManager;
import org.eclipse.milo.opcua.stack.core.security.TrustListManager;
import org.eclipse.milo.opcua.stack.core.types.builtin.LocalizedText;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UInteger;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.Unsigned;
import org.eclipse.milo.opcua.stack.server.EndpointConfiguration;
import org.eclipse.milo.opcua.stack.server.UaStackServerConfig;
import org.eclipse.milo.opcua.stack.server.security.ServerCertificateValidator;
import org.jetbrains.annotations.Nullable;

public class UaStackServerConfigBuilder {
    private Set<EndpointConfiguration> endpoints = new HashSet<EndpointConfiguration>();
    private LocalizedText applicationName = LocalizedText.english((String)"server application name not configured");
    private String applicationUri = "server application uri not configured";
    private String productUri = "server product uri not configured";
    private EncodingLimits encodingLimits = EncodingLimits.DEFAULT;
    private UInteger minimumSecureChannelLifetime = Unsigned.uint((int)60000);
    private UInteger maximumSecureChannelLifetime = Unsigned.uint((int)86400000);
    private CertificateManager certificateManager;
    private TrustListManager trustListManager;
    private ServerCertificateValidator certificateValidator;
    private KeyPair httpsKeyPair;
    private X509Certificate[] httpsCertificate;
    private ExecutorService executor;

    public UaStackServerConfigBuilder setEndpoints(Set<EndpointConfiguration> endpointConfigurations) {
        this.endpoints = endpointConfigurations;
        return this;
    }

    public UaStackServerConfigBuilder setApplicationName(LocalizedText applicationName) {
        this.applicationName = applicationName;
        return this;
    }

    public UaStackServerConfigBuilder setApplicationUri(String applicationUri) {
        this.applicationUri = applicationUri;
        return this;
    }

    public UaStackServerConfigBuilder setProductUri(String productUri) {
        this.productUri = productUri;
        return this;
    }

    public UaStackServerConfigBuilder setEncodingLimits(EncodingLimits encodingLimits) {
        this.encodingLimits = encodingLimits;
        return this;
    }

    public UaStackServerConfigBuilder setMinimumSecureChannelLifetime(UInteger minimumSecureChannelLifetime) {
        this.minimumSecureChannelLifetime = minimumSecureChannelLifetime;
        return this;
    }

    public UaStackServerConfigBuilder setMaximumSecureChannelLifetime(UInteger maximumSecureChannelLifetime) {
        this.maximumSecureChannelLifetime = maximumSecureChannelLifetime;
        return this;
    }

    public UaStackServerConfigBuilder setCertificateManager(CertificateManager certificateManager) {
        this.certificateManager = certificateManager;
        return this;
    }

    public UaStackServerConfigBuilder setTrustListManager(TrustListManager trustListManager) {
        this.trustListManager = trustListManager;
        return this;
    }

    public UaStackServerConfigBuilder setCertificateValidator(ServerCertificateValidator certificateValidator) {
        this.certificateValidator = certificateValidator;
        return this;
    }

    public UaStackServerConfigBuilder setHttpsKeyPair(KeyPair httpsKeyPair) {
        this.httpsKeyPair = httpsKeyPair;
        return this;
    }

    public UaStackServerConfigBuilder setHttpsCertificateChain(X509Certificate[] httpsCertificate) {
        this.httpsCertificate = httpsCertificate;
        return this;
    }

    @Deprecated
    public UaStackServerConfigBuilder setHttpsCertificate(X509Certificate httpsCertificate) {
        this.httpsCertificate = new X509Certificate[]{httpsCertificate};
        return this;
    }

    public UaStackServerConfigBuilder setExecutor(ExecutorService executor) {
        this.executor = executor;
        return this;
    }

    public UaStackServerConfig build() {
        if (this.executor == null) {
            this.executor = Stack.sharedExecutor();
        }
        return new UaStackServerConfigImpl(this.endpoints, this.applicationName, this.applicationUri, this.productUri, this.encodingLimits, this.minimumSecureChannelLifetime, this.maximumSecureChannelLifetime, this.certificateManager, this.trustListManager, this.certificateValidator, this.httpsKeyPair, this.httpsCertificate, this.executor);
    }

    private static class UaStackServerConfigImpl
    implements UaStackServerConfig {
        private final Set<EndpointConfiguration> endpointConfigurations;
        private final LocalizedText applicationName;
        private final String applicationUri;
        private final String productUri;
        private final EncodingLimits encodingLimits;
        private final UInteger minimumSecureChannelLifetime;
        private final UInteger maximumSecureChannelLifetime;
        private final CertificateManager certificateManager;
        private final ServerCertificateValidator certificateValidator;
        private final TrustListManager trustListManager;
        private final KeyPair httpsKeyPair;
        private final X509Certificate[] httpsCertificate;
        private final ExecutorService executor;

        UaStackServerConfigImpl(Set<EndpointConfiguration> endpointConfigurations, LocalizedText applicationName, String applicationUri, String productUri, EncodingLimits encodingLimits, UInteger minimumSecureChannelLifetime, UInteger maximumSecureChannelLifetime, CertificateManager certificateManager, TrustListManager trustListManager, ServerCertificateValidator certificateValidator, @Nullable KeyPair httpsKeyPair, @Nullable X509Certificate[] httpsCertificate, ExecutorService executor) {
            this.endpointConfigurations = endpointConfigurations;
            this.applicationName = applicationName;
            this.applicationUri = applicationUri;
            this.productUri = productUri;
            this.encodingLimits = encodingLimits;
            this.minimumSecureChannelLifetime = minimumSecureChannelLifetime;
            this.maximumSecureChannelLifetime = maximumSecureChannelLifetime;
            this.trustListManager = trustListManager;
            this.certificateManager = certificateManager;
            this.certificateValidator = certificateValidator;
            this.httpsKeyPair = httpsKeyPair;
            this.httpsCertificate = httpsCertificate;
            this.executor = executor;
        }

        @Override
        public Set<EndpointConfiguration> getEndpoints() {
            return this.endpointConfigurations;
        }

        @Override
        public LocalizedText getApplicationName() {
            return this.applicationName;
        }

        @Override
        public String getApplicationUri() {
            return this.applicationUri;
        }

        @Override
        public String getProductUri() {
            return this.productUri;
        }

        @Override
        public EncodingLimits getEncodingLimits() {
            return this.encodingLimits;
        }

        @Override
        public UInteger getMinimumSecureChannelLifetime() {
            return this.minimumSecureChannelLifetime;
        }

        @Override
        public UInteger getMaximumSecureChannelLifetime() {
            return this.maximumSecureChannelLifetime;
        }

        @Override
        public CertificateManager getCertificateManager() {
            return this.certificateManager;
        }

        @Override
        public TrustListManager getTrustListManager() {
            return this.trustListManager;
        }

        @Override
        public ServerCertificateValidator getCertificateValidator() {
            return this.certificateValidator;
        }

        @Override
        public Optional<KeyPair> getHttpsKeyPair() {
            return Optional.ofNullable(this.httpsKeyPair);
        }

        @Override
        public Optional<X509Certificate[]> getHttpsCertificateChain() {
            return Optional.ofNullable(this.httpsCertificate);
        }

        @Override
        public ExecutorService getExecutor() {
            return this.executor;
        }
    }
}

