/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.commons.service.metric;

import java.text.SimpleDateFormat;
import java.util.Date;
import org.apache.iotdb.commons.service.metric.JvmGcMonitorMetrics;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GcTimeAlerter
implements JvmGcMonitorMetrics.GcTimeAlertHandler {
    private static final SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    private static final Logger logger = LoggerFactory.getLogger(GcTimeAlerter.class);

    @Override
    public void alert(JvmGcMonitorMetrics.GcData gcData) {
        logger.warn("Error metrics taken time: " + sdf.format(new Date(Long.parseLong(String.valueOf(gcData.getTimestamp())))));
        logger.warn("Gc Time Percentage: " + gcData.getGcTimePercentage() + "%");
        logger.warn("Accumulated GC time within current observation window: " + gcData.getGcTimeWithinObsWindow() + " ms");
        logger.warn("The observation window is from: " + sdf.format(new Date(Long.parseLong(String.valueOf(gcData.getStartObsWindowTs())))) + " to: " + sdf.format(new Date(Long.parseLong(String.valueOf(gcData.getTimestamp())))));
        logger.warn("The observation window time is: " + gcData.getCurrentObsWindowTs() + " ms.");
    }
}

