/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kms.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum MacAlgorithmSpec {
    HMAC_SHA_224("HMAC_SHA_224"),
    HMAC_SHA_256("HMAC_SHA_256"),
    HMAC_SHA_384("HMAC_SHA_384"),
    HMAC_SHA_512("HMAC_SHA_512"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, MacAlgorithmSpec> VALUE_MAP;
    private final String value;

    private MacAlgorithmSpec(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static MacAlgorithmSpec fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<MacAlgorithmSpec> knownValues() {
        EnumSet<MacAlgorithmSpec> knownValues = EnumSet.allOf(MacAlgorithmSpec.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(MacAlgorithmSpec.class, MacAlgorithmSpec::toString);
    }
}

