/*
 * Decompiled with CFR 0.152.
 */
package org.apache.polaris.core.admin.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModelProperty;
import jakarta.validation.constraints.NotNull;
import java.util.Objects;
import org.apache.polaris.core.admin.model.CatalogGrant;
import org.apache.polaris.core.admin.model.NamespaceGrant;
import org.apache.polaris.core.admin.model.PolicyGrant;
import org.apache.polaris.core.admin.model.TableGrant;
import org.apache.polaris.core.admin.model.ViewGrant;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.EXISTING_PROPERTY, property="type", visible=true)
@JsonSubTypes(value={@JsonSubTypes.Type(value=CatalogGrant.class, name="catalog"), @JsonSubTypes.Type(value=NamespaceGrant.class, name="namespace"), @JsonSubTypes.Type(value=PolicyGrant.class, name="policy"), @JsonSubTypes.Type(value=TableGrant.class, name="table"), @JsonSubTypes.Type(value=ViewGrant.class, name="view")})
public class GrantResource {
    @NotNull
    private final TypeEnum type;

    @ApiModelProperty(required=true, value="")
    @JsonProperty(value="type", required=true)
    public TypeEnum getType() {
        return this.type;
    }

    @JsonCreator
    public GrantResource(@JsonProperty(value="type", required=true) TypeEnum type) {
        this.type = type;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GrantResource grantResource = (GrantResource)o;
        return Objects.equals((Object)this.type, (Object)grantResource.type);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.type});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class GrantResource {\n");
        sb.append("    type: ").append(this.toIndentedString((Object)this.type)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum TypeEnum {
        CATALOG("catalog"),
        NAMESPACE("namespace"),
        TABLE("table"),
        VIEW("view"),
        POLICY("policy");

        private String value;

        private TypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    public static final class Builder {
        private TypeEnum type;

        private Builder() {
        }

        private Builder(TypeEnum type) {
            this.type = type;
        }

        public Builder setType(TypeEnum type) {
            this.type = type;
            return this;
        }

        public GrantResource build() {
            GrantResource inst = new GrantResource(this.type);
            return inst;
        }
    }
}

