/*
 * Decompiled with CFR 0.152.
 */
package org.apache.polaris.core.connection;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.MoreObjects;
import jakarta.annotation.Nonnull;
import java.util.Map;
import org.apache.polaris.core.admin.model.AuthenticationParameters;
import org.apache.polaris.core.admin.model.BearerAuthenticationParameters;
import org.apache.polaris.core.connection.AuthenticationParametersDpo;
import org.apache.polaris.core.connection.AuthenticationType;
import org.apache.polaris.core.secrets.SecretReference;
import org.apache.polaris.core.secrets.UserSecretsManager;

public class BearerAuthenticationParametersDpo
extends AuthenticationParametersDpo {
    @JsonProperty(value="bearerTokenReference")
    private final SecretReference bearerTokenReference;

    public BearerAuthenticationParametersDpo(@JsonProperty(value="bearerTokenReference", required=true) @Nonnull SecretReference bearerTokenReference) {
        super(AuthenticationType.BEARER.getCode());
        this.bearerTokenReference = bearerTokenReference;
    }

    @Nonnull
    public SecretReference getBearerTokenReference() {
        return this.bearerTokenReference;
    }

    @Override
    @Nonnull
    public Map<String, String> asIcebergCatalogProperties(UserSecretsManager secretsManager) {
        String bearerToken = secretsManager.readSecret(this.getBearerTokenReference());
        return Map.of("token", bearerToken);
    }

    @Override
    @Nonnull
    public AuthenticationParameters asAuthenticationParametersModel() {
        return BearerAuthenticationParameters.builder().setAuthenticationType(AuthenticationParameters.AuthenticationTypeEnum.BEARER).build();
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("authenticationTypeCode", this.getAuthenticationTypeCode()).add("bearerTokenReference", (Object)this.getBearerTokenReference()).toString();
    }
}

