var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
var __rest = (this && this.__rest) || function (s, e) {
    var t = {};
    for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p) && e.indexOf(p) < 0)
        t[p] = s[p];
    if (s != null && typeof Object.getOwnPropertySymbols === "function")
        for (var i = 0, p = Object.getOwnPropertySymbols(s); i < p.length; i++) {
            if (e.indexOf(p[i]) < 0 && Object.prototype.propertyIsEnumerable.call(s, p[i]))
                t[p[i]] = s[p[i]];
        }
    return t;
};
import { enableMapSet } from "immer";
import { create } from "zustand";
import { immer } from "zustand/middleware/immer";
import { normalize } from "../normalization/normalize";
import { computeAllFeelVariableUniqueNames } from "./computed/computeAllFeelVariableUniqueNames";
import { computeDataTypes } from "./computed/computeDataTypes";
import { computeDiagramData } from "./computed/computeDiagramData";
import { computeExternalModelsByType } from "./computed/computeExternalModelsByType";
import { computeImportsByNamespace } from "./computed/computeImportsByNamespace";
import { computeIndexedDrd } from "./computed/computeIndexes";
import { computeIsDropTargetNodeValidForSelection } from "./computed/computeIsDropTargetNodeValidForSelection";
enableMapSet();
export var DiagramLhsPanel;
(function (DiagramLhsPanel) {
    DiagramLhsPanel["NONE"] = "NONE";
    DiagramLhsPanel["DRD_SELECTOR"] = "DRD_SELECTOR";
    DiagramLhsPanel["DRG_NODES"] = "DRG_NODES";
    DiagramLhsPanel["EXTERNAL_NODES"] = "EXTERNAL_NODES";
})(DiagramLhsPanel || (DiagramLhsPanel = {}));
export var DmnEditorTab;
(function (DmnEditorTab) {
    DmnEditorTab[DmnEditorTab["EDITOR"] = 0] = "EDITOR";
    DmnEditorTab[DmnEditorTab["DATA_TYPES"] = 1] = "DATA_TYPES";
    DmnEditorTab[DmnEditorTab["INCLUDED_MODELS"] = 2] = "INCLUDED_MODELS";
})(DmnEditorTab || (DmnEditorTab = {}));
export var defaultStaticState = function () { return ({
    boxedExpressionEditor: {
        activeDrgElementId: undefined,
        selectedObjectId: undefined,
        propertiesPanel: {
            isOpen: false,
        },
    },
    navigation: {
        tab: DmnEditorTab.EDITOR,
    },
    focus: {
        consumableId: undefined,
    },
    dataTypesEditor: {
        activeItemDefinitionId: undefined,
        expandedItemComponentIds: [],
    },
    diagram: {
        autoLayout: {
            canAutoGenerateDrd: false,
        },
        __unsafeDrdIndex: 0,
        edgeIdBeingUpdated: undefined,
        dropTargetNode: undefined,
        ongoingConnection: undefined,
        propertiesPanel: {
            isOpen: false,
            elementId: undefined,
        },
        overlaysPanel: {
            isOpen: false,
        },
        openLhsPanel: DiagramLhsPanel.NONE,
        overlays: {
            enableNodeHierarchyHighlight: false,
            enableExecutionHitsHighlights: false,
            enableCustomNodeStyles: true,
            enableDataTypesToolbarOnNodes: true,
        },
        snapGrid: {
            isEnabled: true,
            x: 20,
            y: 20,
        },
        _selectedNodes: [],
        _selectedEdges: [],
        draggingNodes: [],
        resizingNodes: [],
        draggingWaypoints: [],
        movingDividerLines: [],
        isEditingStyle: false,
    },
}); };
export function createDmnEditorStore(model, computedCache) {
    var _a = defaultStaticState(), diagram = _a.diagram, defaultState = __rest(_a, ["diagram"]);
    return create(immer(function () {
        var _a;
        return (__assign(__assign({ dmn: {
                model: normalize(model),
            } }, defaultState), { diagram: __assign(__assign({}, diagram), { autoLayout: {
                    canAutoGenerateDrd: ((_a = model.definitions["dmndi:DMNDI"]) === null || _a === void 0 ? void 0 : _a["dmndi:DMNDiagram"]) === undefined &&
                        model.definitions.drgElement !== undefined,
                } }), dispatch: function (s) {
                return {
                    dmn: {
                        reset: function () {
                            s.diagram._selectedNodes = [];
                            s.diagram.draggingNodes = [];
                            s.diagram.resizingNodes = [];
                            s.navigation.tab = DmnEditorTab.EDITOR;
                            s.boxedExpressionEditor.activeDrgElementId = undefined;
                            s.boxedExpressionEditor.selectedObjectId = undefined;
                        },
                    },
                    boxedExpressionEditor: {
                        open: function (id) {
                            s.boxedExpressionEditor.activeDrgElementId = id;
                            s.boxedExpressionEditor.selectedObjectId = undefined;
                            s.boxedExpressionEditor.propertiesPanel.isOpen = s.diagram.propertiesPanel.isOpen;
                        },
                        close: function () {
                            s.diagram.propertiesPanel.isOpen = s.boxedExpressionEditor.propertiesPanel.isOpen;
                            s.boxedExpressionEditor.activeDrgElementId = undefined;
                            s.boxedExpressionEditor.selectedObjectId = undefined;
                        },
                    },
                    diagram: {
                        setNodeStatus: function (nodeId, newStatus) {
                            if (newStatus.selected !== undefined) {
                                if (newStatus.selected) {
                                    s.diagram._selectedNodes.push(nodeId);
                                }
                                else {
                                    s.diagram._selectedNodes = s.diagram._selectedNodes.filter(function (s) { return s !== nodeId; });
                                }
                            }
                            if (newStatus.dragging !== undefined) {
                                if (newStatus.dragging) {
                                    s.diagram.draggingNodes.push(nodeId);
                                }
                                else {
                                    s.diagram.draggingNodes = s.diagram.draggingNodes.filter(function (s) { return s !== nodeId; });
                                }
                            }
                            if (newStatus.resizing !== undefined) {
                                if (newStatus.resizing) {
                                    s.diagram.resizingNodes.push(nodeId);
                                }
                                else {
                                    s.diagram.resizingNodes = s.diagram.resizingNodes.filter(function (s) { return s !== nodeId; });
                                }
                            }
                        },
                        setEdgeStatus: function (edgeId, newStatus) {
                            if (newStatus.selected !== undefined) {
                                if (newStatus.selected) {
                                    s.diagram._selectedEdges.push(edgeId);
                                }
                                else {
                                    s.diagram._selectedEdges = s.diagram._selectedEdges.filter(function (s) { return s !== edgeId; });
                                }
                            }
                            if (newStatus.draggingWaypoint !== undefined) {
                                if (newStatus.draggingWaypoint) {
                                    s.diagram.draggingWaypoints.push(edgeId);
                                }
                                else {
                                    s.diagram.draggingWaypoints = s.diagram.draggingWaypoints.filter(function (s) { return s !== edgeId; });
                                }
                            }
                        },
                        setDividerLineStatus: function (decisionServiceId, newStatus) {
                            if (newStatus.moving !== undefined) {
                                if (newStatus.moving) {
                                    s.diagram.movingDividerLines.push(decisionServiceId);
                                }
                                else {
                                    s.diagram.movingDividerLines = s.diagram.movingDividerLines.filter(function (s) { return s !== decisionServiceId; });
                                }
                            }
                        },
                    },
                };
            }, computed: function (s) {
                return {
                    isDiagramEditingInProgress: function () {
                        return computedCache.cached("isDiagramEditingInProgress", function (draggingNodesCount, resizingNodesCount, draggingWaypointsCount, movingDividerLinesCount, isisEditingStyle) {
                            return draggingNodesCount > 0 ||
                                resizingNodesCount > 0 ||
                                draggingWaypointsCount > 0 ||
                                movingDividerLinesCount > 0 ||
                                isisEditingStyle;
                        }, [
                            s.diagram.draggingNodes.length,
                            s.diagram.resizingNodes.length,
                            s.diagram.draggingWaypoints.length,
                            s.diagram.movingDividerLines.length,
                            s.diagram.isEditingStyle,
                        ]);
                    },
                    indexedDrd: function () {
                        return computedCache.cached("indexedDrd", computeIndexedDrd, [
                            s.dmn.model.definitions["@_namespace"],
                            s.dmn.model.definitions,
                            s.computed(s).getDrdIndex(),
                        ]);
                    },
                    importsByNamespace: function () {
                        return computedCache.cached("importsByNamespace", computeImportsByNamespace, [
                            s.dmn.model.definitions.import,
                        ]);
                    },
                    isAlternativeInputDataShape: function () {
                        var _a;
                        return computedCache.cached("isAlternativeInputDataShape", function (drdIndex, dmnDiagram) { var _a, _b; return (_b = (_a = dmnDiagram === null || dmnDiagram === void 0 ? void 0 : dmnDiagram[drdIndex]) === null || _a === void 0 ? void 0 : _a["@_useAlternativeInputDataShape"]) !== null && _b !== void 0 ? _b : false; }, [s.computed(s).getDrdIndex(), (_a = s.dmn.model.definitions["dmndi:DMNDI"]) === null || _a === void 0 ? void 0 : _a["dmndi:DMNDiagram"]]);
                    },
                    isDropTargetNodeValidForSelection: function (externalModelsByNamespace) {
                        return computedCache.cached("isDropTargetNodeValidForSelection", computeIsDropTargetNodeValidForSelection, [
                            s.diagram.dropTargetNode,
                            s.computed(s).getDiagramData(externalModelsByNamespace),
                        ]);
                    },
                    getDrdIndex: function () {
                        var _a;
                        return computedCache.cached("getDrdIndex", function (__unsafeDrdIndex, dmnDiagram) {
                            return (dmnDiagram === null || dmnDiagram === void 0 ? void 0 : dmnDiagram.length) && __unsafeDrdIndex > dmnDiagram.length - 1
                                ? dmnDiagram.length - 1
                                : __unsafeDrdIndex;
                        }, [s.diagram.__unsafeDrdIndex, (_a = s.dmn.model.definitions["dmndi:DMNDI"]) === null || _a === void 0 ? void 0 : _a["dmndi:DMNDiagram"]]);
                    },
                    getDataTypes: function (externalModelsByNamespace) {
                        return computedCache.cached("getDataTypes", computeDataTypes, [
                            s.dmn.model.definitions["@_namespace"],
                            s.dmn.model.definitions.itemDefinition,
                            s.computed(s).getExternalModelTypesByNamespace(externalModelsByNamespace),
                            s.computed(s).importsByNamespace(),
                        ]);
                    },
                    getAllFeelVariableUniqueNames: function () {
                        return computedCache.cached("getAllFeelVariableUniqueNames", computeAllFeelVariableUniqueNames, [
                            s.dmn.model.definitions.drgElement,
                            s.dmn.model.definitions.import,
                        ]);
                    },
                    getExternalModelTypesByNamespace: function (externalModelsByNamespace) {
                        return computedCache.cached("getExternalModelTypesByNamespace", computeExternalModelsByType, [
                            s.dmn.model.definitions.import,
                            externalModelsByNamespace,
                        ]);
                    },
                    getDiagramData: function (externalModelsByNamespace) {
                        return computedCache.cached("getDiagramData", computeDiagramData, [
                            s.diagram,
                            s.dmn.model.definitions,
                            s.computed(s).getExternalModelTypesByNamespace(externalModelsByNamespace),
                            s.computed(s).indexedDrd(),
                            s.computed(s).isAlternativeInputDataShape(),
                        ]);
                    },
                };
            } }));
    }));
}
//# sourceMappingURL=Store.js.map