var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
import { jsx as _jsx, Fragment as _Fragment, jsxs as _jsxs } from "react/jsx-runtime";
import { useCallback, useMemo } from "react";
import { DescriptionField, NameField, TypeRefField } from "./Fields";
import { useDmnEditorStore, useDmnEditorStoreApi } from "../../store/StoreContext";
import { ClipboardCopy } from "@patternfly/react-core/dist/js/components/ClipboardCopy";
import { FormGroup } from "@patternfly/react-core/dist/js/components/Form";
import { useDmnEditor } from "../../DmnEditorContext";
import { ConstraintsFromTypeConstraintAttribute } from "../../dataTypes/Constraints";
import { useExternalModels } from "../../includedModels/DmnEditorDependenciesContext";
export function InformationItemCell(props) {
    var _a, _b, _c, _d;
    var dmnEditorStoreApi = useDmnEditorStoreApi();
    var selectedObjectId = useDmnEditorStore(function (s) { return s.boxedExpressionEditor.selectedObjectId; });
    var externalModelsByNamespace = useExternalModels().externalModelsByNamespace;
    var dmnEditorRootElementRef = useDmnEditor().dmnEditorRootElementRef;
    var selectedObjectInfos = useMemo(function () { var _a; return (_a = props.boxedExpressionIndex) === null || _a === void 0 ? void 0 : _a.get(selectedObjectId !== null && selectedObjectId !== void 0 ? selectedObjectId : ""); }, [props.boxedExpressionIndex, selectedObjectId]);
    var cell = useMemo(function () { return selectedObjectInfos === null || selectedObjectInfos === void 0 ? void 0 : selectedObjectInfos.cell; }, [selectedObjectInfos === null || selectedObjectInfos === void 0 ? void 0 : selectedObjectInfos.cell]);
    var itemDefinition = useMemo(function () {
        var _a, _b, _c;
        var _d = dmnEditorStoreApi
            .getState()
            .computed(dmnEditorStoreApi.getState())
            .getDataTypes(externalModelsByNamespace), allDataTypesById = _d.allDataTypesById, allTopLevelItemDefinitionUniqueNames = _d.allTopLevelItemDefinitionUniqueNames;
        return (_c = allDataTypesById.get((_b = allTopLevelItemDefinitionUniqueNames.get((_a = cell === null || cell === void 0 ? void 0 : cell["@_typeRef"]) !== null && _a !== void 0 ? _a : "")) !== null && _b !== void 0 ? _b : "")) === null || _c === void 0 ? void 0 : _c.itemDefinition;
    }, [cell, dmnEditorStoreApi, externalModelsByNamespace]);
    var getAllUniqueNames = useCallback(function (s) { return new Map(); }, []);
    return (_jsxs(_Fragment, { children: [_jsx(FormGroup, __assign({ label: "ID" }, { children: _jsx(ClipboardCopy, __assign({ isReadOnly: true, hoverTip: "Copy", clickTip: "Copied" }, { children: selectedObjectId })) })), _jsx(NameField, { isReadonly: props.isReadonly, id: cell["@_id"], name: (_a = cell["@_name"]) !== null && _a !== void 0 ? _a : "", getAllUniqueNames: getAllUniqueNames, onChange: props.onNameChange }), _jsx(TypeRefField, { isReadonly: props.isReadonly, typeRef: cell["@_typeRef"], dmnEditorRootElementRef: dmnEditorRootElementRef, onChange: props.onTypeRefChange }), itemDefinition && (_jsx(FormGroup, __assign({ label: "Constraint" }, { children: _jsx(ConstraintsFromTypeConstraintAttribute, { isReadonly: true, itemDefinition: itemDefinition, editItemDefinition: function () { }, renderOnPropertiesPanel: true, defaultsToAllowedValues: true }) }))), _jsx(DescriptionField, { isReadonly: props.isReadonly, initialValue: (_c = (_b = cell.description) === null || _b === void 0 ? void 0 : _b.__$$text) !== null && _c !== void 0 ? _c : "", expressionPath: (_d = selectedObjectInfos === null || selectedObjectInfos === void 0 ? void 0 : selectedObjectInfos.expressionPath) !== null && _d !== void 0 ? _d : [], onChange: props.onDescriptionChange })] }));
}
//# sourceMappingURL=InformationItemCell.js.map