var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
var __read = (this && this.__read) || function (o, n) {
    var m = typeof Symbol === "function" && o[Symbol.iterator];
    if (!m) return o;
    var i = m.call(o), r, ar = [], e;
    try {
        while ((n === void 0 || n-- > 0) && !(r = i.next()).done) ar.push(r.value);
    }
    catch (error) { e = { error: error }; }
    finally {
        try {
            if (r && !r.done && (m = i["return"])) m.call(i);
        }
        finally { if (e) throw e.error; }
    }
    return ar;
};
import { jsx as _jsx, jsxs as _jsxs, Fragment as _Fragment } from "react/jsx-runtime";
import { useCallback, useEffect, useMemo, useState } from "react";
import { ConstraintsExpression } from "./ConstraintsExpression";
import { DmnBuiltInDataType, generateUuid } from "@kie-tools/boxed-expression-component/dist/api";
import { ConstraintsEnum, isEnum } from "./ConstraintsEnum";
import { ConstraintsRange, isRange } from "./ConstraintsRange";
import { ToggleGroup, ToggleGroupItem } from "@patternfly/react-core/dist/js/components/ToggleGroup";
import { constrainableBuiltInFeelTypes, isCollection, isStruct } from "./DataTypeSpec";
import moment from "moment";
import { TextInput } from "@patternfly/react-core/dist/js/components/TextInput";
import { ConstraintDate } from "./ConstraintComponents/ConstraintDate";
import { ConstraintDateTime } from "./ConstraintComponents/ConstraintDateTime";
import { ConstraintDateTimeDuration, REGEX_DATE_TIME_DURATION, } from "./ConstraintComponents/ConstraintDateTimeDuration";
import { ConstraintTime } from "./ConstraintComponents/ConstraintTime";
import { ConstraintYearsMonthsDuration, REGEX_YEARS_MONTH_DURATION, } from "./ConstraintComponents/ConstraintYearsMonthsDuration";
import { invalidInlineFeelNameStyle } from "../feel/InlineFeelNameInput";
import { useDmnEditorStore } from "../store/StoreContext";
import { useExternalModels } from "../includedModels/DmnEditorDependenciesContext";
import { builtInFeelTypeNames } from "./BuiltInFeelTypes";
var ConstraintsType;
(function (ConstraintsType) {
    ConstraintsType["ENUMERATION"] = "Enumeration";
    ConstraintsType["EXPRESSION"] = "Expression";
    ConstraintsType["RANGE"] = "Range";
    ConstraintsType["NONE"] = "None";
})(ConstraintsType || (ConstraintsType = {}));
export function recursivelyGetRootItemDefinition(itemDefinition, allDataTypesById, allTopLevelItemDefinitionUniqueNames) {
    var _a, _b;
    var typeRef = (_a = itemDefinition.typeRef) === null || _a === void 0 ? void 0 : _a.__$$text;
    if (builtInFeelTypeNames.has(typeRef) === false) {
        var parentDataType = allDataTypesById.get((_b = allTopLevelItemDefinitionUniqueNames.get(typeRef)) !== null && _b !== void 0 ? _b : "");
        if (parentDataType !== undefined && isCollection(parentDataType.itemDefinition)) {
            return parentDataType.itemDefinition;
        }
        else if (parentDataType !== undefined) {
            return recursivelyGetRootItemDefinition(parentDataType.itemDefinition, allDataTypesById, allTopLevelItemDefinitionUniqueNames);
        }
        return itemDefinition;
    }
    return itemDefinition;
}
export var constraintTypeHelper = function (itemDefinition, allDataTypesById, allTopLevelItemDefinitionUniqueNames) {
    var _a, _b, _c;
    var typeRef = (_c = (allDataTypesById !== undefined && allTopLevelItemDefinitionUniqueNames !== undefined
        ? (_a = recursivelyGetRootItemDefinition(itemDefinition, allDataTypesById, allTopLevelItemDefinitionUniqueNames).typeRef) === null || _a === void 0 ? void 0 : _a.__$$text
        : (_b = itemDefinition.typeRef) === null || _b === void 0 ? void 0 : _b.__$$text)) !== null && _c !== void 0 ? _c : DmnBuiltInDataType.Undefined;
    var typeHelper = {
        check: function (value, type) {
            var recoveredValue = typeHelper.recover(value);
            switch (type !== null && type !== void 0 ? type : typeRef) {
                case DmnBuiltInDataType.Any:
                    return true;
                case DmnBuiltInDataType.String:
                    if (recoveredValue === "") {
                        return true;
                    }
                    if (typeHelper.check(value, DmnBuiltInDataType.Date)) {
                        return false;
                    }
                    if (typeHelper.check(value, DmnBuiltInDataType.DateTime)) {
                        return false;
                    }
                    if (typeHelper.check(value, DmnBuiltInDataType.DateTimeDuration)) {
                        return false;
                    }
                    if (typeHelper.check(value, DmnBuiltInDataType.Time)) {
                        return false;
                    }
                    if (typeHelper.check(value, DmnBuiltInDataType.YearsMonthsDuration)) {
                        return false;
                    }
                    return typeof recoveredValue === "string";
                case DmnBuiltInDataType.Date:
                    return moment(recoveredValue, "YYYY-MM-DD", true).isValid() || value === "" || recoveredValue === "";
                case DmnBuiltInDataType.DateTime:
                    return (moment(recoveredValue, "YYYY-MM-DDTHH:mm:ssZZ", true).isValid() ||
                        moment(recoveredValue, "YYYY-MM-DDTHH:mmZZ", true).isValid() ||
                        moment(recoveredValue, "YYYY-MM-DD", true).isValid() ||
                        value === "" ||
                        recoveredValue === "");
                case DmnBuiltInDataType.DateTimeDuration:
                    return REGEX_DATE_TIME_DURATION.test(recoveredValue !== null && recoveredValue !== void 0 ? recoveredValue : "") || value === "" || recoveredValue === "";
                case DmnBuiltInDataType.Number:
                    return !isNaN(parseFloat(recoveredValue !== null && recoveredValue !== void 0 ? recoveredValue : "")) || value === "" || recoveredValue === "";
                case DmnBuiltInDataType.Time:
                    return (moment(recoveredValue, "HH:mmZZ", true).isValid() ||
                        moment(recoveredValue, "HH:mm:ssZZ", true).isValid() ||
                        value === "" ||
                        recoveredValue === "");
                case DmnBuiltInDataType.YearsMonthsDuration:
                    return REGEX_YEARS_MONTH_DURATION.test(recoveredValue !== null && recoveredValue !== void 0 ? recoveredValue : "") || value === "" || recoveredValue === "";
                default:
                    return false;
            }
        },
        parse: function (value) {
            var recoveredValue = typeHelper.recover(value);
            switch (typeRef) {
                case DmnBuiltInDataType.Number:
                    return parseFloat(recoveredValue !== null && recoveredValue !== void 0 ? recoveredValue : "");
                case DmnBuiltInDataType.DateTimeDuration:
                case DmnBuiltInDataType.YearsMonthsDuration:
                    return moment.duration(recoveredValue);
                case DmnBuiltInDataType.DateTime:
                    return moment(recoveredValue).toDate();
                case DmnBuiltInDataType.Date:
                case DmnBuiltInDataType.String:
                case DmnBuiltInDataType.Time:
                default:
                    return recoveredValue;
            }
        },
        transform: function (value) {
            switch (typeRef) {
                case DmnBuiltInDataType.Any:
                case DmnBuiltInDataType.String:
                    return JSON.stringify(value);
                case DmnBuiltInDataType.Date:
                    return "date(\"".concat(value, "\")");
                case DmnBuiltInDataType.DateTime:
                    return "date and time(\"".concat(value, "\")");
                case DmnBuiltInDataType.DateTimeDuration:
                case DmnBuiltInDataType.YearsMonthsDuration:
                    return "duration(\"".concat(value, "\")");
                case DmnBuiltInDataType.Number:
                    return "".concat(value);
                case DmnBuiltInDataType.Time:
                    return "time(\"".concat(value, "\")");
                default:
                    return value;
            }
        },
        recover: function (value) {
            if (value === undefined) {
                return undefined;
            }
            switch (typeRef) {
                case DmnBuiltInDataType.Any:
                    if (value === "") {
                        return "";
                    }
                    try {
                        return "".concat(JSON.parse(value));
                    }
                    catch (error) {
                        return undefined;
                    }
                case DmnBuiltInDataType.String:
                    if (value === "") {
                        return "";
                    }
                    try {
                        if (typeof JSON.parse(value) !== "string") {
                            return undefined;
                        }
                        return "".concat(JSON.parse(value));
                    }
                    catch (error) {
                        return undefined;
                    }
                case DmnBuiltInDataType.Date:
                    return value.replace('date("', "").replace('")', "");
                case DmnBuiltInDataType.DateTime:
                    return value.replace('date and time("', "").replace('")', "");
                case DmnBuiltInDataType.DateTimeDuration:
                    return value.replace('duration("', "").replace('")', "");
                case DmnBuiltInDataType.Number:
                    return "".concat(value);
                case DmnBuiltInDataType.Time:
                    return value.replace('time("', "").replace('")', "");
                case DmnBuiltInDataType.YearsMonthsDuration:
                    return value.replace('duration("', "").replace('")', "");
                default:
                    return "".concat(value);
            }
        },
        component: function (props) {
            switch (typeRef) {
                case DmnBuiltInDataType.Date:
                    return _jsx(ConstraintDate, __assign({}, props));
                case DmnBuiltInDataType.DateTime:
                    return _jsx(ConstraintDateTime, __assign({}, props));
                case DmnBuiltInDataType.DateTimeDuration:
                    return _jsx(ConstraintDateTimeDuration, __assign({}, props));
                case DmnBuiltInDataType.Time:
                    return _jsx(ConstraintTime, __assign({}, props));
                case DmnBuiltInDataType.YearsMonthsDuration:
                    return _jsx(ConstraintYearsMonthsDuration, __assign({}, props));
                case DmnBuiltInDataType.Number:
                    return (_jsx(TextInput, { autoFocus: props.autoFocus, onChange: props.onChange, id: props.id, isDisabled: props.isDisabled, value: props.value, onKeyDown: props.onKeyDown, style: __assign(__assign({}, props.style), (props.isValid ? {} : invalidInlineFeelNameStyle)), type: "number" }));
                case DmnBuiltInDataType.Any:
                case DmnBuiltInDataType.String:
                default:
                    return (_jsx(TextInput, { autoFocus: props.autoFocus, onChange: props.onChange, id: props.id, isDisabled: props.isDisabled, value: props.value, onKeyDown: props.onKeyDown, style: __assign(__assign({}, props.style), (props.isValid ? {} : invalidInlineFeelNameStyle)), type: "text" }));
            }
        },
    };
    return typeHelper;
};
export function useConstraint(_a) {
    var constraint = _a.constraint, itemDefinition = _a.itemDefinition, isCollectionConstraintEnabled = _a.isCollectionConstraintEnabled, constraintTypeHelper = _a.constraintTypeHelper, enabledConstraints = _a.enabledConstraints;
    var constraintValue = constraint === null || constraint === void 0 ? void 0 : constraint.text.__$$text;
    var kieConstraintType = constraint === null || constraint === void 0 ? void 0 : constraint["@_kie:constraintType"];
    var isConstraintEnum = useMemo(function () {
        return isCollection(itemDefinition) === true && isCollectionConstraintEnabled === true
            ? undefined
            : isEnum(constraintValue, constraintTypeHelper.check);
    }, [constraintTypeHelper.check, constraintValue, isCollectionConstraintEnabled, itemDefinition]);
    var isConstraintRange = useMemo(function () {
        return isCollection(itemDefinition) === true && isCollectionConstraintEnabled === true
            ? undefined
            : isRange(constraintValue, constraintTypeHelper.check);
    }, [constraintTypeHelper.check, constraintValue, isCollectionConstraintEnabled, itemDefinition]);
    var enumToKieConstraintType = useCallback(function (selection) {
        switch (selection) {
            case ConstraintsType.ENUMERATION:
                return "enumeration";
            case ConstraintsType.EXPRESSION:
                return "expression";
            case ConstraintsType.RANGE:
                return "range";
            case ConstraintsType.NONE:
            default:
                return undefined;
        }
    }, []);
    var isConstraintEnabled = useMemo(function () {
        return {
            enumeration: !(isCollection(itemDefinition) === true && isCollectionConstraintEnabled === true) &&
                (enabledConstraints !== null && enabledConstraints !== void 0 ? enabledConstraints : []).includes(enumToKieConstraintType(ConstraintsType.ENUMERATION)),
            range: !(isCollection(itemDefinition) === true && isCollectionConstraintEnabled === true) &&
                (enabledConstraints !== null && enabledConstraints !== void 0 ? enabledConstraints : []).includes(enumToKieConstraintType(ConstraintsType.RANGE)),
            expression: (isCollection(itemDefinition) === true && isCollectionConstraintEnabled === true) ||
                (enabledConstraints !== null && enabledConstraints !== void 0 ? enabledConstraints : []).includes(enumToKieConstraintType(ConstraintsType.EXPRESSION)),
        };
    }, [enabledConstraints, enumToKieConstraintType, isCollectionConstraintEnabled, itemDefinition]);
    var selectedKieConstraintType = useMemo(function () {
        if (isConstraintEnabled.enumeration && kieConstraintType === "enumeration") {
            return ConstraintsType.ENUMERATION;
        }
        if (isConstraintEnabled.range && kieConstraintType === "range") {
            return ConstraintsType.RANGE;
        }
        if (isConstraintEnabled.expression && kieConstraintType === "expression") {
            return ConstraintsType.EXPRESSION;
        }
        if (kieConstraintType === undefined && constraintValue && isConstraintEnabled.enumeration && isConstraintEnum) {
            return ConstraintsType.ENUMERATION;
        }
        if (kieConstraintType === undefined && constraintValue && isConstraintEnabled.range && isConstraintRange) {
            return ConstraintsType.RANGE;
        }
        if (kieConstraintType === undefined && constraintValue) {
            return ConstraintsType.EXPRESSION;
        }
        return ConstraintsType.NONE;
    }, [
        constraintValue,
        isConstraintEnabled.enumeration,
        isConstraintEnabled.expression,
        isConstraintEnabled.range,
        isConstraintEnum,
        isConstraintRange,
        kieConstraintType,
    ]);
    return {
        constraintValue: constraintValue,
        isConstraintEnum: isConstraintEnum,
        isConstraintRange: isConstraintRange,
        isConstraintEnabled: isConstraintEnabled,
        selectedKieConstraintType: selectedKieConstraintType,
        enumToKieConstraintType: enumToKieConstraintType,
    };
}
export function ConstraintsFromAllowedValuesAttribute(_a) {
    var _b;
    var isReadonly = _a.isReadonly, itemDefinition = _a.itemDefinition, editItemDefinition = _a.editItemDefinition, renderOnPropertiesPanel = _a.renderOnPropertiesPanel;
    var externalModelsByNamespace = useExternalModels().externalModelsByNamespace;
    var allDataTypesById = useDmnEditorStore(function (s) { return s.computed(s).getDataTypes(externalModelsByNamespace).allDataTypesById; });
    var allTopLevelItemDefinitionUniqueNames = useDmnEditorStore(function (s) { return s.computed(s).getDataTypes(externalModelsByNamespace).allTopLevelItemDefinitionUniqueNames; });
    var allowedValues = useMemo(function () { return itemDefinition === null || itemDefinition === void 0 ? void 0 : itemDefinition.allowedValues; }, [itemDefinition === null || itemDefinition === void 0 ? void 0 : itemDefinition.allowedValues]);
    var itemDefinitionId = itemDefinition["@_id"];
    var typeRef = (_b = itemDefinition === null || itemDefinition === void 0 ? void 0 : itemDefinition.typeRef) === null || _b === void 0 ? void 0 : _b.__$$text;
    var typeRefConstraintTypeHelper = useMemo(function () { return constraintTypeHelper(itemDefinition, allDataTypesById, allTopLevelItemDefinitionUniqueNames); }, [allDataTypesById, allTopLevelItemDefinitionUniqueNames, itemDefinition]);
    var rootItemDefinition = useMemo(function () { return recursivelyGetRootItemDefinition(itemDefinition, allDataTypesById, allTopLevelItemDefinitionUniqueNames); }, [allDataTypesById, allTopLevelItemDefinitionUniqueNames, itemDefinition]);
    var enabledConstraints = useMemo(function () {
        var _a, _b;
        return isStruct(rootItemDefinition)
            ? ["expression"]
            : constrainableBuiltInFeelTypes.get((_b = (_a = rootItemDefinition.typeRef) === null || _a === void 0 ? void 0 : _a.__$$text) !== null && _b !== void 0 ? _b : DmnBuiltInDataType.Undefined);
    }, [rootItemDefinition]);
    var isCollectionConstraintEnable = useMemo(function () {
        var _a;
        if (itemDefinitionId !== rootItemDefinition["@_id"]) {
            return (_a = rootItemDefinition["@_isCollection"]) !== null && _a !== void 0 ? _a : false;
        }
        return false;
    }, [itemDefinitionId, rootItemDefinition]);
    var _c = useConstraint({
        constraint: allowedValues,
        itemDefinition: itemDefinition,
        isCollectionConstraintEnabled: isCollectionConstraintEnable,
        constraintTypeHelper: typeRefConstraintTypeHelper,
        enabledConstraints: enabledConstraints,
    }), constraintValue = _c.constraintValue, isConstraintEnum = _c.isConstraintEnum, isConstraintRange = _c.isConstraintRange, isConstraintEnabled = _c.isConstraintEnabled, selectedKieConstraintType = _c.selectedKieConstraintType, enumToKieConstraintType = _c.enumToKieConstraintType;
    var onConstraintChange = useCallback(function (value, selectedConstraint) {
        editItemDefinition(itemDefinitionId, function (itemDefinition) {
            var _a, _b, _c;
            if (value === "" || value === undefined) {
                itemDefinition.allowedValues = undefined;
            }
            else {
                (_a = itemDefinition.allowedValues) !== null && _a !== void 0 ? _a : (itemDefinition.allowedValues = { "@_id": generateUuid(), text: { __$$text: "" } });
                itemDefinition.allowedValues.text.__$$text = value;
                itemDefinition.allowedValues["@_id"] = (_c = (_b = itemDefinition.allowedValues) === null || _b === void 0 ? void 0 : _b["@_id"]) !== null && _c !== void 0 ? _c : generateUuid();
                itemDefinition.allowedValues["@_kie:constraintType"] = enumToKieConstraintType(selectedConstraint);
            }
        });
    }, [editItemDefinition, enumToKieConstraintType, itemDefinitionId]);
    var onToggleGroupChange = useCallback(function (newSelection, selectedConstraint) {
        if (!newSelection) {
            return;
        }
        editItemDefinition(itemDefinitionId, function (itemDefinition) {
            var _a, _b;
            if (selectedConstraint === ConstraintsType.NONE) {
                itemDefinition.allowedValues = undefined;
                return;
            }
            if (itemDefinition.allowedValues) {
                itemDefinition.allowedValues["@_kie:constraintType"] = enumToKieConstraintType(selectedConstraint);
            }
            if (selectedConstraint === ConstraintsType.EXPRESSION) {
                return;
            }
            if (selectedConstraint === ConstraintsType.ENUMERATION &&
                isEnum((_a = itemDefinition.allowedValues) === null || _a === void 0 ? void 0 : _a.text.__$$text, typeRefConstraintTypeHelper.check)) {
                return;
            }
            if (selectedConstraint === ConstraintsType.RANGE &&
                isRange((_b = itemDefinition.allowedValues) === null || _b === void 0 ? void 0 : _b.text.__$$text, typeRefConstraintTypeHelper.check)) {
                return;
            }
            itemDefinition.allowedValues = undefined;
        });
    }, [editItemDefinition, itemDefinitionId, enumToKieConstraintType, typeRefConstraintTypeHelper.check]);
    return (_jsx(Constraints, { isReadonly: isReadonly, itemDefinitionId: itemDefinitionId, constraintValue: constraintValue, typeHelper: typeRefConstraintTypeHelper, typeRef: typeRef, isConstraintEnum: isConstraintEnum, isConstraintRange: isConstraintRange, isConstraintEnabled: isConstraintEnabled, selectedKieConstraintType: selectedKieConstraintType, onToggleGroupChange: onToggleGroupChange, onConstraintChange: onConstraintChange, renderOnPropertiesPanel: renderOnPropertiesPanel }));
}
export function ConstraintsFromTypeConstraintAttribute(_a) {
    var _b;
    var isReadonly = _a.isReadonly, itemDefinition = _a.itemDefinition, editItemDefinition = _a.editItemDefinition, renderOnPropertiesPanel = _a.renderOnPropertiesPanel, defaultsToAllowedValues = _a.defaultsToAllowedValues;
    var externalModelsByNamespace = useExternalModels().externalModelsByNamespace;
    var allDataTypesById = useDmnEditorStore(function (s) { return s.computed(s).getDataTypes(externalModelsByNamespace).allDataTypesById; });
    var allTopLevelItemDefinitionUniqueNames = useDmnEditorStore(function (s) { return s.computed(s).getDataTypes(externalModelsByNamespace).allTopLevelItemDefinitionUniqueNames; });
    var itemDefinitionId = itemDefinition["@_id"];
    var typeConstraint = useMemo(function () {
        var _a;
        return defaultsToAllowedValues
            ? (_a = itemDefinition === null || itemDefinition === void 0 ? void 0 : itemDefinition.typeConstraint) !== null && _a !== void 0 ? _a : itemDefinition === null || itemDefinition === void 0 ? void 0 : itemDefinition.allowedValues
            : itemDefinition === null || itemDefinition === void 0 ? void 0 : itemDefinition.typeConstraint;
    }, [defaultsToAllowedValues, itemDefinition === null || itemDefinition === void 0 ? void 0 : itemDefinition.allowedValues, itemDefinition === null || itemDefinition === void 0 ? void 0 : itemDefinition.typeConstraint]);
    var typeRef = (_b = itemDefinition === null || itemDefinition === void 0 ? void 0 : itemDefinition.typeRef) === null || _b === void 0 ? void 0 : _b.__$$text;
    var typeRefConstraintTypeHelper = useMemo(function () { return constraintTypeHelper(itemDefinition, allDataTypesById, allTopLevelItemDefinitionUniqueNames); }, [allDataTypesById, allTopLevelItemDefinitionUniqueNames, itemDefinition]);
    var rootItemDefinition = useMemo(function () { return recursivelyGetRootItemDefinition(itemDefinition, allDataTypesById, allTopLevelItemDefinitionUniqueNames); }, [allDataTypesById, allTopLevelItemDefinitionUniqueNames, itemDefinition]);
    var enabledConstraints = useMemo(function () {
        var _a;
        if (isStruct(rootItemDefinition)) {
            return ["expression"];
        }
        if (isCollection(rootItemDefinition)) {
            return ["expression"];
        }
        return constrainableBuiltInFeelTypes.get((_a = rootItemDefinition.typeRef) === null || _a === void 0 ? void 0 : _a.__$$text);
    }, [rootItemDefinition]);
    var _c = useConstraint({
        constraint: typeConstraint,
        itemDefinition: itemDefinition,
        isCollectionConstraintEnabled: true,
        constraintTypeHelper: typeRefConstraintTypeHelper,
        enabledConstraints: enabledConstraints,
    }), constraintValue = _c.constraintValue, isConstraintEnum = _c.isConstraintEnum, isConstraintRange = _c.isConstraintRange, isConstraintEnabled = _c.isConstraintEnabled, selectedKieConstraintType = _c.selectedKieConstraintType, enumToKieConstraintType = _c.enumToKieConstraintType;
    var onConstraintChange = useCallback(function (value, selectedConstraint) {
        editItemDefinition(itemDefinitionId, function (itemDefinition) {
            var _a, _b, _c;
            if (value === "" || value === undefined) {
                itemDefinition.typeConstraint = undefined;
            }
            else {
                (_a = itemDefinition.typeConstraint) !== null && _a !== void 0 ? _a : (itemDefinition.typeConstraint = { "@_id": generateUuid(), text: { __$$text: "" } });
                itemDefinition.typeConstraint.text.__$$text = value;
                itemDefinition.typeConstraint["@_id"] = (_c = (_b = itemDefinition.typeConstraint) === null || _b === void 0 ? void 0 : _b["@_id"]) !== null && _c !== void 0 ? _c : generateUuid();
                itemDefinition.typeConstraint["@_kie:constraintType"] = enumToKieConstraintType(selectedConstraint);
            }
        });
    }, [editItemDefinition, enumToKieConstraintType, itemDefinitionId]);
    var onToggleGroupChange = useCallback(function (newSelection, selectedConstraint) {
        if (!newSelection) {
            return;
        }
        editItemDefinition(itemDefinitionId, function (itemDefinition) {
            var _a, _b;
            if (selectedConstraint === ConstraintsType.NONE) {
                itemDefinition.typeConstraint = undefined;
                return;
            }
            if (!itemDefinition.typeConstraint && itemDefinition.allowedValues) {
                itemDefinition.typeConstraint = itemDefinition.allowedValues;
                itemDefinition.allowedValues = undefined;
            }
            if (itemDefinition.typeConstraint) {
                itemDefinition.typeConstraint["@_kie:constraintType"] = enumToKieConstraintType(selectedConstraint);
            }
            if (selectedConstraint === ConstraintsType.EXPRESSION) {
                return;
            }
            if (selectedConstraint === ConstraintsType.ENUMERATION &&
                isEnum((_a = itemDefinition.typeConstraint) === null || _a === void 0 ? void 0 : _a.text.__$$text, typeRefConstraintTypeHelper.check)) {
                return;
            }
            if (selectedConstraint === ConstraintsType.RANGE &&
                isRange((_b = itemDefinition.typeConstraint) === null || _b === void 0 ? void 0 : _b.text.__$$text, typeRefConstraintTypeHelper.check)) {
                return;
            }
            itemDefinition.typeConstraint = undefined;
        });
    }, [editItemDefinition, itemDefinitionId, enumToKieConstraintType, typeRefConstraintTypeHelper.check]);
    return (_jsx(Constraints, { isReadonly: isReadonly, itemDefinitionId: itemDefinitionId, constraintValue: constraintValue, typeHelper: typeRefConstraintTypeHelper, typeRef: typeRef, isConstraintEnum: isConstraintEnum, isConstraintRange: isConstraintRange, isConstraintEnabled: isConstraintEnabled, selectedKieConstraintType: selectedKieConstraintType, onToggleGroupChange: onToggleGroupChange, onConstraintChange: onConstraintChange, renderOnPropertiesPanel: renderOnPropertiesPanel }));
}
export function Constraints(_a) {
    var isReadonly = _a.isReadonly, itemDefinitionId = _a.itemDefinitionId, constraintValue = _a.constraintValue, typeHelper = _a.typeHelper, typeRef = _a.typeRef, isConstraintEnum = _a.isConstraintEnum, isConstraintRange = _a.isConstraintRange, isConstraintEnabled = _a.isConstraintEnabled, selectedKieConstraintType = _a.selectedKieConstraintType, onToggleGroupChange = _a.onToggleGroupChange, onConstraintChange = _a.onConstraintChange, renderOnPropertiesPanel = _a.renderOnPropertiesPanel;
    var _b = __read(useState({ selectedConstraint: selectedKieConstraintType, itemDefinitionId: itemDefinitionId }), 2), internalSelectedConstraint = _b[0], setInternalSelectedConstraint = _b[1];
    useEffect(function () {
        setInternalSelectedConstraint(function (prev) {
            if (selectedKieConstraintType === ConstraintsType.NONE && prev.itemDefinitionId === itemDefinitionId) {
                return prev;
            }
            return { selectedConstraint: selectedKieConstraintType, itemDefinitionId: itemDefinitionId };
        });
    }, [itemDefinitionId, selectedKieConstraintType]);
    var onToggleGroupChangeInternal = useCallback(function (selected, event) {
        var selectedConstraint = event.currentTarget.id;
        setInternalSelectedConstraint(function (prev) { return ({ selectedConstraint: selectedConstraint, itemDefinitionId: prev.itemDefinitionId }); });
        onToggleGroupChange(selected, selectedConstraint);
    }, [onToggleGroupChange]);
    var onConstraintChangeInternal = useCallback(function (value) {
        if (constraintValue !== value) {
            onConstraintChange(value, internalSelectedConstraint.selectedConstraint);
        }
    }, [onConstraintChange, internalSelectedConstraint, constraintValue]);
    return (_jsx(_Fragment, { children: isConstraintEnabled.expression === false &&
            isConstraintEnabled.enumeration === false &&
            isConstraintEnabled.range === false ? (_jsx("p", __assign({ style: {
                padding: "10px",
                background: "#eee",
                borderRadius: "10px",
                textAlign: "center",
            } }, { children: "This data type doesn't support constraints" }))) : (_jsxs("div", __assign({ style: { display: "flex", flexDirection: "column" } }, { children: [_jsx("div", { children: _jsxs(ToggleGroup, __assign({ "aria-label": "Constraint toggle group" }, { children: [_jsx(ToggleGroupItem, { text: ConstraintsType.NONE, buttonId: ConstraintsType.NONE, isSelected: internalSelectedConstraint.selectedConstraint === ConstraintsType.NONE, onChange: onToggleGroupChangeInternal, isDisabled: isReadonly }), _jsx(ToggleGroupItem, { style: { zIndex: 10 }, text: ConstraintsType.EXPRESSION, buttonId: ConstraintsType.EXPRESSION, isSelected: internalSelectedConstraint.selectedConstraint === ConstraintsType.EXPRESSION, onChange: onToggleGroupChangeInternal, isDisabled: isReadonly || !isConstraintEnabled.expression }), _jsx(ToggleGroupItem, { text: ConstraintsType.ENUMERATION, buttonId: ConstraintsType.ENUMERATION, isSelected: internalSelectedConstraint.selectedConstraint === ConstraintsType.ENUMERATION, onChange: onToggleGroupChangeInternal, isDisabled: isReadonly || !isConstraintEnabled.enumeration }), _jsx(ToggleGroupItem, { text: ConstraintsType.RANGE, buttonId: ConstraintsType.RANGE, isSelected: internalSelectedConstraint.selectedConstraint === ConstraintsType.RANGE, onChange: onToggleGroupChangeInternal, isDisabled: isReadonly || !isConstraintEnabled.range })] })) }), _jsxs("div", __assign({ style: { paddingTop: "20px" } }, { children: [internalSelectedConstraint.selectedConstraint === ConstraintsType.ENUMERATION && (_jsx(ConstraintsEnum, { id: itemDefinitionId, isReadonly: isReadonly, type: typeRef, typeHelper: typeHelper, value: isConstraintEnum ? constraintValue : undefined, expressionValue: constraintValue, onSave: onConstraintChangeInternal, isDisabled: !isConstraintEnabled.enumeration, renderOnPropertiesPanel: renderOnPropertiesPanel })), internalSelectedConstraint.selectedConstraint === ConstraintsType.RANGE && (_jsx(ConstraintsRange, { id: itemDefinitionId, isReadonly: isReadonly, expressionValue: constraintValue, type: typeRef, typeHelper: typeHelper, value: isConstraintRange ? constraintValue : undefined, onSave: onConstraintChangeInternal, isDisabled: !isConstraintEnabled.range, renderOnPropertiesPanel: renderOnPropertiesPanel })), internalSelectedConstraint.selectedConstraint === ConstraintsType.EXPRESSION && (_jsx(ConstraintsExpression, { id: itemDefinitionId, isReadonly: isReadonly, type: typeRef, value: constraintValue, savedValue: constraintValue, onSave: onConstraintChangeInternal, isDisabled: !isConstraintEnabled.expression })), internalSelectedConstraint.selectedConstraint === ConstraintsType.NONE && (_jsx("p", __assign({ style: {
                                padding: "24px",
                                background: "#eee",
                                borderRadius: "10px",
                                textAlign: "center",
                            } }, { children: "All values are allowed" })))] }))] }))) }));
}
//# sourceMappingURL=Constraints.js.map