var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __generator = (this && this.__generator) || function (thisArg, body) {
    var _ = { label: 0, sent: function() { if (t[0] & 1) throw t[1]; return t[1]; }, trys: [], ops: [] }, f, y, t, g;
    return g = { next: verb(0), "throw": verb(1), "return": verb(2) }, typeof Symbol === "function" && (g[Symbol.iterator] = function() { return this; }), g;
    function verb(n) { return function (v) { return step([n, v]); }; }
    function step(op) {
        if (f) throw new TypeError("Generator is already executing.");
        while (_) try {
            if (f = 1, y && (t = op[0] & 2 ? y["return"] : op[0] ? y["throw"] || ((t = y["return"]) && t.call(y), 0) : y.next) && !(t = t.call(y, op[1])).done) return t;
            if (y = 0, t) op = [op[0] & 2, t.value];
            switch (op[0]) {
                case 0: case 1: t = op; break;
                case 4: _.label++; return { value: op[1], done: false };
                case 5: _.label++; y = op[1]; op = [0]; continue;
                case 7: op = _.ops.pop(); _.trys.pop(); continue;
                default:
                    if (!(t = _.trys, t = t.length > 0 && t[t.length - 1]) && (op[0] === 6 || op[0] === 2)) { _ = 0; continue; }
                    if (op[0] === 3 && (!t || (op[1] > t[0] && op[1] < t[3]))) { _.label = op[1]; break; }
                    if (op[0] === 6 && _.label < t[1]) { _.label = t[1]; t = op; break; }
                    if (t && _.label < t[2]) { _.label = t[2]; _.ops.push(op); break; }
                    if (t[2]) _.ops.pop();
                    _.trys.pop(); continue;
            }
            op = body.call(thisArg, _);
        } catch (e) { op = [6, e]; y = 0; } finally { f = t = 0; }
        if (op[0] & 5) throw op[1]; return { value: op[0] ? op[1] : void 0, done: true };
    }
};
var __read = (this && this.__read) || function (o, n) {
    var m = typeof Symbol === "function" && o[Symbol.iterator];
    if (!m) return o;
    var i = m.call(o), r, ar = [], e;
    try {
        while ((n === void 0 || n-- > 0) && !(r = i.next()).done) ar.push(r.value);
    }
    catch (error) { e = { error: error }; }
    finally {
        try {
            if (r && !r.done && (m = i["return"])) m.call(i);
        }
        finally { if (e) throw e.error; }
    }
    return ar;
};
var __spreadArray = (this && this.__spreadArray) || function (to, from, pack) {
    if (pack || arguments.length === 2) for (var i = 0, l = from.length, ar; i < l; i++) {
        if (ar || !(i in from)) {
            if (!ar) ar = Array.prototype.slice.call(from, 0, i);
            ar[i] = from[i];
        }
    }
    return to.concat(ar || Array.prototype.slice.call(from));
};
var __values = (this && this.__values) || function(o) {
    var s = typeof Symbol === "function" && Symbol.iterator, m = s && o[s], i = 0;
    if (m) return m.call(o);
    if (o && typeof o.length === "number") return {
        next: function () {
            if (o && i >= o.length) o = void 0;
            return { value: o && o[i++], done: !o };
        }
    };
    throw new TypeError(s ? "Object is not iterable." : "Symbol.iterator is not defined.");
};
import { generateUuid } from "@kie-tools/boxed-expression-component/dist/api";
import ELK from "elkjs/lib/elk.bundled.js";
import { getAdjMatrix, traverse } from "../diagram/graph/graph";
import { getContainmentRelationship } from "../diagram/maths/DmnMaths";
import { DEFAULT_NODE_SIZES, MIN_NODE_SIZES } from "../diagram/nodes/DefaultSizes";
import { NODE_TYPES } from "../diagram/nodes/NodeTypes";
import { addNamespaceToHref, parseXmlHref } from "../xml/xmlHrefs";
var elk = new ELK();
export var ELK_OPTIONS = {
    "elk.algorithm": "layered",
    "elk.direction": "UP",
    "elk.aspectRatio": "9999999999",
    "elk.spacing.nodeNode": "60",
    "elk.spacing.componentComponent": "200",
    "layered.spacing.edgeEdgeBetweenLayers": "0",
    "layered.spacing.edgeNodeBetweenLayers": "0",
    "layered.spacing.nodeNodeBetweenLayers": "100",
    "elk.edgeRouting": "ORTHOGONAL",
    "elk.layered.mergeEdges": "true",
    "elk.layered.mergeHierarchyEdges": "true",
    "elk.partitioning.activate": "true",
    "elk.nodePlacement.favorStraightEdges": "true",
    "elk.nodePlacement.bk.fixedAlignment": "LEFTDOWN",
    "elk.nodePlacement.bk.edgeStraightening": "IMPROVE_STRAIGHTNESS",
    "layering.strategy": "LONGEST_PATH_SOURCE",
};
var PARENT_NODE_ELK_OPTIONS = {
    "elk.padding": "[left=60, top=60, right=80, bottom=60]",
    "elk.spacing.componentComponent": "60",
};
export var FAKE_MARKER = "__$FAKE$__";
export function getAutoLayoutedInfo(_a) {
    var _b, _c, _d, _e, _f, _g, _h, _j, _k, _l, _m;
    var __readonly_snapGrid = _a.__readonly_snapGrid, __readonly_nodesById = _a.__readonly_nodesById, __readonly_edgesById = _a.__readonly_edgesById, __readonly_nodes = _a.__readonly_nodes, __readonly_drgEdges = _a.__readonly_drgEdges, __readonly_isAlternativeInputDataShape = _a.__readonly_isAlternativeInputDataShape;
    return __awaiter(this, void 0, void 0, function () {
        var parentNodesById, nodeParentsById, fakeEdgesForElk, adjMatrix, _loop_1, __readonly_nodes_1, __readonly_nodes_1_1, node, elkNodes, _loop_2, parentNodesById_1, parentNodesById_1_1, _o, _1, parentNode, _loop_3, __readonly_nodes_2, __readonly_nodes_2_1, node, elkEdges, autoLayoutedInfo;
        var e_1, _p, e_2, _q, e_3, _r;
        return __generator(this, function (_s) {
            switch (_s.label) {
                case 0:
                    parentNodesById = new Map();
                    nodeParentsById = new Map();
                    fakeEdgesForElk = new Set();
                    adjMatrix = getAdjMatrix(__readonly_drgEdges);
                    _loop_1 = function (node) {
                        var dependencies = new Set();
                        var dependents = new Set();
                        if (((_c = (_b = node.data) === null || _b === void 0 ? void 0 : _b.dmnObject) === null || _c === void 0 ? void 0 : _c.__$$element) === "decisionService") {
                            var namespace_1 = parseXmlHref(node.id).namespace;
                            var outputs_1 = new Set(__spreadArray([], __read(((_d = node.data.dmnObject.outputDecision) !== null && _d !== void 0 ? _d : []).map(function (s) { return addNamespaceToHref({ href: s["@_href"], namespace: namespace_1 }); })), false));
                            var encapsulated_1 = new Set(__spreadArray([], __read(((_e = node.data.dmnObject.encapsulatedDecision) !== null && _e !== void 0 ? _e : []).map(function (s) {
                                return addNamespaceToHref({ href: s["@_href"], namespace: namespace_1 });
                            })), false));
                            var idOfFakeNodeForOutputSection = "".concat(node.id).concat(FAKE_MARKER, "dsOutput");
                            var idOfFakeNodeForEncapsulatedSection = "".concat(node.id).concat(FAKE_MARKER, "dsEncapsulated");
                            var dsSize = MIN_NODE_SIZES[NODE_TYPES.decisionService]({ snapGrid: __readonly_snapGrid });
                            parentNodesById.set(node.id, {
                                elkNode: {
                                    id: node.id,
                                    width: dsSize["@_width"],
                                    height: dsSize["@_height"],
                                    children: [
                                        {
                                            id: idOfFakeNodeForOutputSection,
                                            width: dsSize["@_width"],
                                            height: dsSize["@_height"] / 2,
                                            children: [],
                                            layoutOptions: __assign(__assign({}, ELK_OPTIONS), PARENT_NODE_ELK_OPTIONS),
                                        },
                                        {
                                            id: idOfFakeNodeForEncapsulatedSection,
                                            width: dsSize["@_width"],
                                            height: dsSize["@_height"] / 2,
                                            children: [],
                                            layoutOptions: __assign(__assign({}, ELK_OPTIONS), PARENT_NODE_ELK_OPTIONS),
                                        },
                                    ],
                                    layoutOptions: {
                                        "elk.algorithm": "layered",
                                        "elk.direction": "UP",
                                        "elk.aspectRatio": "9999999999",
                                        "elk.partitioning.activate": "true",
                                        "elk.spacing.nodeNode": "0",
                                        "elk.spacing.componentComponent": "0",
                                        "layered.spacing.edgeEdgeBetweenLayers": "0",
                                        "layered.spacing.edgeNodeBetweenLayers": "0",
                                        "layered.spacing.nodeNodeBetweenLayers": "0",
                                        "elk.padding": "[left=0, top=0, right=0, bottom=0]",
                                    },
                                },
                                decisionServiceSection: "output",
                                dependencies: dependencies,
                                dependents: dependents,
                                contained: outputs_1,
                                contains: function (_a) {
                                    var id = _a.id;
                                    return ({
                                        isInside: outputs_1.has(id) || encapsulated_1.has(id),
                                        decisionServiceSection: outputs_1.has(id) ? "output" : encapsulated_1.has(id) ? "encapsulated" : "n/a",
                                    });
                                },
                                isDependencyOf: function (_a) {
                                    var id = _a.id;
                                    return dependents.has(id);
                                },
                                hasDependencyTo: function (_a) {
                                    var id = _a.id;
                                    return dependencies.has(id);
                                },
                            });
                            fakeEdgesForElk.add({
                                id: "".concat(node.id).concat(FAKE_MARKER, "fakeOutputEncapsulatedEdge"),
                                sources: [idOfFakeNodeForEncapsulatedSection],
                                targets: [idOfFakeNodeForOutputSection],
                            });
                        }
                        else if (((_g = (_f = node.data) === null || _f === void 0 ? void 0 : _f.dmnObject) === null || _g === void 0 ? void 0 : _g.__$$element) === "group") {
                            var groupSize = DEFAULT_NODE_SIZES[NODE_TYPES.group]({ snapGrid: __readonly_snapGrid });
                            var groupBounds_1 = node.data.shape["dc:Bounds"];
                            parentNodesById.set(node.id, {
                                decisionServiceSection: "n/a",
                                elkNode: {
                                    id: node.id,
                                    width: (_h = groupBounds_1 === null || groupBounds_1 === void 0 ? void 0 : groupBounds_1["@_width"]) !== null && _h !== void 0 ? _h : groupSize["@_width"],
                                    height: (_j = groupBounds_1 === null || groupBounds_1 === void 0 ? void 0 : groupBounds_1["@_height"]) !== null && _j !== void 0 ? _j : groupSize["@_height"],
                                    children: [],
                                    layoutOptions: __assign(__assign({}, ELK_OPTIONS), PARENT_NODE_ELK_OPTIONS),
                                },
                                dependencies: dependencies,
                                dependents: dependents,
                                contained: new Set(),
                                contains: function (_a) {
                                    var _b;
                                    var id = _a.id, bounds = _a.bounds;
                                    return ({
                                        isInside: getContainmentRelationship({
                                            bounds: bounds,
                                            container: groupBounds_1,
                                            snapGrid: __readonly_snapGrid,
                                            isAlternativeInputDataShape: __readonly_isAlternativeInputDataShape,
                                            containerMinSizes: MIN_NODE_SIZES[NODE_TYPES.group],
                                            boundsMinSizes: MIN_NODE_SIZES[(_b = __readonly_nodesById.get(id)) === null || _b === void 0 ? void 0 : _b.type],
                                        }).isInside,
                                        decisionServiceSection: "n/a",
                                    });
                                },
                                isDependencyOf: function (_a) {
                                    var id = _a.id;
                                    return dependents.has(id);
                                },
                                hasDependencyTo: function (_a) {
                                    var id = _a.id;
                                    return dependencies.has(id);
                                },
                            });
                        }
                    };
                    try {
                        for (__readonly_nodes_1 = __values(__readonly_nodes), __readonly_nodes_1_1 = __readonly_nodes_1.next(); !__readonly_nodes_1_1.done; __readonly_nodes_1_1 = __readonly_nodes_1.next()) {
                            node = __readonly_nodes_1_1.value;
                            _loop_1(node);
                        }
                    }
                    catch (e_1_1) { e_1 = { error: e_1_1 }; }
                    finally {
                        try {
                            if (__readonly_nodes_1_1 && !__readonly_nodes_1_1.done && (_p = __readonly_nodes_1.return)) _p.call(__readonly_nodes_1);
                        }
                        finally { if (e_1) throw e_1.error; }
                    }
                    elkNodes = __readonly_nodes.flatMap(function (node) {
                        var e_4, _a;
                        var _b, _c, _d, _e, _f, _g, _h, _j, _k, _l, _m;
                        var parent = parentNodesById.get(node.id);
                        if (parent) {
                            return [];
                        }
                        var defaultSize = DEFAULT_NODE_SIZES[node.type]({
                            snapGrid: __readonly_snapGrid,
                            isAlternativeInputDataShape: __readonly_isAlternativeInputDataShape,
                        });
                        var elkNode = {
                            id: node.id,
                            width: (_c = (_b = node.data.shape["dc:Bounds"]) === null || _b === void 0 ? void 0 : _b["@_width"]) !== null && _c !== void 0 ? _c : defaultSize["@_width"],
                            height: (_e = (_d = node.data.shape["dc:Bounds"]) === null || _d === void 0 ? void 0 : _d["@_height"]) !== null && _e !== void 0 ? _e : defaultSize["@_height"],
                            children: [],
                            layoutOptions: {
                                "partitioning.partition": node.type === NODE_TYPES.textAnnotation ||
                                    node.type === NODE_TYPES.knowledgeSource
                                    ? "0"
                                    : "1",
                            },
                        };
                        var parents = __spreadArray([], __read(parentNodesById.values()), false).filter(function (p) { return p.contains({ id: elkNode.id, bounds: node.data.shape["dc:Bounds"] }).isInside; });
                        if (parents.length > 0) {
                            var decisionServiceSection = parents[0].contains({
                                id: elkNode.id,
                                bounds: node.data.shape["dc:Bounds"],
                            }).decisionServiceSection;
                            if (decisionServiceSection === "n/a") {
                                (_f = parents[0].elkNode.children) === null || _f === void 0 ? void 0 : _f.push(elkNode);
                            }
                            else if (decisionServiceSection === "output") {
                                (_h = (_g = parents[0].elkNode.children) === null || _g === void 0 ? void 0 : _g[0].children) === null || _h === void 0 ? void 0 : _h.push(elkNode);
                            }
                            else if (decisionServiceSection === "encapsulated") {
                                (_k = (_j = parents[0].elkNode.children) === null || _j === void 0 ? void 0 : _j[1].children) === null || _k === void 0 ? void 0 : _k.push(elkNode);
                            }
                            else {
                                throw new Error("Unknown decisionServiceSection ".concat(decisionServiceSection));
                            }
                            try {
                                for (var parents_1 = __values(parents), parents_1_1 = parents_1.next(); !parents_1_1.done; parents_1_1 = parents_1.next()) {
                                    var p = parents_1_1.value;
                                    (_l = p.contained) === null || _l === void 0 ? void 0 : _l.add(elkNode.id);
                                    nodeParentsById.set(node.id, new Set(__spreadArray(__spreadArray([], __read(((_m = nodeParentsById.get(node.id)) !== null && _m !== void 0 ? _m : [])), false), [p.elkNode.id], false)));
                                }
                            }
                            catch (e_4_1) { e_4 = { error: e_4_1 }; }
                            finally {
                                try {
                                    if (parents_1_1 && !parents_1_1.done && (_a = parents_1.return)) _a.call(parents_1);
                                }
                                finally { if (e_4) throw e_4.error; }
                            }
                            return [];
                        }
                        return [elkNode];
                    });
                    _loop_2 = function (_1, parentNode) {
                        traverse(adjMatrix, parentNode.contained, __spreadArray([], __read(parentNode.contained), false), "down", function (n) {
                            parentNode.dependencies.add(n);
                        });
                        traverse(adjMatrix, parentNode.contained, __spreadArray([], __read(parentNode.contained), false), "up", function (n) {
                            parentNode.dependents.add(n);
                        });
                        var p = __readonly_nodesById.get(parentNode.elkNode.id);
                        if ((p === null || p === void 0 ? void 0 : p.type) === NODE_TYPES.group && ((_k = parentNode.elkNode.children) === null || _k === void 0 ? void 0 : _k.length) === 0) {
                            return "continue";
                        }
                        else {
                            elkNodes.push(parentNode.elkNode);
                        }
                    };
                    try {
                        for (parentNodesById_1 = __values(parentNodesById), parentNodesById_1_1 = parentNodesById_1.next(); !parentNodesById_1_1.done; parentNodesById_1_1 = parentNodesById_1.next()) {
                            _o = __read(parentNodesById_1_1.value, 2), _1 = _o[0], parentNode = _o[1];
                            _loop_2(_1, parentNode);
                        }
                    }
                    catch (e_2_1) { e_2 = { error: e_2_1 }; }
                    finally {
                        try {
                            if (parentNodesById_1_1 && !parentNodesById_1_1.done && (_q = parentNodesById_1.return)) _q.call(parentNodesById_1);
                        }
                        finally { if (e_2) throw e_2.error; }
                    }
                    _loop_3 = function (node) {
                        var e_5, _t, e_6, _u, e_7, _v, e_8, _w;
                        var parentNodes = __spreadArray([], __read(parentNodesById.values()), false);
                        var dependents = parentNodes.filter(function (p) { return p.hasDependencyTo({ id: node.id }); });
                        try {
                            for (var dependents_1 = (e_5 = void 0, __values(dependents)), dependents_1_1 = dependents_1.next(); !dependents_1_1.done; dependents_1_1 = dependents_1.next()) {
                                var dependent = dependents_1_1.value;
                                if (__readonly_nodesById.has(node.id) && __readonly_nodesById.has(dependent.elkNode.id)) {
                                    fakeEdgesForElk.add({
                                        id: "".concat(generateUuid()).concat(FAKE_MARKER, "__fake"),
                                        sources: [node.id],
                                        targets: [dependent.elkNode.id],
                                    });
                                }
                                try {
                                    for (var _x = (e_6 = void 0, __values((_l = nodeParentsById.get(node.id)) !== null && _l !== void 0 ? _l : [])), _y = _x.next(); !_y.done; _y = _x.next()) {
                                        var p = _y.value;
                                        if (__readonly_nodesById.has(p) && __readonly_nodesById.has(dependent.elkNode.id)) {
                                            fakeEdgesForElk.add({
                                                id: "".concat(generateUuid()).concat(FAKE_MARKER, "__fake"),
                                                sources: [p],
                                                targets: [dependent.elkNode.id],
                                            });
                                        }
                                    }
                                }
                                catch (e_6_1) { e_6 = { error: e_6_1 }; }
                                finally {
                                    try {
                                        if (_y && !_y.done && (_u = _x.return)) _u.call(_x);
                                    }
                                    finally { if (e_6) throw e_6.error; }
                                }
                            }
                        }
                        catch (e_5_1) { e_5 = { error: e_5_1 }; }
                        finally {
                            try {
                                if (dependents_1_1 && !dependents_1_1.done && (_t = dependents_1.return)) _t.call(dependents_1);
                            }
                            finally { if (e_5) throw e_5.error; }
                        }
                        var dependencies = parentNodes.filter(function (p) { return p.isDependencyOf({ id: node.id }); });
                        try {
                            for (var dependencies_1 = (e_7 = void 0, __values(dependencies)), dependencies_1_1 = dependencies_1.next(); !dependencies_1_1.done; dependencies_1_1 = dependencies_1.next()) {
                                var dependency = dependencies_1_1.value;
                                if (__readonly_nodesById.has(node.id) && __readonly_nodesById.has(dependency.elkNode.id)) {
                                    fakeEdgesForElk.add({
                                        id: "".concat(generateUuid()).concat(FAKE_MARKER, "__fake"),
                                        sources: [dependency.elkNode.id],
                                        targets: [node.id],
                                    });
                                }
                                try {
                                    for (var _z = (e_8 = void 0, __values((_m = nodeParentsById.get(node.id)) !== null && _m !== void 0 ? _m : [])), _0 = _z.next(); !_0.done; _0 = _z.next()) {
                                        var p = _0.value;
                                        if (__readonly_nodesById.has(p) && __readonly_nodesById.has(dependency.elkNode.id)) {
                                            fakeEdgesForElk.add({
                                                id: "".concat(generateUuid()).concat(FAKE_MARKER, "__fake"),
                                                sources: [dependency.elkNode.id],
                                                targets: [p],
                                            });
                                        }
                                    }
                                }
                                catch (e_8_1) { e_8 = { error: e_8_1 }; }
                                finally {
                                    try {
                                        if (_0 && !_0.done && (_w = _z.return)) _w.call(_z);
                                    }
                                    finally { if (e_8) throw e_8.error; }
                                }
                            }
                        }
                        catch (e_7_1) { e_7 = { error: e_7_1 }; }
                        finally {
                            try {
                                if (dependencies_1_1 && !dependencies_1_1.done && (_v = dependencies_1.return)) _v.call(dependencies_1);
                            }
                            finally { if (e_7) throw e_7.error; }
                        }
                    };
                    try {
                        for (__readonly_nodes_2 = __values(__readonly_nodes), __readonly_nodes_2_1 = __readonly_nodes_2.next(); !__readonly_nodes_2_1.done; __readonly_nodes_2_1 = __readonly_nodes_2.next()) {
                            node = __readonly_nodes_2_1.value;
                            _loop_3(node);
                        }
                    }
                    catch (e_3_1) { e_3 = { error: e_3_1 }; }
                    finally {
                        try {
                            if (__readonly_nodes_2_1 && !__readonly_nodes_2_1.done && (_r = __readonly_nodes_2.return)) _r.call(__readonly_nodes_2);
                        }
                        finally { if (e_3) throw e_3.error; }
                    }
                    elkEdges = __spreadArray(__spreadArray([], __read(fakeEdgesForElk), false), __read(__spreadArray([], __read(__readonly_edgesById.values()), false).flatMap(function (e) {
                        if (__readonly_nodesById.has(e.source) && __readonly_nodesById.has(e.target)) {
                            return {
                                id: e.id,
                                sources: [e.source],
                                targets: [e.target],
                            };
                        }
                        else {
                            return [];
                        }
                    })), false);
                    return [4, runElk(elkNodes, elkEdges, ELK_OPTIONS)];
                case 1:
                    autoLayoutedInfo = _s.sent();
                    return [2, {
                            __readonly_autoLayoutedInfo: autoLayoutedInfo,
                            __readonly_parentNodesById: parentNodesById,
                        }];
            }
        });
    });
}
function runElk(nodes, edges, options) {
    if (options === void 0) { options = {}; }
    return __awaiter(this, void 0, void 0, function () {
        var isHorizontal, graph, layoutedGraph;
        return __generator(this, function (_a) {
            switch (_a.label) {
                case 0:
                    isHorizontal = (options === null || options === void 0 ? void 0 : options["elk.direction"]) === "RIGHT";
                    graph = {
                        id: "root",
                        layoutOptions: options,
                        children: nodes,
                        edges: edges,
                    };
                    return [4, elk.layout(graph)];
                case 1:
                    layoutedGraph = _a.sent();
                    return [2, {
                            isHorizontal: isHorizontal,
                            nodes: layoutedGraph.children,
                            edges: layoutedGraph.edges,
                        }];
            }
        });
    });
}
export function visitNodeAndNested(elkNode, positionOffset, visitor) {
    var e_9, _a;
    var _b;
    visitor(elkNode, positionOffset);
    try {
        for (var _c = __values((_b = elkNode.children) !== null && _b !== void 0 ? _b : []), _d = _c.next(); !_d.done; _d = _c.next()) {
            var nestedNode = _d.value;
            visitNodeAndNested(nestedNode, {
                x: elkNode.x + positionOffset.x,
                y: elkNode.y + positionOffset.y,
            }, visitor);
        }
    }
    catch (e_9_1) { e_9 = { error: e_9_1 }; }
    finally {
        try {
            if (_d && !_d.done && (_a = _c.return)) _a.call(_c);
        }
        finally { if (e_9) throw e_9.error; }
    }
}
//# sourceMappingURL=autoLayoutInfo.js.map