import React, { useCallback } from "react";
import { componentOuiaProps } from "@kie-tools/runtime-tools-components/dist/ouiaTools";
import { useCloudEventFormGatewayApi } from "../CloudEventForm";
import { EmbeddedCloudEventForm } from "@kie-tools/runtime-tools-swf-enveloped-components/dist/cloudEventForm";
export const CloudEventFormContainer = ({ instanceId, definitionName, cloudEventSource, isTriggerNewInstance, onStartWorkflowError, onTriggerCloudEventSuccess, onTriggerStartCloudEventSuccess, serviceUrl, ouiaId, ouiaSafe, targetOrigin, }) => {
    const gatewayApi = useCloudEventFormGatewayApi();
    const triggerStartCloudEvent = useCallback((event) => {
        return gatewayApi
            .triggerStartCloudEvent(event)
            .then((businessKey) => {
            onTriggerStartCloudEventSuccess(businessKey);
        })
            .catch((error) => onStartWorkflowError(error));
    }, [gatewayApi, onStartWorkflowError, onTriggerStartCloudEventSuccess]);
    const triggerCloudEvent = useCallback((event) => {
        return gatewayApi
            .triggerCloudEvent(event)
            .then((_response) => {
            onTriggerCloudEventSuccess();
        })
            .catch((error) => onStartWorkflowError(error));
    }, [gatewayApi, onStartWorkflowError, onTriggerCloudEventSuccess]);
    return (React.createElement(EmbeddedCloudEventForm, Object.assign({}, componentOuiaProps(ouiaId, "cloud-event-form-container", ouiaSafe), { targetOrigin: targetOrigin || window.location.origin, isNewInstanceEvent: isTriggerNewInstance, defaultValues: { cloudEventSource, instanceId, definitionName }, driver: {
            triggerCloudEvent(event) {
                const doTrigger = isTriggerNewInstance ? triggerStartCloudEvent : triggerCloudEvent;
                return doTrigger(event);
            },
        }, serviceUrl: serviceUrl })));
};
//# sourceMappingURL=CloudEventFormContainer.js.map