"use strict";
var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.YardLanguageServiceCodeCompletion = void 0;
var vscode_languageserver_types_1 = require("vscode-languageserver-types");
var code_completions_1 = require("../assets/code-completions/");
exports.YardLanguageServiceCodeCompletion = {
    getEmptyFileCodeCompletions: function (args) {
        var kind = vscode_languageserver_types_1.CompletionItemKind.Text;
        var emptyDecisionLabel = "Empty Serverless Decision";
        var exampleDecisionLabel = "Serverless Decision Example";
        return Promise.resolve([
            {
                kind: kind,
                label: exampleDecisionLabel,
                detail: "Start with a simple Serverless Decision",
                sortText: "100_".concat(exampleDecisionLabel),
                textEdit: {
                    newText: args.codeCompletionStrategy.translate(__assign(__assign({}, args), { completion: code_completions_1.decisionCompletion, completionItemKind: kind })),
                    range: vscode_languageserver_types_1.Range.create(args.cursorPosition, args.cursorPosition),
                },
                insertTextFormat: vscode_languageserver_types_1.InsertTextFormat.Snippet,
            },
            {
                kind: kind,
                label: emptyDecisionLabel,
                detail: "Start with an empty Serverless Decision",
                sortText: "100_".concat(emptyDecisionLabel),
                textEdit: {
                    newText: args.codeCompletionStrategy.translate(__assign(__assign({}, args), { completion: code_completions_1.emptyDecisionCompletion, completionItemKind: kind })),
                    range: vscode_languageserver_types_1.Range.create(args.cursorPosition, args.cursorPosition),
                },
                insertTextFormat: vscode_languageserver_types_1.InsertTextFormat.Snippet,
            },
        ]);
    },
};
//# sourceMappingURL=YardLanguageServiceCodeCompletion.js.map