var __rest = (this && this.__rest) || function (s, e) {
    var t = {};
    for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p) && e.indexOf(p) < 0)
        t[p] = s[p];
    if (s != null && typeof Object.getOwnPropertySymbols === "function")
        for (var i = 0, p = Object.getOwnPropertySymbols(s); i < p.length; i++) {
            if (e.indexOf(p[i]) < 0 && Object.prototype.propertyIsEnumerable.call(s, p[i]))
                t[p[i]] = s[p[i]];
        }
    return t;
};
import { jsx as _jsx, jsxs as _jsxs, Fragment as _Fragment } from "react/jsx-runtime";
import * as React from "react";
import { useMemo } from "react";
import UnitablesListItemField from "./UnitablesListItemField";
import { TextInput } from "@patternfly/react-core/dist/js/components/TextInput";
import { Tooltip } from "@patternfly/react-core/dist/js/components/Tooltip";
import { Split, SplitItem } from "@patternfly/react-core/dist/js/layouts/Split";
import { OutlinedQuestionCircleIcon } from "@patternfly/react-icons/dist/js/icons/outlined-question-circle-icon";
import { connectField, filterDOMProps } from "uniforms/esm";
import wrapField from "@kie-tools/uniforms-patternfly/dist/esm/wrapField";
import { ListAddField } from "@kie-tools/uniforms-patternfly/dist/esm";
function UnitablesListField(_a) {
    var { children = _jsx(UnitablesListItemField, { name: "$" }), itemProps } = _a, props = __rest(_a, ["children", "itemProps"]);
    const hasValue = useMemo(() => props.value && Array.isArray(props.value) && props.value.length > 0, [props.value]);
    return wrapField(props, _jsxs("div", Object.assign({ "data-testid": "unitables-list-field" }, filterDOMProps(props), { style: { display: "flex", width: "100%" } }, { children: [_jsxs(Split, Object.assign({ hasGutter: hasValue, style: !hasValue ? { width: "100%" } : {} }, { children: [props.label && (_jsxs(_Fragment, { children: [_jsx(SplitItem, { children: _jsxs("label", { children: [props.label, !!props.info && (_jsxs("span", { children: ["\u00A0", _jsx(Tooltip, Object.assign({ content: props.info }, { children: _jsx(OutlinedQuestionCircleIcon, {}) }))] }))] }) }), _jsx(SplitItem, { isFilled: true })] })), _jsx(SplitItem, Object.assign({ style: {
                            borderRight: "3px solid var(--pf-global--palette--black-300)",
                        } }, { children: _jsx(ListAddField, { style: {
                                minWidth: "60px",
                                maxWidth: "60px",
                            }, name: "$", initialCount: props.initialCount }) })), !hasValue && (_jsx(SplitItem, Object.assign({ style: { width: "100%" } }, { children: _jsx(TextInput, { "aria-label": "Add inputs placeholder", isDisabled: true, value: "Add inputs" }) })))] })), hasValue &&
                props.value.map((_, itemIndex) => {
                    var _a;
                    return (_jsxs("div", Object.assign({ style: { display: "flex", width: "100%" } }, { children: [_jsx("div", Object.assign({ style: {
                                    maxWidth: "60px",
                                    minWidth: "60px",
                                    minHeight: "60px",
                                    fontSize: "16px",
                                    color: "gray",
                                    display: "flex",
                                    alignItems: "center",
                                    justifyContent: "center",
                                    borderRight: "1px solid lightgray",
                                } }, { children: itemIndex })), React.isValidElement(children)
                                ? React.cloneElement(children, Object.assign(Object.assign({ key: `${itemIndex}`, name: (_a = children.props.name) === null || _a === void 0 ? void 0 : _a.split(/\$(.*)/s).slice(0, -1).join(`${itemIndex}`) }, itemProps), { style: props.value.length - 1 !== itemIndex
                                        ? { width: "100%", borderRight: "3px solid var(--pf-global--palette--black-300)" }
                                        : { width: "100%" } }))
                                : children] }), itemIndex));
                })] })));
}
export default connectField(UnitablesListField);
//# sourceMappingURL=UnitablesListField.js.map