import React from "react";
import { Popover } from "@patternfly/react-core/dist/js/components/Popover";
import { Button } from "@patternfly/react-core/dist/js/components/Button";
import { WorkflowInstanceIconCreator } from "../utils/WorkflowListUtils";
import { componentOuiaProps } from "@kie-tools/runtime-tools-components/dist/ouiaTools";
const ErrorPopover = ({ workflowInstanceData, onSkipClick, onRetryClick, ouiaId, ouiaSafe, }) => {
    var _a;
    return (React.createElement(Popover, Object.assign({ zIndex: 300, id: workflowInstanceData.id, headerContent: React.createElement("div", null, "Workflow error"), bodyContent: React.createElement("div", null, workflowInstanceData.error ? workflowInstanceData.error.message : "No error message found"), footerContent: ((_a = workflowInstanceData.addons) === null || _a === void 0 ? void 0 : _a.includes("workflow-management")) &&
            workflowInstanceData.serviceUrl && [
            React.createElement(Button, { key: "confirm1", id: "skip-button", variant: "secondary", onClick: () => onSkipClick(workflowInstanceData), className: "pf-u-mr-sm" }, "Skip"),
            React.createElement(Button, { key: "confirm2", variant: "secondary", id: "retry-button", onClick: () => onRetryClick(workflowInstanceData), className: "pf-u-mr-sm" }, "Retry"),
        ], position: "auto" }, componentOuiaProps(ouiaId, "error-popover", ouiaSafe)),
        React.createElement(Button, { variant: "link", isInline: true }, WorkflowInstanceIconCreator(workflowInstanceData.state))));
};
export default ErrorPopover;
//# sourceMappingURL=ErrorPopover.js.map