"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.isWorkflowJSONFile = exports.isDashbuilderEditor = exports.isKieEditorWithDualView = exports.isKieEditorWithSingleView = exports.getDashbuilderExtensionsRegExp = exports.getDualViewExtensionsRegExp = exports.getSingleViewExtensionsRegExp = void 0;
var JSON_EXTENSIONS = ".json";
var YAML_EXTENSIONS = ".ya?ml";
var BPMN_EXTENSIONS = ".bpmn";
var DMN_EXTENSIONS = ".dmn";
var SCESIM_EXTENSIONS = ".scesim";
var PMML_EXTENSIONS = ".pmml";
var SERVERLESS_WORKFLOW_JSON_EXTENSION = ".sw(".concat(JSON_EXTENSIONS, ")");
var SERVERLESS_WORKFLOW_EXTENSIONS = ".sw(".concat(JSON_EXTENSIONS, "|").concat(YAML_EXTENSIONS, ")");
var DASHBUILDER_EXTENSIONS = ".dash(".concat(JSON_EXTENSIONS, "|").concat(YAML_EXTENSIONS, ")");
var YARD_EXTENSIONS = ".yard(".concat(JSON_EXTENSIONS, "|").concat(YAML_EXTENSIONS, ")");
function getSingleViewExtensionsRegExp() {
    return new RegExp("".concat(BPMN_EXTENSIONS, "|").concat(DMN_EXTENSIONS, "|").concat(SCESIM_EXTENSIONS, "|").concat(PMML_EXTENSIONS, "$"));
}
exports.getSingleViewExtensionsRegExp = getSingleViewExtensionsRegExp;
function getDualViewExtensionsRegExp() {
    return new RegExp("".concat(SERVERLESS_WORKFLOW_EXTENSIONS, "|").concat(DASHBUILDER_EXTENSIONS, "|").concat(YARD_EXTENSIONS, "$"));
}
exports.getDualViewExtensionsRegExp = getDualViewExtensionsRegExp;
function getDashbuilderExtensionsRegExp() {
    return new RegExp("".concat(DASHBUILDER_EXTENSIONS, "$"));
}
exports.getDashbuilderExtensionsRegExp = getDashbuilderExtensionsRegExp;
function isKieEditorWithSingleView(fileName) {
    return getSingleViewExtensionsRegExp().test(fileName);
}
exports.isKieEditorWithSingleView = isKieEditorWithSingleView;
function isKieEditorWithDualView(fileName) {
    return getDualViewExtensionsRegExp().test(fileName);
}
exports.isKieEditorWithDualView = isKieEditorWithDualView;
function isDashbuilderEditor(fileName) {
    return getDashbuilderExtensionsRegExp().test(fileName);
}
exports.isDashbuilderEditor = isDashbuilderEditor;
function isWorkflowJSONFile(fileName) {
    return new RegExp("".concat(SERVERLESS_WORKFLOW_JSON_EXTENSION, "$")).test(fileName);
}
exports.isWorkflowJSONFile = isWorkflowJSONFile;
//# sourceMappingURL=KieFileExtensions.js.map